/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import io.airlift.slice.SizeOf;
import io.trino.filesystem.FileEntry;
import java.util.List;
import java.util.Objects;

public class BlockLocation {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(BlockLocation.class);
    private static final Interner<String> HOST_INTERNER = Interners.newWeakInterner();
    private final List<String> hosts;
    private final long offset;
    private final long length;

    public BlockLocation(FileEntry.Block block) {
        this.hosts = (List)block.hosts().stream().map(arg_0 -> HOST_INTERNER.intern(arg_0)).collect(ImmutableList.toImmutableList());
        this.offset = block.offset();
        this.length = block.length();
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.sizeOfObjectArray((int)this.hosts.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockLocation that = (BlockLocation)o;
        return this.offset == that.offset && this.length == that.length && this.hosts.equals(that.hosts);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.offset, this.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hosts", this.hosts).add("offset", this.offset).add("length", this.length).toString();
    }
}

