/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.util.ValidTxnWriteIdList;
import io.trino.spi.connector.SchemaTableName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;

public class HiveTransaction {
    private final String queryId;
    private final long transactionId;
    private final ScheduledFuture<?> heartbeatTask;
    private final AcidTransaction transaction;
    private final Map<SchemaTableName, ValidTxnWriteIdList> validHiveTransactionsForTable = new HashMap<SchemaTableName, ValidTxnWriteIdList>();

    public HiveTransaction(String queryId, long transactionId, ScheduledFuture<?> heartbeatTask, AcidTransaction transaction) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.transactionId = transactionId;
        this.heartbeatTask = Objects.requireNonNull(heartbeatTask, "heartbeatTask is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public ScheduledFuture<?> getHeartbeatTask() {
        return this.heartbeatTask;
    }

    public AcidTransaction getTransaction() {
        return this.transaction;
    }

    public ValidTxnWriteIdList getValidWriteIds(AcidTransactionOwner transactionOwner, HiveMetastore metastore, HiveTableHandle tableHandle) {
        Object lockedPartitions;
        ImmutableList lockedTables;
        if (tableHandle.getPartitionColumns().isEmpty() || tableHandle.getPartitions().isEmpty()) {
            lockedTables = ImmutableList.of((Object)tableHandle.getSchemaTableName());
            lockedPartitions = ImmutableList.of();
        } else {
            lockedTables = ImmutableList.of();
            lockedPartitions = tableHandle.getPartitions().get();
        }
        metastore.acquireSharedReadLock(transactionOwner, this.queryId, this.transactionId, (List)lockedTables, (List)lockedPartitions);
        return this.validHiveTransactionsForTable.computeIfAbsent(tableHandle.getSchemaTableName(), schemaTableName -> new ValidTxnWriteIdList(metastore.getValidWriteIds((List)ImmutableList.of((Object)schemaTableName), this.transactionId)));
    }
}

