/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.spi.security.PrincipalType;
import java.util.Objects;

public class PermissionMetadata {
    private final HivePrivilegeInfo.HivePrivilege permission;
    private final boolean grantOption;
    private final HivePrincipal grantee;

    @JsonCreator
    public PermissionMetadata(@JsonProperty(value="permission") HivePrivilegeInfo.HivePrivilege permission, @JsonProperty(value="grantOption") boolean grantOption, @JsonProperty(value="grantee") HivePrincipal grantee) {
        this.permission = Objects.requireNonNull(permission, "permission is null");
        this.grantOption = grantOption;
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    @JsonProperty
    public HivePrivilegeInfo.HivePrivilege getPermission() {
        return this.permission;
    }

    @JsonProperty
    public boolean isGrantOption() {
        return this.grantOption;
    }

    @JsonProperty
    public HivePrincipal getGrantee() {
        return this.grantee;
    }

    public HivePrivilegeInfo toHivePrivilegeInfo() {
        return new HivePrivilegeInfo(this.permission, this.grantOption, new HivePrincipal(PrincipalType.USER, "admin"), this.grantee);
    }
}

