/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.UserDefinedFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.hive.thrift.metastore.ResourceType;
import io.trino.hive.thrift.metastore.ResourceUri;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.glue.v1.Memoizers;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.security.PrincipalType;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class GlueToTrinoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";

    private GlueToTrinoConverter() {
    }

    @SuppressModernizer
    public static Optional<StorageDescriptor> getStorageDescriptor(Table glueTable) {
        return Optional.ofNullable(glueTable.getStorageDescriptor());
    }

    @SuppressModernizer
    public static Map<String, String> getColumnParameters(Column glueColumn) {
        return (Map)MoreObjects.firstNonNull((Object)glueColumn.getParameters(), (Object)ImmutableMap.of());
    }

    public static String getTableType(Table glueTable) {
        return (String)MoreObjects.firstNonNull((Object)GlueToTrinoConverter.getTableTypeNullable(glueTable), (Object)TableType.EXTERNAL_TABLE.name());
    }

    @Nullable
    @SuppressModernizer
    public static String getTableTypeNullable(Table glueTable) {
        return glueTable.getTableType();
    }

    @SuppressModernizer
    public static Map<String, String> getTableParameters(Table glueTable) {
        return (Map)MoreObjects.firstNonNull((Object)glueTable.getParameters(), (Object)ImmutableMap.of());
    }

    @SuppressModernizer
    public static Map<String, String> getPartitionParameters(Partition gluePartition) {
        return (Map)MoreObjects.firstNonNull((Object)gluePartition.getParameters(), (Object)ImmutableMap.of());
    }

    @SuppressModernizer
    public static Map<String, String> getSerDeInfoParameters(SerDeInfo glueSerDeInfo) {
        return (Map)MoreObjects.firstNonNull((Object)glueSerDeInfo.getParameters(), (Object)ImmutableMap.of());
    }

    public static io.trino.metastore.Database convertDatabase(Database glueDb) {
        return io.trino.metastore.Database.builder().setDatabaseName(glueDb.getName()).setLocation(Optional.ofNullable(Strings.emptyToNull((String)glueDb.getLocationUri()))).setComment(Optional.ofNullable(glueDb.getDescription())).setParameters((Map)MoreObjects.firstNonNull((Object)glueDb.getParameters(), (Object)ImmutableMap.of())).setOwnerName(Optional.of(PUBLIC_OWNER)).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    }

    public static io.trino.metastore.Table convertTable(Table glueTable, String dbName) {
        SchemaTableName table = new SchemaTableName(dbName, glueTable.getName());
        String tableType = GlueToTrinoConverter.getTableType(glueTable);
        ImmutableMap.Builder parameters = ImmutableMap.builder();
        Optional<String> description = Optional.ofNullable(glueTable.getDescription());
        description.ifPresent(comment -> parameters.put((Object)"comment", comment));
        GlueToTrinoConverter.getTableParameters(glueTable).entrySet().stream().filter(entry -> description.isEmpty() || !((String)entry.getKey()).equals("comment")).forEach(arg_0 -> ((ImmutableMap.Builder)parameters).put(arg_0));
        ImmutableMap tableParameters = parameters.buildOrThrow();
        Table.Builder tableBuilder = io.trino.metastore.Table.builder().setDatabaseName(table.getSchemaName()).setTableName(table.getTableName()).setOwner(Optional.ofNullable(glueTable.getOwner())).setTableType(tableType).setParameters((Map)tableParameters).setViewOriginalText(Optional.ofNullable(glueTable.getViewOriginalText())).setViewExpandedText(Optional.ofNullable(glueTable.getViewExpandedText()));
        Optional<StorageDescriptor> storageDescriptor = GlueToTrinoConverter.getStorageDescriptor(glueTable);
        if (HiveUtil.isIcebergTable((Map<String, String>)tableParameters) || storageDescriptor.isEmpty() && ViewReaderUtil.isTrinoMaterializedView(tableType, (Map<String, String>)tableParameters)) {
            tableBuilder.setDataColumns((List)ImmutableList.of((Object)new io.trino.metastore.Column("dummy", HiveType.HIVE_INT, Optional.empty(), (Map)ImmutableMap.of())));
            tableBuilder.getStorageBuilder().setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat());
        } else if (HiveUtil.isDeltaLakeTable((Map<String, String>)tableParameters)) {
            tableBuilder.setDataColumns((List)ImmutableList.of((Object)new io.trino.metastore.Column("dummy", HiveType.HIVE_INT, Optional.empty(), (Map)ImmutableMap.of())));
            tableBuilder.setPartitionColumns((List)ImmutableList.of());
            if (storageDescriptor.isEmpty()) {
                tableBuilder.getStorageBuilder().setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat());
            } else {
                StorageDescriptor sd = storageDescriptor.get();
                if (sd.getSerdeInfo() == null) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table SerdeInfo is null for table '%s' %s".formatted(table, glueTable));
                }
                new StorageConverter().setStorageBuilder(sd, tableBuilder.getStorageBuilder());
            }
        } else {
            if (storageDescriptor.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table StorageDescriptor is null for table '%s' %s".formatted(table, glueTable));
            }
            StorageDescriptor sd = storageDescriptor.get();
            if (sd.getSerdeInfo() == null) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table SerdeInfo is null for table '%s' %s".formatted(table, glueTable));
            }
            boolean isCsv = HiveStorageFormat.CSV.getSerde().equals(sd.getSerdeInfo().getSerializationLibrary());
            tableBuilder.setDataColumns(GlueToTrinoConverter.convertColumns(table, sd.getColumns(), ColumnType.DATA, isCsv));
            if (glueTable.getPartitionKeys() != null) {
                tableBuilder.setPartitionColumns(GlueToTrinoConverter.convertColumns(table, glueTable.getPartitionKeys(), ColumnType.PARTITION, isCsv));
            } else {
                tableBuilder.setPartitionColumns((List)ImmutableList.of());
            }
            new StorageConverter().setStorageBuilder(sd, tableBuilder.getStorageBuilder());
        }
        return tableBuilder.build();
    }

    private static io.trino.metastore.Column convertColumn(SchemaTableName table, Column glueColumn, ColumnType columnType, boolean isCsv) {
        if (columnType == ColumnType.DATA && isCsv) {
            return new io.trino.metastore.Column(glueColumn.getName(), HiveType.HIVE_STRING, Optional.ofNullable(glueColumn.getComment()), GlueToTrinoConverter.getColumnParameters(glueColumn));
        }
        return new io.trino.metastore.Column(glueColumn.getName(), GlueToTrinoConverter.convertType(table, glueColumn), Optional.ofNullable(glueColumn.getComment()), GlueToTrinoConverter.getColumnParameters(glueColumn));
    }

    private static HiveType convertType(SchemaTableName table, Column column) {
        try {
            return HiveType.valueOf((String)column.getType().toLowerCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Glue table '%s' column '%s' has invalid data type: %s".formatted(table, column.getName(), column.getType()), (Throwable)e);
        }
    }

    private static List<io.trino.metastore.Column> convertColumns(SchemaTableName table, List<Column> glueColumns, ColumnType columnType, boolean isCsv) {
        return GlueToTrinoConverter.mappedCopy(glueColumns, glueColumn -> GlueToTrinoConverter.convertColumn(table, glueColumn, columnType, isCsv));
    }

    private static Function<Map<String, String>, Map<String, String>> parametersConverter() {
        return Memoizers.memoizeLast(ImmutableMap::copyOf);
    }

    private static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static LanguageFunction convertFunction(UserDefinedFunction function) {
        List<ResourceUri> uris = GlueToTrinoConverter.mappedCopy(function.getResourceUris(), uri -> new ResourceUri(ResourceType.FILE, uri.getUri()));
        LanguageFunction result = ThriftMetastoreUtil.decodeFunction(function.getFunctionName(), uris);
        return new LanguageFunction(result.signatureToken(), result.sql(), result.path(), Optional.ofNullable(function.getOwnerName()));
    }

    public static <T, R> List<R> mappedCopy(List<T> list, Function<T, R> mapper) {
        Objects.requireNonNull(list, "list is null");
        Objects.requireNonNull(mapper, "mapper is null");
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (T item : list) {
            builder.add(mapper.apply(item));
        }
        return builder.build();
    }

    private static final class StorageConverter {
        private final Function<List<String>, List<String>> bucketColumns = Memoizers.memoizeLast(ImmutableList::copyOf);
        private final Function<List<Order>, List<SortingColumn>> sortColumns = Memoizers.memoizeLast(StorageConverter::createSortingColumns);
        private final UnaryOperator<Optional<HiveBucketProperty>> bucketProperty = Memoizers.memoizeLast();
        private final Function<Map<String, String>, Map<String, String>> serdeParametersConverter = GlueToTrinoConverter.parametersConverter();
        private final StorageFormatConverter storageFormatConverter = new StorageFormatConverter();

        private StorageConverter() {
        }

        public void setStorageBuilder(StorageDescriptor sd, Storage.Builder storageBuilder) {
            Objects.requireNonNull(sd.getSerdeInfo(), "StorageDescriptor SerDeInfo is null");
            SerDeInfo serdeInfo = sd.getSerdeInfo();
            storageBuilder.setStorageFormat(this.storageFormatConverter.createStorageFormat(serdeInfo, sd)).setLocation(Strings.nullToEmpty((String)sd.getLocation())).setBucketProperty(this.convertToBucketProperty(sd)).setSkewed(sd.getSkewedInfo() != null && !GlueToTrinoConverter.isNullOrEmpty(sd.getSkewedInfo().getSkewedColumnNames())).setSerdeParameters(this.serdeParametersConverter.apply(GlueToTrinoConverter.getSerDeInfoParameters(serdeInfo))).build();
        }

        private Optional<HiveBucketProperty> convertToBucketProperty(StorageDescriptor sd) {
            if (sd.getNumberOfBuckets() > 0) {
                if (GlueToTrinoConverter.isNullOrEmpty(sd.getBucketColumns())) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set");
                }
                List<String> bucketColumns = this.bucketColumns.apply(sd.getBucketColumns());
                List<SortingColumn> sortedBy = this.sortColumns.apply(sd.getSortColumns());
                return (Optional)this.bucketProperty.apply(Optional.of(new HiveBucketProperty(bucketColumns, sd.getNumberOfBuckets().intValue(), sortedBy)));
            }
            return Optional.empty();
        }

        private static List<SortingColumn> createSortingColumns(List<Order> sortColumns) {
            if (GlueToTrinoConverter.isNullOrEmpty(sortColumns)) {
                return ImmutableList.of();
            }
            return GlueToTrinoConverter.mappedCopy(sortColumns, column -> new SortingColumn(column.getColumn(), SortingColumn.Order.fromMetastoreApiOrder((int)column.getSortOrder(), (String)"unknown")));
        }
    }

    private static enum ColumnType {
        DATA,
        PARTITION;

    }

    private static final class StorageFormatConverter {
        private static final StorageFormat ALL_NULLS = StorageFormat.createNullable(null, null, null);
        private final UnaryOperator<String> serializationLib = Memoizers.memoizeLast();
        private final UnaryOperator<String> inputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<String> outputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<StorageFormat> storageFormat = Memoizers.memoizeLast();

        private StorageFormatConverter() {
        }

        public StorageFormat createStorageFormat(SerDeInfo serdeInfo, StorageDescriptor storageDescriptor) {
            String serializationLib = (String)this.serializationLib.apply(serdeInfo.getSerializationLibrary());
            String inputFormat = (String)this.inputFormat.apply(storageDescriptor.getInputFormat());
            String outputFormat = (String)this.outputFormat.apply(storageDescriptor.getOutputFormat());
            if (serializationLib == null && inputFormat == null && outputFormat == null) {
                return ALL_NULLS;
            }
            return (StorageFormat)this.storageFormat.apply(StorageFormat.createNullable((String)serializationLib, (String)inputFormat, (String)outputFormat));
        }
    }

    public static final class GluePartitionConverter
    implements Function<Partition, io.trino.metastore.Partition> {
        private final BiFunction<List<Column>, Boolean, List<io.trino.metastore.Column>> dataColumnsConverter;
        private final Function<Map<String, String>, Map<String, String>> parametersConverter = GlueToTrinoConverter.parametersConverter();
        private final StorageConverter storageConverter = new StorageConverter();
        private final String databaseName;
        private final String tableName;

        public GluePartitionConverter(String databaseName, String tableName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.dataColumnsConverter = Memoizers.memoizeLast((glueColumns, isCsv) -> GlueToTrinoConverter.convertColumns(new SchemaTableName(databaseName, tableName), glueColumns, ColumnType.DATA, isCsv));
        }

        @Override
        public io.trino.metastore.Partition apply(Partition gluePartition) {
            Objects.requireNonNull(gluePartition.getStorageDescriptor(), "Partition StorageDescriptor is null");
            StorageDescriptor sd = gluePartition.getStorageDescriptor();
            if (!this.databaseName.equals(gluePartition.getDatabaseName())) {
                throw new IllegalArgumentException(String.format("Unexpected databaseName, expected: %s, but found: %s", this.databaseName, gluePartition.getDatabaseName()));
            }
            if (!this.tableName.equals(gluePartition.getTableName())) {
                throw new IllegalArgumentException(String.format("Unexpected tableName, expected: %s, but found: %s", this.tableName, gluePartition.getTableName()));
            }
            boolean isCsv = sd.getSerdeInfo() != null && HiveStorageFormat.CSV.getSerde().equals(sd.getSerdeInfo().getSerializationLibrary());
            Partition.Builder partitionBuilder = io.trino.metastore.Partition.builder().setDatabaseName(this.databaseName).setTableName(this.tableName).setValues(gluePartition.getValues()).setColumns(this.dataColumnsConverter.apply(sd.getColumns(), isCsv)).setParameters(this.parametersConverter.apply(GlueToTrinoConverter.getPartitionParameters(gluePartition)));
            this.storageConverter.setStorageBuilder(sd, partitionBuilder.getStorageBuilder());
            return partitionBuilder.build();
        }
    }
}

