/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.airlift.slice.Slice;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.orc.AbstractOrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.util.Objects;

public class HdfsOrcDataSource
extends AbstractOrcDataSource {
    private final TrinoInput input;
    private final FileFormatDataSourceStats stats;

    public HdfsOrcDataSource(OrcDataSourceId id, long size, OrcReaderOptions options, TrinoInputFile inputFile, FileFormatDataSourceStats stats) throws IOException {
        super(id, size, options);
        this.input = Objects.requireNonNull(inputFile, "inputFile is null").newInput();
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public void close() throws IOException {
        this.input.close();
    }

    protected Slice readTailInternal(int length) throws IOException {
        long readStart = System.nanoTime();
        Slice tailSlice = this.input.readTail(length);
        this.stats.readDataBytesPerSecond((long)tailSlice.length(), System.nanoTime() - readStart);
        return tailSlice;
    }

    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        try {
            long readStart = System.nanoTime();
            this.input.readFully(position, buffer, bufferOffset, bufferLength);
            this.stats.readDataBytesPerSecond((long)bufferLength, System.nanoTime() - readStart);
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Error reading from %s at position %s", new Object[]{this, position});
            if (e instanceof IOException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, message, (Throwable)e);
        }
    }
}

