/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

public enum AcidBucketCodec {
    V0{

        @Override
        public int decodeWriterId(int bucketProperty) {
            return bucketProperty;
        }

        @Override
        public int decodeStatementId(int bucketProperty) {
            return 0;
        }
    }
    ,
    V1{

        @Override
        public int decodeWriterId(int bucketProperty) {
            return (bucketProperty & 0xFFF0000) >>> 16;
        }

        @Override
        public int decodeStatementId(int bucketProperty) {
            return bucketProperty & 0xFFF;
        }
    };

    private static final int V1_STATEMENT_ID_MASK = 4095;
    private static final int V1_WRITER_ID_MASK = 0xFFF0000;
    private static final int CODEC_VERSION_MASK = -536870912;

    public static AcidBucketCodec forBucket(int bucket) {
        int version = (0xE0000000 & bucket) >>> 29;
        return switch (version) {
            case 0 -> V0;
            case 1 -> V1;
            default -> throw new IllegalArgumentException("Invalid bucket 0x%08X. Version=%s".formatted(bucket, version));
        };
    }

    public abstract int decodeWriterId(int var1);

    public abstract int decodeStatementId(int var1);
}

