/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.Options;
import net.datafaker.providers.base.PersonIdNumber;

public class MexicanIdNumber
implements IdNumberGenerator {
    private static final String[] CHA = new String[]{"HEFA560427MVZRRL04", "DKEM193827HDQWEF05", "KAKS142444HNSSFAW6", "KSDF414424HNSDFAW6", "AKDF414424MSDSFAW6", "ADKF144424MNSDFCD6", "MYDF144424MDNFAW37", "AKKS414424MDAFDFW6", "WKDF144244HSDCNFA2", "AKSK414244HSDATT56", "QWDF414424HNSDVAW4", "AKDF144424MDEFVFA1"};
    private static final char[] CONSONANT = new char[]{'B', 'C', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'L', 'M', 'N', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] VOWEL = new char[]{'A', 'E', 'I', 'O', 'U'};
    private static final String[] STATES = new String[]{"AG", "BC", "BS", "CM", "CS", "CH", "CO", "CL", "DF", "DG", "GT", "GR", "HG", "JA", "EM", "MI", "MO", "NA", "NL", "OA", "PU", "QT", "QR", "SL", "SI", "SO", "TB", "TM", "TL", "VE", "YU", "ZA", "NE"};

    @Override
    public String countryCode() {
        return "MX";
    }

    @Deprecated
    public String get(BaseProviders faker) {
        return this.generateValid(faker);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        LocalDate birthday = Utils.birthday(faker, request);
        char[] birthDay = this.formatBirthday(birthday).toCharArray();
        char[] ssn = new char[18];
        Options options = faker.options();
        ssn[0] = options.option(CONSONANT);
        ssn[1] = options.option(VOWEL);
        ssn[2] = options.option(CONSONANT);
        ssn[3] = options.option(CONSONANT);
        System.arraycopy(birthDay, 0, ssn, 4, 6);
        ssn[10] = this.genderCharacter(gender);
        System.arraycopy(options.option(STATES).toCharArray(), 0, ssn, 11, 2);
        ssn[13] = options.option(VOWEL);
        ssn[14] = options.option(VOWEL);
        ssn[15] = options.option(VOWEL);
        ssn[16] = birthDay[0] == '1' ? 48 : (int)options.option(CONSONANT);
        ssn[17] = String.valueOf(this.getChecksum(ssn)).charAt(0);
        return new PersonIdNumber(String.valueOf(ssn), birthday, gender);
    }

    private char genderCharacter(PersonIdNumber.Gender gender) {
        return switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> 'M';
            case PersonIdNumber.Gender.MALE -> 'H';
        };
    }

    @Deprecated
    public String getWrong(BaseProviders faker) {
        return this.generateInvalid(faker);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        return faker.options().option(CHA);
    }

    private String formatBirthday(LocalDate birthday) {
        return String.valueOf(birthday.getYear() * 10000 + birthday.getMonthValue() * 100 + birthday.getDayOfMonth());
    }

    private int getChecksum(char[] str) {
        int sum = 0;
        int v = str.length;
        for (int i = 0; i < str.length - 1; ++i) {
            int number = str[i] < '9' ? str[i] - 48 : str[i] - 65 + 10;
            sum += number * v--;
        }
        return (sum = Math.abs(sum % 10 - 10)) == 10 ? 0 : sum;
    }
}

