/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class MoldovanIdNumber
implements IdNumberGenerator {
    private static final int[] CHECKSUM_MASK = new int[]{7, 3, 1, 7, 3, 1, 7, 3, 1, 7, 3, 1};

    @Override
    public String countryCode() {
        return "MD";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        String basePart = this.basePart(faker, birthday);
        String idNumber = basePart + this.checksum(basePart);
        return new PersonIdNumber(idNumber, birthday, Utils.randomGender(faker));
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        String basePart = this.basePart(faker, faker.timeAndDate().birthday());
        return basePart + (this.checksum(basePart) + '\u0001') % 10;
    }

    private String basePart(BaseProviders faker, LocalDate birthday) {
        return this.firstDigit() + this.\u0413\u0413\u0413(birthday) + this.XXX(faker) + this.YYYYY(faker);
    }

    private char firstDigit() {
        return '2';
    }

    private String \u0413\u0413\u0413(LocalDate birthday) {
        return "%03d".formatted(birthday.getYear() % 1000);
    }

    private String XXX(BaseProviders faker) {
        return faker.number().digits(3);
    }

    private String YYYYY(BaseProviders faker) {
        return faker.number().digits(5);
    }

    char checksum(String text) {
        int checksum = Utils.multiply(text, CHECKSUM_MASK);
        return (char)(48 + checksum % 10);
    }
}

