/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.internal.helper;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class CopyOnWriteMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> map;
    private final Supplier<Map<K, V>> mapSupplier;

    public CopyOnWriteMap(Supplier<Map<K, V>> mapSupplier) {
        this.mapSupplier = mapSupplier;
        this.map = mapSupplier.get();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException("Avoid pattern 'get+put'. Use computeIfAbsent instead.");
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(value, () -> "value is null for key " + key);
        Map<K, V> newMap = this.mapSupplier.get();
        newMap.putAll(this.map);
        V result = newMap.put(key, value);
        this.map = newMap;
        return result;
    }

    @Override
    public V remove(Object key) {
        Map<K, V> newMap = this.mapSupplier.get();
        newMap.putAll(this.map);
        V result = newMap.remove(key);
        this.map = newMap;
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Map<Object, Object> newMap = this.mapSupplier.get();
        newMap.putAll(this.map);
        newMap.putAll(m);
        this.map = newMap;
    }

    @Override
    public void clear() {
        this.map = this.mapSupplier.get();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        return Objects.requireNonNullElse(v, defaultValue);
    }
}

