/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Barcode
extends AbstractProvider<BaseProviders> {
    public Barcode(BaseProviders faker) {
        super(faker);
    }

    public long ean13() {
        return this.ean(13);
    }

    public long ean8() {
        return this.ean(8);
    }

    public long gtin14() {
        return this.ean(14);
    }

    public long gtin12() {
        return this.ean(12);
    }

    public long gtin13() {
        return this.ean13();
    }

    public long gtin8() {
        return this.ean8();
    }

    private static int roundToHighestMultiplyOfTen(int number) {
        if (number % 10 == 0) {
            return number;
        }
        int ones = number % 10;
        int add = 10 - ones;
        return number + add;
    }

    private long ean(int length) {
        int product;
        long firstPart = switch (length) {
            case 8, 12, 13, 14 -> ((BaseProviders)this.faker).number().randomNumber(length - 1);
            default -> 0L;
        };
        int odd = 0;
        int even = 0;
        int i = 0;
        for (long number = firstPart; number > 0L; number /= 10L) {
            if (++i % 2 == 1) {
                odd = (int)((long)odd + number % 10L);
                continue;
            }
            even = (int)((long)even + number % 10L);
        }
        if (i % 2 == 0) {
            int tmp = even;
            even = odd;
            odd = tmp;
        }
        int var = this.calculateVar(length, odd, even);
        int rounded = Barcode.roundToHighestMultiplyOfTen(var);
        int checkDigit = rounded - var;
        for (product = 10; product <= checkDigit; product *= 10) {
        }
        return firstPart * (long)product + (long)checkDigit;
    }

    private int calculateVar(int length, int odd, int even) {
        return switch (length) {
            case 13 -> odd + even + (even << 1);
            case 8, 12, 14 -> odd + even + (odd << 1);
            default -> 0;
        };
    }

    public String type() {
        return this.resolve("barcode.types");
    }
}

