/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.List;
import java.util.stream.Collectors;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Code
extends AbstractProvider<BaseProviders> {
    private static final int[] GTIN_8_CHECK_DIGITS = new int[]{3, 1, 3, 1, 3, 1, 3};
    private static final int[] GTIN_13_CHECK_DIGITS = new int[]{1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3};
    private static final String[] REPORTING_BODY_IDENTIFIERS = new String[]{"01", "10", "30", "33", "35", "44", "45", "49", "50", "51", "52", "53", "54", "86", "91", "98", "99"};

    protected Code(BaseProviders faker) {
        super(faker);
    }

    public String isbnGs1() {
        return ((BaseProviders)this.faker).options().option("978", "979");
    }

    public String isbnGroup() {
        return ((BaseProviders)this.faker).options().option("0", "1");
    }

    public String isbnRegistrant() {
        int ct = ((BaseProviders)this.faker).random().nextInt(6) + 1;
        return switch (ct) {
            case 6 -> ((BaseProviders)this.faker).number().numberBetween(0, 1) + ((BaseProviders)this.faker).number().digit() + "-" + ((BaseProviders)this.faker).number().digits(6);
            case 5 -> ((BaseProviders)this.faker).number().numberBetween(200, 699) + "-" + ((BaseProviders)this.faker).number().digits(5);
            case 4 -> ((BaseProviders)this.faker).number().numberBetween(7000, 8499) + "-" + ((BaseProviders)this.faker).number().digits(4);
            case 3 -> ((BaseProviders)this.faker).number().numberBetween(85000, 89999) + "-" + ((BaseProviders)this.faker).number().digits(3);
            case 2 -> ((BaseProviders)this.faker).number().numberBetween(900000, 949999) + "-" + ((BaseProviders)this.faker).number().digits(2);
            case 1 -> ((BaseProviders)this.faker).number().numberBetween(9500000, 9999999) + "-" + ((BaseProviders)this.faker).number().digits(1);
            default -> throw new IllegalStateException("Invalid random " + ct);
        };
    }

    public String isbn10() {
        return this.isbn10(false);
    }

    public String isbn10(boolean separator) {
        StringBuilder isbn10;
        int checkDigit = this.isbn10CheckDigit(isbn10 = new StringBuilder().append(((BaseProviders)this.faker).expression("#{code.isbn_group}")).append('-').append(((BaseProviders)this.faker).expression("#{code.isbn_registrant}")).append('-'));
        isbn10.append(checkDigit != 10 ? Integer.valueOf(checkDigit) : "X");
        return separator ? isbn10.toString() : this.stripIsbnSeparator(isbn10);
    }

    public String isbn13() {
        return this.isbn13(false);
    }

    public String isbn13(boolean separator) {
        StringBuilder isbn13 = new StringBuilder().append(((BaseProviders)this.faker).expression("#{code.isbn_gs1}")).append('-').append(((BaseProviders)this.faker).expression("#{code.isbn_group}")).append('-').append(((BaseProviders)this.faker).expression("#{code.isbn_registrant}")).append('-');
        int checkDigit = this.isbn13CheckDigit(isbn13);
        isbn13.append(checkDigit);
        return separator ? isbn13.toString() : this.stripIsbnSeparator(isbn13);
    }

    private int isbn10CheckDigit(CharSequence t) {
        String value = this.stripIsbnSeparator(t);
        int sum = 0;
        for (int i = 0; i < value.length(); ++i) {
            sum += (i + 1) * Integer.parseInt(value.substring(i, i + 1));
        }
        return sum % 11;
    }

    private int isbn13CheckDigit(CharSequence t) {
        String value = this.stripIsbnSeparator(t);
        int sum = 0;
        for (int i = 0; i < value.length(); ++i) {
            int multiplier = i % 2 == 0 ? 1 : 3;
            sum += multiplier * Integer.parseInt(value.subSequence(i, i + 1).toString());
        }
        return (10 - sum % 10) % 10;
    }

    private String stripIsbnSeparator(CharSequence t) {
        return t.toString().replace("-", "");
    }

    public String asin() {
        return this.resolve("code.asin");
    }

    public String imei() {
        char[] str = new char[15];
        int len = str.length;
        String arr = ((BaseProviders)this.faker).options().option(REPORTING_BODY_IDENTIFIERS);
        str[0] = arr.charAt(0);
        str[1] = arr.charAt(1);
        for (int i = 2; i < len - 1; ++i) {
            str[i] = Character.forDigit(((BaseProviders)this.faker).number().numberBetween(0, 9), 10);
        }
        int lenOffset = (len + 1) % 2;
        int sum = 0;
        for (int i = 0; i < len - 1; ++i) {
            if ((i + lenOffset) % 2 != 0) {
                int t = Character.getNumericValue(str[i]) << 1;
                if (t > 9) {
                    t -= 9;
                }
                sum += t;
                continue;
            }
            sum += Character.getNumericValue(str[i]);
        }
        str[len - 1] = Character.forDigit((10 - sum % 10) % 10, 10);
        return new String(str);
    }

    public String ean8() {
        return this.gtin8();
    }

    public String gtin8() {
        return this.gtin("\\d{7}", GTIN_8_CHECK_DIGITS);
    }

    public String gtin13() {
        return this.gtin("\\d{12}", GTIN_13_CHECK_DIGITS);
    }

    public String ean13() {
        return this.gtin13();
    }

    private String gtin(String regex, int[] checkDigits) {
        List values = ((BaseProviders)this.faker).regexify(regex).chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        int sum = 0;
        for (int i = 0; i < values.size(); ++i) {
            sum += Character.getNumericValue(((Character)values.get(i)).charValue()) * checkDigits[i];
        }
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            values.add(Character.valueOf(Character.forDigit(0, 10)));
        } else {
            values.add(Character.valueOf(Character.forDigit(checkDigit, 10)));
        }
        return values.stream().map(String::valueOf).collect(Collectors.joining());
    }
}

