/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.service.Range;

public class Number
extends AbstractProvider<BaseProviders> {
    private static final char[] DIGITS = "0123456789".toCharArray();

    protected Number(BaseProviders faker) {
        super(faker);
    }

    public int randomDigit() {
        return ((BaseProviders)this.faker).random().nextInt(0, 9);
    }

    public int randomDigitNotZero() {
        return ((BaseProviders)this.faker).random().nextInt(1, 9);
    }

    public int positive() {
        return this.numberBetween(1, Integer.MAX_VALUE);
    }

    public int negative() {
        return this.numberBetween(0, Integer.MIN_VALUE);
    }

    public int numberBetween(int min, int max) {
        if (min == max) {
            return min;
        }
        int realMin = Math.min(min, max);
        int realMax = Math.max(min, max);
        int amplitude = realMax - realMin;
        if (amplitude >= 0) {
            return ((BaseProviders)this.faker).random().nextInt(amplitude) + realMin;
        }
        return (int)this.numberBetween((long)realMin, (long)realMax);
    }

    public double numberBetween(double min, double max) {
        return ((BaseProviders)this.faker).random().nextDouble(min, max);
    }

    public long numberBetween(long min, long max) {
        if (min == max) {
            return min;
        }
        long realMin = Math.min(min, max);
        long realMax = Math.max(min, max);
        long amplitude = realMax - realMin;
        if (amplitude >= 0L) {
            return ((BaseProviders)this.faker).random().nextLong(Range.inclusiveExclusive(realMin, realMax));
        }
        return this.decimalBetween(realMin, realMax).longValue();
    }

    @Deprecated
    public long randomNumber(int numberOfDigits, boolean strict) {
        return this.randomNumber(numberOfDigits);
    }

    public long randomNumber(int numberOfDigits) {
        if (numberOfDigits <= 0) {
            throw new IllegalArgumentException("Number of digits must be positive");
        }
        long min = this.pow(10L, numberOfDigits - 1);
        long max = min * 10L;
        return ((BaseProviders)this.faker).random().nextLong(min, max);
    }

    private long pow(long value, int d) {
        if (d == 0) {
            return 1L;
        }
        if (d == 1) {
            return value;
        }
        if ((d & 1) == 0) {
            long pow = this.pow(value, d >> 1);
            return pow * pow;
        }
        return value * this.pow(value, d - 1);
    }

    public long randomNumber() {
        return ((BaseProviders)this.faker).random().nextLong();
    }

    public double randomDouble(int maxNumberOfDecimals, int min, int max) {
        return this.randomDouble(maxNumberOfDecimals, (long)min, (long)max);
    }

    public double randomDouble(int maxNumberOfDecimals, long min, long max) {
        return this.decimalBetween(min, max).setScale(maxNumberOfDecimals, RoundingMode.HALF_DOWN).doubleValue();
    }

    private BigDecimal decimalBetween(long min, long max) {
        if (min == max) {
            return BigDecimal.valueOf(min);
        }
        BigDecimal trueMin = BigDecimal.valueOf(min);
        BigDecimal trueMax = BigDecimal.valueOf(max);
        BigDecimal random = BigDecimal.valueOf(((BaseProviders)this.faker).random().nextDouble());
        return trueMin.add(trueMax.subtract(trueMin).multiply(random));
    }

    public String digits(int count) {
        char[] tmp = new char[count];
        byte[] input = ((BaseProviders)this.faker).random().nextRandomBytes(count);
        for (int i = 0; i < input.length; ++i) {
            tmp[i] = DIGITS[Math.abs(input[i]) % 10];
        }
        return new String(tmp);
    }

    public String digit() {
        return this.digits(1);
    }
}

