/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.util.Locale;
import java.util.Objects;
import net.datafaker.annotations.Deterministic;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.PhoneNumberGenerator;

public class PhoneNumber
extends AbstractProvider<BaseProviders> {
    private final String countryCodeIso2;
    private final PhoneNumberGenerator generator;

    protected PhoneNumber(BaseProviders faker) {
        super(faker);
        this.countryCodeIso2 = PhoneNumber.countryCodeIso2(faker.getContext().getLocale());
        this.generator = new PhoneNumberGenerator(faker.fakeValuesService(), faker.getContext());
    }

    @Deterministic
    String countryCodeIso2() {
        return this.countryCodeIso2;
    }

    public String cellPhone() {
        return this.generator.randomPhoneNumber(this.countryCodeIso2, PhoneNumberUtil.PhoneNumberType.MOBILE, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
    }

    public String cellPhoneInternational() {
        return this.generator.randomPhoneNumber(this.countryCodeIso2, PhoneNumberUtil.PhoneNumberType.MOBILE, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
    }

    public String phoneNumber() {
        return this.phoneNumberNational();
    }

    public String phoneNumberInternational() {
        return this.generator.randomPhoneNumber(this.countryCodeIso2, PhoneNumberUtil.PhoneNumberType.FIXED_LINE, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
    }

    public String phoneNumberNational() {
        return this.generator.randomPhoneNumber(this.countryCodeIso2, PhoneNumberUtil.PhoneNumberType.FIXED_LINE, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
    }

    public String extension() {
        return this.subscriberNumber();
    }

    public String subscriberNumber(int length) {
        return ((BaseProviders)this.faker).numerify("#".repeat(Math.max(0, length)));
    }

    public String subscriberNumber() {
        return this.subscriberNumber(4);
    }

    private static String countryCodeIso2(Locale locale) {
        String country;
        return switch (country = Objects.requireNonNullElse(locale.getCountry(), "")) {
            case "" -> PhoneNumber.detectCountryByLanguage(locale.getLanguage());
            case "CAT" -> "ES";
            case "NEP" -> "NP";
            case "PAK" -> "PK";
            case "BORK" -> "US";
            default -> country;
        };
    }

    private static String detectCountryByLanguage(String language) {
        return switch (language) {
            case "en" -> "US";
            case "test" -> "US";
            case "hy" -> "AM";
            case "uk" -> "UA";
            case "ja" -> "JP";
            case "fa" -> "FR";
            case "ka" -> "GE";
            case "sq" -> "AL";
            case "cs" -> "CZ";
            case "be" -> "BY";
            case "ko" -> "KR";
            case "he" -> "IL";
            case "ta" -> "IN";
            default -> language.toUpperCase(Locale.ROOT);
        };
    }
}

