/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.model;

import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.CharList;

public class SymbolRange {
    private final int from;
    private final int to;

    public static SymbolRange range(int from, int to) {
        return new SymbolRange(from, to);
    }

    public static SymbolRange range(char from, char to) {
        return SymbolRange.range((int)from, (int)to);
    }

    private SymbolRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int size() {
        return this.to - this.from + 1;
    }

    public CharList chars() {
        return CharList.rangeClosed(this.from, this.to);
    }

    public boolean contains(int c) {
        return this.from <= c && c <= this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolRange range = (SymbolRange)o;
        if (this.from != range.from) {
            return false;
        }
        return this.to == range.to;
    }

    public int hashCode() {
        int result = this.from;
        result = 31 * result + this.to;
        return result;
    }

    public String toString() {
        return "SymbolRange{from=" + this.from + ", to=" + this.to + '}';
    }
}

