/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.util.chars;

import java.util.List;
import java.util.stream.Stream;
import net.datafaker.shaded.curiousoddman.rgxgen.model.SymbolRange;
import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.CharArrayList;
import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.CharPredicate;
import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.EmptyUnmodifiableCharList;

public abstract class CharList {
    public static CharList rangeClosed(int from, int to) {
        char[] arr = new char[to - from + 1];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (char)(from + i);
        }
        return new CharArrayList(arr);
    }

    public static CharList charList(List<SymbolRange> symbolRanges, char ... symbols) {
        int size = symbols.length + symbolRanges.stream().mapToInt(SymbolRange::size).sum();
        char[] arr = new char[size];
        System.arraycopy(symbols, 0, arr, 0, symbols.length);
        int index = symbols.length;
        for (SymbolRange symbolRange : symbolRanges) {
            for (int i = symbolRange.getFrom(); i <= symbolRange.getTo(); ++i) {
                arr[index] = (char)i;
                ++index;
            }
        }
        return new CharArrayList(arr);
    }

    public static CharList charList(char ... chars) {
        return new CharArrayList(chars);
    }

    public static CharList ofCapacity(int size) {
        return new CharArrayList(size);
    }

    public static CharList charList(String characterString) {
        return new CharArrayList(characterString.toCharArray());
    }

    public static CharList emptyUnmodifiable() {
        return new EmptyUnmodifiableCharList();
    }

    public static CharList empty() {
        return new CharArrayList(10);
    }

    public abstract CharList copy();

    public abstract void add(int var1);

    public abstract Stream<Character> stream();

    public abstract void addAll(CharList var1);

    public abstract void addAll(char[] var1);

    public abstract void addAll(char[] var1, int var2);

    public abstract int size();

    public abstract char get(int var1);

    public abstract boolean isEmpty();

    public abstract void sort();

    public abstract CharList except(CharPredicate var1);

    public abstract boolean contains(char var1);

    public abstract void appendTo(CharList var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharList)) {
            return false;
        }
        CharList that = (CharList)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == that.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + this.get(i);
        }
        result = 31 * result + this.size();
        return result;
    }
}

