/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.datafaker.transformations.Field;

public class SimpleField<MyObject, MyType>
implements Field<MyObject, MyType> {
    private final String name;
    private final Function<MyObject, MyType> transform;
    private final Supplier<MyType> supplier;

    protected SimpleField(String name, Function<MyObject, MyType> transform) {
        this(name, transform, null);
    }

    protected SimpleField(String name, Supplier<MyType> supplier) {
        this(name, null, supplier);
    }

    private SimpleField(String name, Function<MyObject, MyType> transform, Supplier<MyType> supplier) {
        this.name = name;
        this.transform = transform;
        this.supplier = supplier;
        if (this.transform == null && this.supplier == null) {
            throw new IllegalArgumentException("Either transform or supplier should be non-null");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MyType transform(MyObject input) {
        if (this.transform == null) {
            return this.supplier.get();
        }
        if (input == null) {
            throw new IllegalArgumentException("Input could be null only if suppliers are defined");
        }
        return this.transform.apply(input);
    }

    public Function<MyObject, MyType> getTransform() {
        return this.transform;
    }

    public Supplier<MyType> getSupplier() {
        return this.supplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleField)) {
            return false;
        }
        SimpleField that = (SimpleField)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.transform, that.transform)) {
            return false;
        }
        return Objects.equals(this.supplier, that.supplier);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

