/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.util.stream.Stream;
import net.datafaker.transformations.Schema;

public interface Transformer<IN, OUT> {
    public static final String LINE_SEPARATOR = System.lineSeparator();

    public OUT apply(IN var1, Schema<IN, ?> var2);

    default public OUT apply(IN input, Schema<IN, ?> schema, long rowId) {
        return this.apply(input, schema);
    }

    public OUT generate(Iterable<IN> var1, Schema<IN, ?> var2);

    public OUT generate(Schema<IN, ?> var1, int var2);

    public String getStartStream(Schema<IN, ?> var1);

    public String getEndStream();

    default public String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    default public String getElementSeparator() {
        return "";
    }

    default public Stream<OUT> generateStream(Schema<IN, ?> schema, long limit) {
        Item item = new Item(0L);
        return Stream.generate(() -> {
            StringBuilder res = new StringBuilder();
            if (item.current == 0L) {
                res.append(this.getStartStream(schema)).append(this.getLineSeparator());
            }
            res.append(this.apply(null, schema, item.current));
            if (item.current == limit - 1L) {
                res.append(this.getLineSeparator()).append(this.getEndStream());
            } else if (!this.getElementSeparator().isEmpty()) {
                res.append(this.getElementSeparator());
            }
            ++item.current;
            return res.toString();
        }).limit(limit);
    }

    public static class Item {
        private long current;

        public Item(long current) {
            this.current = current;
        }
    }
}

