/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.metastore.HiveType;
import io.trino.metastore.type.DecimalTypeInfo;
import io.trino.metastore.type.TypeInfo;
import io.trino.metastore.type.TypeInfoFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;

public class DeltaHiveTypeTranslator {
    private DeltaHiveTypeTranslator() {
    }

    public static HiveType toHiveType(Type type) {
        return HiveType.fromTypeInfo((TypeInfo)DeltaHiveTypeTranslator.translate(type));
    }

    public static TypeInfo translate(Type type) {
        Objects.requireNonNull(type, "type is null");
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HiveType.HIVE_BOOLEAN.getTypeInfo();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HiveType.HIVE_LONG.getTypeInfo();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return HiveType.HIVE_INT.getTypeInfo();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return HiveType.HIVE_SHORT.getTypeInfo();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return HiveType.HIVE_BYTE.getTypeInfo();
        }
        if (RealType.REAL.equals((Object)type)) {
            return HiveType.HIVE_FLOAT.getTypeInfo();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HiveType.HIVE_DOUBLE.getTypeInfo();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return HiveType.HIVE_STRING.getTypeInfo();
            }
            if (varcharType.getBoundedLength() <= 65535) {
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharType.getBoundedLength());
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported VARCHAR types: VARCHAR(<=%d), VARCHAR.", type, 65535));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            if (charLength <= 255) {
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported CHAR types: CHAR(<=%d).", type, 255));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HiveType.HIVE_BINARY.getTypeInfo();
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveType.HIVE_DATE.getTypeInfo();
        }
        if (type instanceof TimestampWithTimeZoneType) {
            Verify.verify((((TimestampWithTimeZoneType)type).getPrecision() == 3 ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            Verify.verify((timestampType.getPrecision() == 3 || timestampType.getPrecision() == 6 ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            TypeInfo elementType = DeltaHiveTypeTranslator.translate(arrayType.getElementType());
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            TypeInfo keyType = DeltaHiveTypeTranslator.translate(mapType.getKeyType());
            TypeInfo valueType = DeltaHiveTypeTranslator.translate(mapType.getValueType());
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (type instanceof RowType) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                fieldNames.add((Object)((String)parameter.getNamedTypeSignature().getName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Anonymous row type is not supported in Hive. Please give each field a name: %s", type)))));
            }
            return TypeInfoFactory.getStructTypeInfo((List)fieldNames.build(), (List)((List)type.getTypeParameters().stream().map(DeltaHiveTypeTranslator::translate).collect(ImmutableList.toImmutableList())));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Delta Lake type: %s", type));
    }
}

