/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.DeltaLakeColumnProjectionInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public record DeltaLakeColumnHandle(String baseColumnName, Type baseType, OptionalInt baseFieldId, String basePhysicalColumnName, Type basePhysicalType, DeltaLakeColumnType columnType, Optional<DeltaLakeColumnProjectionInfo> projectionInfo) implements ColumnHandle
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DeltaLakeColumnHandle.class);
    public static final String ROW_POSITION_COLUMN_NAME = "$row_position";
    public static final String ROW_ID_COLUMN_NAME = "$row_id";
    public static final Type MERGE_ROW_ID_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"path", (Type)VarcharType.VARCHAR), RowType.field((String)"position", (Type)BigintType.BIGINT), RowType.field((String)"partition", (Type)VarcharType.VARCHAR)});
    public static final String PATH_COLUMN_NAME = "$path";
    public static final Type PATH_TYPE = VarcharType.VARCHAR;
    public static final String FILE_SIZE_COLUMN_NAME = "$file_size";
    public static final Type FILE_SIZE_TYPE = BigintType.BIGINT;
    public static final String FILE_MODIFIED_TIME_COLUMN_NAME = "$file_modified_time";
    public static final Type FILE_MODIFIED_TIME_TYPE = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;

    public DeltaLakeColumnHandle {
        Objects.requireNonNull(baseColumnName, "baseColumnName is null");
        Objects.requireNonNull(baseType, "baseType is null");
        Objects.requireNonNull(baseFieldId, "baseFieldId is null");
        Objects.requireNonNull(basePhysicalColumnName, "basePhysicalColumnName is null");
        Objects.requireNonNull(basePhysicalType, "basePhysicalType is null");
        Objects.requireNonNull(columnType, "columnType is null");
        Preconditions.checkArgument((projectionInfo.isEmpty() || columnType == DeltaLakeColumnType.REGULAR ? 1 : 0) != 0, (String)"Projection info present for column type: %s", (Object)((Object)columnType));
    }

    @JsonIgnore
    public String columnName() {
        Preconditions.checkState((boolean)this.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)this);
        return this.baseColumnName;
    }

    @JsonIgnore
    public String qualifiedPhysicalName() {
        return this.projectionInfo.map(projectionInfo -> this.basePhysicalColumnName + "#" + projectionInfo.getPartialName()).orElse(this.basePhysicalColumnName);
    }

    public long retainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.baseColumnName) + SizeOf.sizeOf((OptionalInt)this.baseFieldId) + SizeOf.estimatedSizeOf((String)this.basePhysicalColumnName) + this.projectionInfo.map(DeltaLakeColumnProjectionInfo::getRetainedSizeInBytes).orElse(0L);
    }

    @JsonIgnore
    public boolean isBaseColumn() {
        return this.projectionInfo.isEmpty();
    }

    @JsonIgnore
    public Type type() {
        return this.projectionInfo.map(DeltaLakeColumnProjectionInfo::getType).orElse(this.baseType);
    }

    @Override
    public String toString() {
        return this.qualifiedPhysicalName() + ":" + this.projectionInfo.map(DeltaLakeColumnProjectionInfo::getType).orElse(this.baseType).getDisplayName() + ":" + String.valueOf((Object)this.columnType);
    }

    public HiveColumnHandle toHiveColumnHandle() {
        return new HiveColumnHandle(this.basePhysicalColumnName, 0, DeltaHiveTypeTranslator.toHiveType(this.basePhysicalType), this.basePhysicalType, this.projectionInfo.map(DeltaLakeColumnProjectionInfo::toHiveColumnProjectionInfo), this.columnType.toHiveColumnType(), Optional.empty());
    }

    public static DeltaLakeColumnHandle rowPositionColumnHandle() {
        return new DeltaLakeColumnHandle(ROW_POSITION_COLUMN_NAME, (Type)BigintType.BIGINT, OptionalInt.empty(), ROW_POSITION_COLUMN_NAME, (Type)BigintType.BIGINT, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle pathColumnHandle() {
        return new DeltaLakeColumnHandle(PATH_COLUMN_NAME, PATH_TYPE, OptionalInt.empty(), PATH_COLUMN_NAME, PATH_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle fileSizeColumnHandle() {
        return new DeltaLakeColumnHandle(FILE_SIZE_COLUMN_NAME, FILE_SIZE_TYPE, OptionalInt.empty(), FILE_SIZE_COLUMN_NAME, FILE_SIZE_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle fileModifiedTimeColumnHandle() {
        return new DeltaLakeColumnHandle(FILE_MODIFIED_TIME_COLUMN_NAME, FILE_MODIFIED_TIME_TYPE, OptionalInt.empty(), FILE_MODIFIED_TIME_COLUMN_NAME, FILE_MODIFIED_TIME_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle mergeRowIdColumnHandle() {
        return new DeltaLakeColumnHandle(ROW_ID_COLUMN_NAME, MERGE_ROW_ID_TYPE, OptionalInt.empty(), ROW_ID_COLUMN_NAME, MERGE_ROW_ID_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }
}

