/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogEntries;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class DeltaLakeCommitSummary {
    private final long version;
    private final List<MetadataEntry> metadataUpdates;
    private final Optional<ProtocolEntry> protocol;
    private final boolean containsRemoveFileWithoutPartitionValues;
    private final Set<Map<String, Optional<String>>> removedFilesCanonicalPartitionValues;
    private final Set<Map<String, Optional<String>>> addedFilesCanonicalPartitionValues;
    private final Optional<Boolean> isBlindAppend;

    public DeltaLakeCommitSummary(long version, TransactionLogEntries transactionLogEntries, TrinoFileSystem fileSystem) {
        Objects.requireNonNull(transactionLogEntries, "transactionLogEntries is null");
        ImmutableList.Builder metadataUpdatesBuilder = ImmutableList.builder();
        Optional<Object> optionalProtocol = Optional.empty();
        Optional<Object> optionalCommitInfo = Optional.empty();
        ImmutableSet.Builder addedFilesCanonicalPartitionValuesBuilder = ImmutableSet.builder();
        ImmutableSet.Builder removedFilesCanonicalPartitionValuesBuilder = ImmutableSet.builder();
        boolean containsRemoveFileWithoutPartitionValues = false;
        try (Stream<DeltaLakeTransactionLogEntry> logEntryStream = transactionLogEntries.getEntries(fileSystem);){
            Iterator it = logEntryStream.iterator();
            while (it.hasNext()) {
                DeltaLakeTransactionLogEntry transactionLogEntry = (DeltaLakeTransactionLogEntry)it.next();
                if (transactionLogEntry.getMetaData() != null) {
                    metadataUpdatesBuilder.add((Object)transactionLogEntry.getMetaData());
                    continue;
                }
                if (transactionLogEntry.getProtocol() != null) {
                    optionalProtocol = Optional.of(transactionLogEntry.getProtocol());
                    continue;
                }
                if (transactionLogEntry.getCommitInfo() != null) {
                    optionalCommitInfo = Optional.of(transactionLogEntry.getCommitInfo());
                    continue;
                }
                if (transactionLogEntry.getAdd() != null) {
                    addedFilesCanonicalPartitionValuesBuilder.add(transactionLogEntry.getAdd().getCanonicalPartitionValues());
                    continue;
                }
                if (transactionLogEntry.getRemove() == null) continue;
                Map<String, String> partitionValues = transactionLogEntry.getRemove().partitionValues();
                if (partitionValues == null) {
                    containsRemoveFileWithoutPartitionValues = true;
                    continue;
                }
                removedFilesCanonicalPartitionValuesBuilder.add(TransactionLogUtil.canonicalizePartitionValues(partitionValues));
            }
        }
        this.version = version;
        this.metadataUpdates = metadataUpdatesBuilder.build();
        this.protocol = optionalProtocol;
        this.addedFilesCanonicalPartitionValues = addedFilesCanonicalPartitionValuesBuilder.build();
        this.removedFilesCanonicalPartitionValues = removedFilesCanonicalPartitionValuesBuilder.build();
        this.containsRemoveFileWithoutPartitionValues = containsRemoveFileWithoutPartitionValues;
        this.isBlindAppend = optionalCommitInfo.flatMap(CommitInfoEntry::isBlindAppend);
    }

    public long getVersion() {
        return this.version;
    }

    public List<MetadataEntry> getMetadataUpdates() {
        return this.metadataUpdates;
    }

    public Optional<ProtocolEntry> getProtocol() {
        return this.protocol;
    }

    public boolean isContainsRemoveFileWithoutPartitionValues() {
        return this.containsRemoveFileWithoutPartitionValues;
    }

    public Set<Map<String, Optional<String>>> getRemovedFilesCanonicalPartitionValues() {
        return this.removedFilesCanonicalPartitionValues;
    }

    public Set<Map<String, Optional<String>>> getAddedFilesCanonicalPartitionValues() {
        return this.addedFilesCanonicalPartitionValues;
    }

    public Optional<Boolean> getIsBlindAppend() {
        return this.isBlindAppend;
    }
}

