/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.BaseTransactionsTable;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class DeltaLakeHistoryTable
extends BaseTransactionsTable {
    public DeltaLakeHistoryTable(SchemaTableName tableName, String tableLocation, TrinoFileSystemFactory fileSystemFactory, TransactionLogAccess transactionLogAccess, TypeManager typeManager) {
        super(tableName, tableLocation, fileSystemFactory, transactionLogAccess, typeManager, new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).add((Object)new ColumnMetadata("user_id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("user_name", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("operation", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("operation_parameters", typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("cluster_id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("read_version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("isolation_level", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("is_blind_append", (Type)BooleanType.BOOLEAN)).add((Object)new ColumnMetadata("operation_metrics", typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).build()));
    }

    @Override
    protected List<Page> buildPages(ConnectorSession session, PageListBuilder pagesBuilder, List<Transaction> transactions, TrinoFileSystem fileSystem) {
        List commitInfoEntries;
        try (Stream<CommitInfoEntry> commitStream = transactions.stream().flatMap(transaction -> transaction.transactionEntries().getEntries(fileSystem)).map(DeltaLakeTransactionLogEntry::getCommitInfo).filter(Objects::nonNull);){
            commitInfoEntries = (List)commitStream.collect(ImmutableList.toImmutableList());
        }
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        commitInfoEntries.forEach(commitInfoEntry -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendBigint(commitInfoEntry.version());
            pagesBuilder.appendTimestampTzMillis(commitInfoEntry.timestamp(), timeZoneKey);
            DeltaLakeHistoryTable.write(commitInfoEntry.userId(), pagesBuilder);
            DeltaLakeHistoryTable.write(commitInfoEntry.userName(), pagesBuilder);
            DeltaLakeHistoryTable.write(commitInfoEntry.operation(), pagesBuilder);
            if (commitInfoEntry.operationParameters() == null) {
                pagesBuilder.appendNull();
            } else {
                pagesBuilder.appendVarcharVarcharMap(commitInfoEntry.operationParameters());
            }
            DeltaLakeHistoryTable.write(commitInfoEntry.clusterId(), pagesBuilder);
            pagesBuilder.appendBigint(commitInfoEntry.readVersion());
            DeltaLakeHistoryTable.write(commitInfoEntry.isolationLevel(), pagesBuilder);
            commitInfoEntry.isBlindAppend().ifPresentOrElse(pagesBuilder::appendBoolean, pagesBuilder::appendNull);
            if (commitInfoEntry.operationMetrics() == null) {
                pagesBuilder.appendNull();
            } else {
                pagesBuilder.appendVarcharVarcharMap(commitInfoEntry.operationMetrics());
            }
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static void write(String value, PageListBuilder pagesBuilder) {
        if (value == null) {
            pagesBuilder.appendNull();
        } else {
            pagesBuilder.appendVarchar(value);
        }
    }
}

