/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeCdfPageSink;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemaMapping;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTypes;
import io.trino.plugin.deltalake.DeltaLakeWriter;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.delete.DeletionVectors;
import io.trino.plugin.deltalake.delete.RoaringBitmapArray;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.parquet.format.CompressionCodec;
import org.joda.time.DateTimeZone;

public class DeltaLakeMergeSink
implements ConnectorMergeSink {
    private static final JsonCodec<List<String>> PARTITIONS_CODEC = JsonCodec.listJsonCodec(String.class);
    public static final String INSERT_CDF_LABEL = "insert";
    public static final String DELETE_CDF_LABEL = "delete";
    public static final String UPDATE_PREIMAGE_CDF_LABEL = "update_preimage";
    public static final String UPDATE_POSTIMAGE_CDF_LABEL = "update_postimage";
    private final TypeOperators typeOperators;
    private final TrinoFileSystem fileSystem;
    private final ConnectorSession session;
    private final DateTimeZone parquetDateTimeZone;
    private final String trinoVersion;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final DeltaLakeWriterStats writerStats;
    private final Location rootTableLocation;
    private final ConnectorPageSink insertPageSink;
    private final List<DeltaLakeColumnHandle> dataColumns;
    private final List<DeltaLakeColumnHandle> nonSynthesizedColumns;
    private final int tableColumnCount;
    private final int domainCompactionThreshold;
    private final Supplier<DeltaLakeCdfPageSink> cdfPageSinkSupplier;
    private final boolean cdfEnabled;
    private final Map<Slice, FileDeletion> fileDeletions = new HashMap<Slice, FileDeletion>();
    private final int[] dataColumnsIndices;
    private final int[] dataAndRowIdColumnsIndices;
    private final DeltaLakeParquetSchemaMapping parquetSchemaMapping;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final ParquetReaderOptions parquetReaderOptions;
    private final boolean deletionVectorEnabled;
    private final Map<String, DeletionVectorEntry> deletionVectors;
    private final int randomPrefixLength;
    @Nullable
    private DeltaLakeCdfPageSink cdfPageSink;

    public DeltaLakeMergeSink(TypeOperators typeOperators, TrinoFileSystemFactory fileSystemFactory, ConnectorSession session, DateTimeZone parquetDateTimeZone, String trinoVersion, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, DeltaLakeWriterStats writerStats, Location rootTableLocation, ConnectorPageSink insertPageSink, List<DeltaLakeColumnHandle> tableColumns, int domainCompactionThreshold, Supplier<DeltaLakeCdfPageSink> cdfPageSinkSupplier, boolean cdfEnabled, DeltaLakeParquetSchemaMapping parquetSchemaMapping, ParquetReaderOptions parquetReaderOptions, FileFormatDataSourceStats fileFormatDataSourceStats, boolean deletionVectorEnabled, Map<String, DeletionVectorEntry> deletionVectors, int randomPrefixLength) {
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.fileSystem = fileSystemFactory.create(session);
        this.parquetDateTimeZone = Objects.requireNonNull(parquetDateTimeZone, "parquetDateTimeZone is null");
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.writerStats = Objects.requireNonNull(writerStats, "writerStats is null");
        this.rootTableLocation = Objects.requireNonNull(rootTableLocation, "rootTableLocation is null");
        this.insertPageSink = Objects.requireNonNull(insertPageSink, "insertPageSink is null");
        Objects.requireNonNull(tableColumns, "tableColumns is null");
        this.tableColumnCount = tableColumns.size();
        this.dataColumns = (List)tableColumns.stream().filter(column -> column.columnType() == DeltaLakeColumnType.REGULAR).collect(ImmutableList.toImmutableList());
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.nonSynthesizedColumns = (List)tableColumns.stream().filter(column -> column.columnType() != DeltaLakeColumnType.SYNTHESIZED).collect(ImmutableList.toImmutableList());
        this.cdfPageSinkSupplier = Objects.requireNonNull(cdfPageSinkSupplier);
        this.cdfEnabled = cdfEnabled;
        this.parquetSchemaMapping = Objects.requireNonNull(parquetSchemaMapping, "parquetSchemaMapping is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        this.deletionVectorEnabled = deletionVectorEnabled;
        this.deletionVectors = ImmutableMap.copyOf(Objects.requireNonNull(deletionVectors, "deletionVectors is null"));
        this.randomPrefixLength = randomPrefixLength;
        this.dataColumnsIndices = new int[this.tableColumnCount];
        this.dataAndRowIdColumnsIndices = new int[this.tableColumnCount + 1];
        for (int i = 0; i < this.tableColumnCount; ++i) {
            this.dataColumnsIndices[i] = i;
            this.dataAndRowIdColumnsIndices[i] = i;
        }
        this.dataAndRowIdColumnsIndices[this.tableColumnCount] = this.tableColumnCount + 2;
    }

    public void storeMergedRows(Page page) {
        DeltaLakeMergePage mergePage = this.createPages(page, this.tableColumnCount);
        mergePage.insertionsPage().ifPresent(arg_0 -> ((ConnectorPageSink)this.insertPageSink).appendPage(arg_0));
        mergePage.updateInsertionsPage().ifPresent(arg_0 -> ((ConnectorPageSink)this.insertPageSink).appendPage(arg_0));
        this.processInsertions(mergePage.insertionsPage(), INSERT_CDF_LABEL);
        this.processInsertions(mergePage.updateInsertionsPage(), UPDATE_POSTIMAGE_CDF_LABEL);
        mergePage.deletionsPage().ifPresent(deletions -> this.processDeletion((Page)deletions, DELETE_CDF_LABEL));
        mergePage.updateDeletionsPage().ifPresent(deletions -> this.processDeletion((Page)deletions, UPDATE_PREIMAGE_CDF_LABEL));
    }

    private void processInsertions(Optional<Page> optionalInsertionPage, String cdfOperation) {
        if (this.cdfEnabled && optionalInsertionPage.isPresent()) {
            if (this.cdfPageSink == null) {
                this.cdfPageSink = this.cdfPageSinkSupplier.get();
            }
            Page updateInsertionsPage = optionalInsertionPage.get();
            Block[] cdfPostUpdateBlocks = new Block[this.nonSynthesizedColumns.size() + 1];
            for (int i = 0; i < this.nonSynthesizedColumns.size(); ++i) {
                cdfPostUpdateBlocks[i] = updateInsertionsPage.getBlock(i);
            }
            cdfPostUpdateBlocks[this.nonSynthesizedColumns.size()] = RunLengthEncodedBlock.create((Block)Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)cdfOperation)), (int)updateInsertionsPage.getPositionCount());
            this.cdfPageSink.appendPage(new Page(updateInsertionsPage.getPositionCount(), cdfPostUpdateBlocks));
        }
    }

    private void processDeletion(Page deletions, String cdfOperation) {
        List fields = RowBlock.getRowFieldsFromBlock((Block)deletions.getBlock(deletions.getChannelCount() - 1));
        Block filePathBlock = (Block)fields.get(0);
        Block rowPositionBlock = (Block)fields.get(1);
        Block partitionsBlock = (Block)fields.get(2);
        for (int position = 0; position < filePathBlock.getPositionCount(); ++position) {
            Slice filePath = VarcharType.VARCHAR.getSlice(filePathBlock, position);
            long rowPosition = BigintType.BIGINT.getLong(rowPositionBlock, position);
            Slice partitions = VarcharType.VARCHAR.getSlice(partitionsBlock, position);
            List partitionValues = (List)PARTITIONS_CODEC.fromJson((InputStream)partitions.getInput());
            FileDeletion deletion = this.fileDeletions.computeIfAbsent(filePath, slice -> new FileDeletion(partitionValues));
            if (cdfOperation.equals(UPDATE_PREIMAGE_CDF_LABEL)) {
                deletion.rowsDeletedByUpdate().add(rowPosition);
                continue;
            }
            deletion.rowsDeletedByDelete().add(rowPosition);
        }
    }

    private DeltaLakeMergePage createPages(Page inputPage, int dataColumnCount) {
        int inputChannelCount = inputPage.getChannelCount();
        if (inputChannelCount != dataColumnCount + 3) {
            throw new IllegalArgumentException(String.format("inputPage channelCount (%s) == dataColumns size (%s) + 3", inputChannelCount, dataColumnCount));
        }
        int positionCount = inputPage.getPositionCount();
        if (positionCount <= 0) {
            throw new IllegalArgumentException("positionCount should be > 0, but is " + positionCount);
        }
        Block operationBlock = inputPage.getBlock(inputChannelCount - 3);
        int[] deletePositions = new int[positionCount];
        int[] insertPositions = new int[positionCount];
        int[] updateInsertPositions = new int[positionCount];
        int[] updateDeletePositions = new int[positionCount];
        int deletePositionCount = 0;
        int insertPositionCount = 0;
        int updateInsertPositionCount = 0;
        int updateDeletePositionCount = 0;
        block6: for (int position = 0; position < positionCount; ++position) {
            byte operation = TinyintType.TINYINT.getByte(operationBlock, position);
            switch (operation) {
                case 2: {
                    deletePositions[deletePositionCount] = position;
                    ++deletePositionCount;
                    continue block6;
                }
                case 1: {
                    insertPositions[insertPositionCount] = position;
                    ++insertPositionCount;
                    continue block6;
                }
                case 4: {
                    updateInsertPositions[updateInsertPositionCount] = position;
                    ++updateInsertPositionCount;
                    continue block6;
                }
                case 5: {
                    updateDeletePositions[updateDeletePositionCount] = position;
                    ++updateDeletePositionCount;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Invalid merge operation: " + operation);
                }
            }
        }
        Optional<Page> deletePage = Optional.empty();
        if (deletePositionCount > 0) {
            deletePage = Optional.of(inputPage.getColumns(this.dataAndRowIdColumnsIndices).getPositions(deletePositions, 0, deletePositionCount));
        }
        Optional<Page> insertPage = Optional.empty();
        if (insertPositionCount > 0) {
            insertPage = Optional.of(inputPage.getColumns(this.dataColumnsIndices).getPositions(insertPositions, 0, insertPositionCount));
        }
        Optional<Page> updateInsertPage = Optional.empty();
        if (updateInsertPositionCount > 0) {
            updateInsertPage = Optional.of(inputPage.getColumns(this.dataColumnsIndices).getPositions(updateInsertPositions, 0, updateInsertPositionCount));
        }
        Optional<Page> updateDeletePage = Optional.empty();
        if (updateDeletePositionCount > 0) {
            updateDeletePage = Optional.of(inputPage.getColumns(this.dataAndRowIdColumnsIndices).getPositions(updateDeletePositions, 0, updateDeletePositionCount));
        }
        return new DeltaLakeMergePage(deletePage, insertPage, updateInsertPage, updateDeletePage);
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ArrayList fragments = new ArrayList();
        ((Collection)this.insertPageSink.finish().join()).stream().map(Slice::getInput).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).map(info -> new DeltaLakeMergeResult(info.partitionValues(), Optional.empty(), Optional.empty(), Optional.of(info))).map(arg_0 -> this.mergeResultJsonCodec.toJsonBytes(arg_0)).map(Slices::wrappedBuffer).forEach(fragments::add);
        this.fileDeletions.forEach((path, deletion) -> {
            if (this.deletionVectorEnabled) {
                fragments.add(this.writeMergeResult((Slice)path, (FileDeletion)deletion));
            } else {
                fragments.addAll(this.rewriteFile(path.toStringUtf8(), (FileDeletion)deletion));
            }
        });
        if (this.cdfEnabled && this.cdfPageSink != null) {
            ((Collection)MoreFutures.getDone(this.cdfPageSink.finish())).stream().map(Slice::getInput).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).map(info -> new DeltaLakeMergeResult(info.partitionValues(), Optional.empty(), Optional.empty(), Optional.of(info))).map(arg_0 -> this.mergeResultJsonCodec.toJsonBytes(arg_0)).map(Slices::wrappedBuffer).forEach(fragments::add);
        }
        return CompletableFuture.completedFuture(fragments);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Slice writeMergeResult(Slice path, FileDeletion deletion) {
        RoaringBitmapArray rowsDeletedByDelete = deletion.rowsDeletedByDelete();
        RoaringBitmapArray rowsDeletedByUpdate = deletion.rowsDeletedByUpdate();
        RoaringBitmapArray deletedRows = this.loadDeletionVector(Location.of((String)path.toStringUtf8()));
        deletedRows.or(rowsDeletedByDelete);
        deletedRows.or(rowsDeletedByUpdate);
        if (this.cdfEnabled) {
            try (ConnectorPageSource connectorPageSource = this.createParquetPageSource(Location.of((String)path.toStringUtf8())).get();){
                this.readConnectorPageSource(connectorPageSource, rowsDeletedByDelete, rowsDeletedByUpdate, deletion, page -> {});
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Error reading Parquet file: " + String.valueOf(path), (Throwable)e);
            }
        }
        TrinoInputFile inputFile = this.fileSystem.newInputFile(Location.of((String)path.toStringUtf8()));
        try (TrinoParquetDataSource dataSource = new TrinoParquetDataSource(inputFile, this.parquetReaderOptions, this.fileFormatDataSourceStats);){
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, Optional.empty());
            long rowCount = parquetMetadata.getBlocks().stream().map(BlockMetadata::rowCount).mapToLong(Long::longValue).sum();
            RoaringBitmapArray rowsRetained = new RoaringBitmapArray();
            rowsRetained.addRange(0L, rowCount - 1L);
            rowsRetained.andNot(deletedRows);
            if (rowsRetained.isEmpty()) {
                Slice slice = this.onlySourceFile(path.toStringUtf8(), deletion);
                return slice;
            }
            Slice slice = this.writeDeletionVector(path.toStringUtf8(), inputFile.length(), inputFile.lastModified(), deletedRows, deletion, parquetMetadata, rowCount);
            return slice;
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Error reading Parquet file: " + String.valueOf(path), (Throwable)e);
        }
    }

    private Slice writeDeletionVector(String sourcePath, long length, Instant lastModified, RoaringBitmapArray deletedRows, FileDeletion deletion, ParquetMetadata parquetMetadata, long rowCount) {
        DeletionVectorEntry deletionVectorEntry;
        String tablePath = this.rootTableLocation.toString();
        String sourceRelativePath = DeltaLakeMetadata.relativePath(tablePath, sourcePath);
        DeletionVectorEntry oldDeletionVector = this.deletionVectors.get(sourceRelativePath);
        try {
            deletionVectorEntry = DeletionVectors.writeDeletionVectors(this.fileSystem, this.rootTableLocation, deletedRows, this.randomPrefixLength);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to write deletion vector file", (Throwable)e);
        }
        try {
            DataFileInfo newFileInfo = new DataFileInfo(sourceRelativePath, length, lastModified.toEpochMilli(), DataFileInfo.DataFileType.DATA, deletion.partitionValues, DeltaLakeWriter.readStatistics(parquetMetadata, this.dataColumns, rowCount), Optional.of(deletionVectorEntry));
            DeltaLakeMergeResult result = new DeltaLakeMergeResult(deletion.partitionValues, Optional.of(sourceRelativePath), Optional.ofNullable(oldDeletionVector), Optional.of(newFileInfo));
            return Slices.utf8Slice((String)this.mergeResultJsonCodec.toJson((Object)result));
        }
        catch (Throwable e) {
            block6: {
                try {
                    this.fileSystem.deleteFile(this.rootTableLocation.appendPath(DeletionVectors.toFileName(deletionVectorEntry.pathOrInlineDv())));
                }
                catch (IOException ex) {
                    if (e.equals(ex)) break block6;
                    e.addSuppressed(ex);
                }
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to write deletion vector file", e);
        }
    }

    private Slice onlySourceFile(String sourcePath, FileDeletion deletion) {
        String sourceRelativePath = DeltaLakeMetadata.relativePath(this.rootTableLocation.toString(), sourcePath);
        DeletionVectorEntry deletionVector = this.deletionVectors.get(sourceRelativePath);
        DeltaLakeMergeResult result = new DeltaLakeMergeResult(deletion.partitionValues(), Optional.of(sourceRelativePath), Optional.ofNullable(deletionVector), Optional.empty());
        return Slices.utf8Slice((String)this.mergeResultJsonCodec.toJson((Object)result));
    }

    private List<Slice> rewriteFile(String sourcePath, FileDeletion deletion) {
        try {
            String tablePath = this.rootTableLocation.toString();
            Location sourceLocation = Location.of((String)sourcePath);
            String sourceRelativePath = DeltaLakeMetadata.relativePath(tablePath, sourcePath);
            Location targetLocation = sourceLocation.sibling(this.session.getQueryId() + "_" + String.valueOf(UUID.randomUUID()));
            String targetRelativePath = DeltaLakeMetadata.relativePath(tablePath, targetLocation.toString());
            ParquetFileWriter fileWriter = this.createParquetFileWriter(targetLocation, this.dataColumns);
            DeltaLakeWriter writer = new DeltaLakeWriter(fileWriter, this.rootTableLocation, targetRelativePath, deletion.partitionValues(), this.writerStats, this.dataColumns, DataFileInfo.DataFileType.DATA);
            Optional<DataFileInfo> newFileInfo = this.rewriteParquetFile(sourceLocation, deletion, writer);
            DeltaLakeMergeResult result = new DeltaLakeMergeResult(deletion.partitionValues(), Optional.of(sourceRelativePath), Optional.empty(), newFileInfo);
            return ImmutableList.of((Object)Slices.utf8Slice((String)this.mergeResultJsonCodec.toJson((Object)result)));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to rewrite Parquet file", (Throwable)e);
        }
    }

    private ParquetFileWriter createParquetFileWriter(Location path, List<DeltaLakeColumnHandle> dataColumns) {
        ParquetWriterOptions parquetWriterOptions = ParquetWriterOptions.builder().setMaxBlockSize(DeltaLakeSessionProperties.getParquetWriterBlockSize(this.session)).setMaxPageSize(DeltaLakeSessionProperties.getParquetWriterPageSize(this.session)).setMaxPageValueCount(DeltaLakeSessionProperties.getParquetWriterPageValueCount(this.session)).build();
        CompressionCodec compressionCodec = (CompressionCodec)DeltaLakeSessionProperties.getCompressionCodec(this.session).getParquetCompressionCodec().orElseThrow();
        try {
            Closeable rollbackAction = () -> this.fileSystem.deleteFile(path);
            dataColumns.forEach(column -> Verify.verify((boolean)column.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)column));
            List parquetTypes = (List)dataColumns.stream().map(column -> DeltaLakeTypes.toParquetType(this.typeOperators, column.basePhysicalType())).collect(ImmutableList.toImmutableList());
            List dataColumnNames = (List)dataColumns.stream().map(DeltaLakeColumnHandle::basePhysicalColumnName).collect(ImmutableList.toImmutableList());
            return new ParquetFileWriter(this.fileSystem.newOutputFile(path), rollbackAction, parquetTypes, dataColumnNames, this.parquetSchemaMapping.messageType(), this.parquetSchemaMapping.primitiveTypes(), parquetWriterOptions, IntStream.range(0, dataColumns.size()).toArray(), compressionCodec, this.trinoVersion, Optional.empty(), Optional.empty());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error creating Parquet file", (Throwable)e);
        }
    }

    private RoaringBitmapArray loadDeletionVector(Location path) {
        String relativePath = DeltaLakeMetadata.relativePath(this.rootTableLocation.toString(), path.toString());
        DeletionVectorEntry deletionVector = this.deletionVectors.get(relativePath);
        if (deletionVector == null) {
            return new RoaringBitmapArray();
        }
        try {
            return DeletionVectors.readDeletionVectors(this.fileSystem, this.rootTableLocation, deletionVector);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Error reading deletion vector file: " + String.valueOf(path), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<DataFileInfo> rewriteParquetFile(Location path, FileDeletion deletion, DeltaLakeWriter fileWriter) throws IOException {
        RoaringBitmapArray rowsDeletedByDelete = deletion.rowsDeletedByDelete();
        RoaringBitmapArray rowsDeletedByUpdate = deletion.rowsDeletedByUpdate();
        try (ConnectorPageSource connectorPageSource = this.createParquetPageSource(path).get();){
            this.readConnectorPageSource(connectorPageSource, rowsDeletedByDelete, rowsDeletedByUpdate, deletion, page -> {
                if (page.getPositionCount() > 0) {
                    fileWriter.appendRows((Page)page);
                }
            });
            if (fileWriter.getRowCount() == 0L) {
                fileWriter.rollback();
                Optional<DataFileInfo> optional = Optional.empty();
                return optional;
            }
            fileWriter.commit();
            return Optional.of(fileWriter.getDataFileInfo());
        }
        catch (Throwable t) {
            try {
                fileWriter.rollback();
                throw t;
            }
            catch (RuntimeException e) {
                if (t.equals(e)) throw t;
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private void readConnectorPageSource(ConnectorPageSource connectorPageSource, RoaringBitmapArray rowsDeletedByDelete, RoaringBitmapArray rowsDeletedByUpdate, FileDeletion deletion, Consumer<Page> pageConsumer) {
        long filePosition = 0L;
        while (!connectorPageSource.isFinished()) {
            Page page = connectorPageSource.getNextPage();
            if (page == null) continue;
            int positionCount = page.getPositionCount();
            int[] retained = new int[positionCount];
            int[] deletedByDelete = new int[(int)rowsDeletedByDelete.cardinality()];
            int[] deletedByUpdate = new int[(int)rowsDeletedByUpdate.cardinality()];
            int retainedCount = 0;
            int deletedByUpdateCount = 0;
            int deletedByDeleteCount = 0;
            for (int position = 0; position < positionCount; ++position) {
                if (rowsDeletedByDelete.contains(filePosition)) {
                    deletedByDelete[deletedByDeleteCount] = position;
                    ++deletedByDeleteCount;
                } else if (rowsDeletedByUpdate.contains(filePosition)) {
                    deletedByUpdate[deletedByUpdateCount] = position;
                    ++deletedByUpdateCount;
                } else {
                    retained[retainedCount] = position;
                    ++retainedCount;
                }
                ++filePosition;
            }
            this.storeCdfEntries(page, deletedByDelete, deletedByDeleteCount, deletion, DELETE_CDF_LABEL);
            this.storeCdfEntries(page, deletedByUpdate, deletedByUpdateCount, deletion, UPDATE_PREIMAGE_CDF_LABEL);
            if (retainedCount != positionCount) {
                page = page.getPositions(retained, 0, retainedCount);
            }
            pageConsumer.accept(page);
        }
    }

    private void storeCdfEntries(Page page, int[] deleted, int deletedCount, FileDeletion deletion, String operation) {
        if (this.cdfEnabled && page.getPositionCount() > 0) {
            Block cdfOperationBlock;
            if (this.cdfPageSink == null) {
                this.cdfPageSink = this.cdfPageSinkSupplier.get();
            }
            Page cdfPage = page.getPositions(deleted, 0, deletedCount);
            Block[] outputBlocks = new Block[this.nonSynthesizedColumns.size() + 1];
            int cdfPageIndex = 0;
            int partitionIndex = 0;
            List<String> partitionValues = deletion.partitionValues;
            for (int i = 0; i < this.nonSynthesizedColumns.size(); ++i) {
                if (this.nonSynthesizedColumns.get(i).columnType() == DeltaLakeColumnType.REGULAR) {
                    outputBlocks[i] = cdfPage.getBlock(cdfPageIndex);
                    ++cdfPageIndex;
                    continue;
                }
                outputBlocks[i] = RunLengthEncodedBlock.create((Block)Utils.nativeValueToBlock((Type)this.nonSynthesizedColumns.get(i).baseType(), (Object)TransactionLogParser.deserializePartitionValue(this.nonSynthesizedColumns.get(i), Optional.ofNullable(partitionValues.get(partitionIndex)))), (int)cdfPage.getPositionCount());
                ++partitionIndex;
            }
            outputBlocks[this.nonSynthesizedColumns.size()] = cdfOperationBlock = RunLengthEncodedBlock.create((Block)Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)operation)), (int)cdfPage.getPositionCount());
            this.cdfPageSink.appendPage(new Page(cdfPage.getPositionCount(), outputBlocks));
        }
    }

    private ReaderPageSource createParquetPageSource(Location path) throws IOException {
        TrinoInputFile inputFile = this.fileSystem.newInputFile(path);
        long fileSize = inputFile.length();
        return ParquetPageSourceFactory.createPageSource((TrinoInputFile)inputFile, (long)0L, (long)fileSize, (List)((List)this.dataColumns.stream().map(DeltaLakeColumnHandle::toHiveColumnHandle).collect(ImmutableList.toImmutableList())), (List)ImmutableList.of((Object)TupleDomain.all()), (boolean)true, (DateTimeZone)this.parquetDateTimeZone, (FileFormatDataSourceStats)new FileFormatDataSourceStats(), (ParquetReaderOptions)new ParquetReaderOptions().withBloomFilter(false), Optional.empty(), (int)this.domainCompactionThreshold, (OptionalLong)OptionalLong.of(fileSize));
    }

    public void abort() {
        if (this.cdfPageSink != null) {
            this.cdfPageSink.abort();
        }
    }

    private record DeltaLakeMergePage(Optional<Page> deletionsPage, Optional<Page> insertionsPage, Optional<Page> updateInsertionsPage, Optional<Page> updateDeletionsPage) {
        public DeltaLakeMergePage {
            Objects.requireNonNull(deletionsPage, "deletionsPage is null");
            Objects.requireNonNull(insertionsPage, "insertionsPage is null");
            Objects.requireNonNull(updateInsertionsPage, "updateInsertionsPage is null");
            Objects.requireNonNull(updateDeletionsPage, "updateDeletionsPage is null");
        }
    }

    private static class FileDeletion {
        private final List<String> partitionValues;
        private final RoaringBitmapArray rowsDeletedByDelete = new RoaringBitmapArray();
        private final RoaringBitmapArray rowsDeletedByUpdate = new RoaringBitmapArray();

        private FileDeletion(List<String> partitionValues) {
            this.partitionValues = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(partitionValues, "partitionValues is null")));
        }

        public List<String> partitionValues() {
            return this.partitionValues;
        }

        public RoaringBitmapArray rowsDeletedByDelete() {
            return this.rowsDeletedByDelete;
        }

        public RoaringBitmapArray rowsDeletedByUpdate() {
            return this.rowsDeletedByUpdate;
        }
    }
}

