/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;
import io.airlift.units.DataSize;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.trino.plugin.base.filter.UtcConstraintExtractor;
import io.trino.plugin.base.projection.ApplyProjectionUtil;
import io.trino.plugin.base.util.ExecutorUtil;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.CorruptedDeltaLakeTableHandle;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeAnalyzeProperties;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnProjectionInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeCommitSummary;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeHistoryTable;
import io.trino.plugin.deltalake.DeltaLakeInputInfo;
import io.trino.plugin.deltalake.DeltaLakeInsertTableHandle;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeMergeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePartitioningHandle;
import io.trino.plugin.deltalake.DeltaLakePartitionsTable;
import io.trino.plugin.deltalake.DeltaLakePropertiesTable;
import io.trino.plugin.deltalake.DeltaLakeScannedDataFile;
import io.trino.plugin.deltalake.DeltaLakeSchemaProperties;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.deltalake.DeltaLakeTable;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeTableName;
import io.trino.plugin.deltalake.DeltaLakeTableProperties;
import io.trino.plugin.deltalake.DeltaLakeTableType;
import io.trino.plugin.deltalake.DeltaLakeTransactionsTable;
import io.trino.plugin.deltalake.DeltaLakeUpdateHandle;
import io.trino.plugin.deltalake.LocatedTableHandle;
import io.trino.plugin.deltalake.expression.ParsingException;
import io.trino.plugin.deltalake.expression.SparkExpressionParser;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableMetadataScheduler;
import io.trino.plugin.deltalake.metastore.DeltaMetastoreTable;
import io.trino.plugin.deltalake.metastore.HiveMetastoreBackedDeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.NotADeltaLakeTableException;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableExecuteHandle;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableProcedureId;
import io.trino.plugin.deltalake.procedure.DeltaTableOptimizeHandle;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeTableStatisticsProvider;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CdcEntry;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeComputedStatistics;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTableFeatures;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogEntries;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriterManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.MetadataAndProtocolEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionConflictException;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionFailedException;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriter;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriterFactory;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.TrinoViewHiveMetastore;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeltaLakeMetadata
implements ConnectorMetadata {
    public static final Logger LOG = Logger.get(DeltaLakeMetadata.class);
    public static final String PATH_PROPERTY = "path";
    public static final StorageFormat DELTA_STORAGE_FORMAT = StorageFormat.create((String)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (String)"org.apache.hadoop.mapred.SequenceFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat");
    public static final String CREATE_TABLE_AS_OPERATION = "CREATE TABLE AS SELECT";
    public static final String CREATE_OR_REPLACE_TABLE_AS_OPERATION = "CREATE OR REPLACE TABLE AS SELECT";
    public static final String CREATE_TABLE_OPERATION = "CREATE TABLE";
    public static final String CREATE_OR_REPLACE_TABLE_OPERATION = "CREATE OR REPLACE TABLE";
    public static final String ADD_COLUMN_OPERATION = "ADD COLUMNS";
    public static final String DROP_COLUMN_OPERATION = "DROP COLUMNS";
    public static final String RENAME_COLUMN_OPERATION = "RENAME COLUMN";
    public static final String INSERT_OPERATION = "WRITE";
    public static final String MERGE_OPERATION = "MERGE";
    public static final String UPDATE_OPERATION = "UPDATE";
    public static final String DELETE_OPERATION = "DELETE";
    public static final String TRUNCATE_OPERATION = "TRUNCATE";
    public static final String OPTIMIZE_OPERATION = "OPTIMIZE";
    public static final String SET_TBLPROPERTIES_OPERATION = "SET TBLPROPERTIES";
    public static final String CHANGE_COLUMN_OPERATION = "CHANGE COLUMN";
    public static final int DEFAULT_READER_VERSION = 1;
    public static final int DEFAULT_WRITER_VERSION = 2;
    private static final int MAX_READER_VERSION = 3;
    public static final int MAX_WRITER_VERSION = 7;
    public static final int CDF_SUPPORTED_WRITER_VERSION = 4;
    public static final int COLUMN_MAPPING_MODE_SUPPORTED_READER_VERSION = 2;
    public static final int COLUMN_MAPPING_MODE_SUPPORTED_WRITER_VERSION = 5;
    public static final int TIMESTAMP_NTZ_SUPPORTED_READER_VERSION = 3;
    public static final int TIMESTAMP_NTZ_SUPPORTED_WRITER_VERSION = 7;
    public static final int DELETION_VECTORS_SUPPORTED_READER_VERSION = 3;
    public static final int DELETION_VECTORS_SUPPORTED_WRITER_VERSION = 7;
    private static final RetryPolicy<Object> TRANSACTION_CONFLICT_RETRY_POLICY = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(throwable -> Throwables.getCausalChain((Throwable)throwable).stream().anyMatch(TransactionConflictException.class::isInstance))).withDelay(Duration.ofMillis(400L)).withJitter(Duration.ofMillis(200L)).withMaxRetries(5).onRetry(event -> LOG.debug(event.getLastException(), "Commit failed on attempt %d, will retry.", new Object[]{event.getAttemptCount()})).build();
    private static final List<Column> DUMMY_DATA_COLUMNS = ImmutableList.of((Object)new Column("col", HiveTypeTranslator.toHiveType((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())), Optional.empty(), Map.of()));
    private static final Set<ColumnStatisticType> SUPPORTED_STATISTICS_TYPE = ImmutableSet.builder().add((Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES).add((Object)ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY).add((Object)ColumnStatisticType.MAX_VALUE).add((Object)ColumnStatisticType.MIN_VALUE).add((Object)ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES).build();
    private static final String ENABLE_NON_CONCURRENT_WRITES_CONFIGURATION_KEY = "delta.enable-non-concurrent-writes";
    public static final Set<String> UPDATABLE_TABLE_PROPERTIES = ImmutableSet.of((Object)"change_data_feed_enabled");
    public static final Set<String> CHANGE_DATA_FEED_COLUMN_NAMES = ImmutableSet.builder().add((Object)"_change_type").add((Object)"_commit_version").add((Object)"_commit_timestamp").build();
    private static final String CHECK_CONSTRAINT_CONVERT_FAIL_EXPRESSION = "CAST(fail('Failed to convert Delta check constraints to Trino expression') AS boolean)";
    private final DeltaLakeMetastore metastore;
    private final TransactionLogAccess transactionLogAccess;
    private final DeltaLakeTableStatisticsProvider tableStatisticsProvider;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;
    private final AccessControlMetadata accessControlMetadata;
    private final TrinoViewHiveMetastore trinoViewHiveMetastore;
    private final CheckpointWriterManager checkpointWriterManager;
    private final long defaultCheckpointInterval;
    private final int domainCompactionThreshold;
    private final boolean unsafeWritesEnabled;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final TransactionLogWriterFactory transactionLogWriterFactory;
    private final String nodeVersion;
    private final String nodeId;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();
    private final CachingExtendedStatisticsAccess statisticsAccess;
    private final boolean deleteSchemaLocationsFallback;
    private final boolean useUniqueTableLocation;
    private final boolean allowManagedTableRename;
    private final DeltaLakeTableMetadataScheduler metadataScheduler;
    private final Map<SchemaTableName, DeltaLakeTableMetadataScheduler.TableUpdateInfo> tableUpdateInfos = new ConcurrentHashMap<SchemaTableName, DeltaLakeTableMetadataScheduler.TableUpdateInfo>();
    private final Map<SchemaTableName, Long> latestTableVersions = new ConcurrentHashMap<SchemaTableName, Long>();
    private final Map<QueriedTable, TableSnapshot> queriedSnapshots = new ConcurrentHashMap<QueriedTable, TableSnapshot>();
    private final Executor metadataFetchingExecutor;

    public DeltaLakeMetadata(DeltaLakeMetastore metastore, TransactionLogAccess transactionLogAccess, DeltaLakeTableStatisticsProvider tableStatisticsProvider, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager, AccessControlMetadata accessControlMetadata, TrinoViewHiveMetastore trinoViewHiveMetastore, int domainCompactionThreshold, boolean unsafeWritesEnabled, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, TransactionLogWriterFactory transactionLogWriterFactory, NodeManager nodeManager, CheckpointWriterManager checkpointWriterManager, long defaultCheckpointInterval, boolean deleteSchemaLocationsFallback, CachingExtendedStatisticsAccess statisticsAccess, DeltaLakeTableMetadataScheduler metadataScheduler, boolean useUniqueTableLocation, boolean allowManagedTableRename, Executor metadataFetchingExecutor) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.tableStatisticsProvider = Objects.requireNonNull(tableStatisticsProvider, "tableStatisticsProvider is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.accessControlMetadata = Objects.requireNonNull(accessControlMetadata, "accessControlMetadata is null");
        this.trinoViewHiveMetastore = Objects.requireNonNull(trinoViewHiveMetastore, "trinoViewHiveMetastore is null");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.unsafeWritesEnabled = unsafeWritesEnabled;
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.transactionLogWriterFactory = Objects.requireNonNull(transactionLogWriterFactory, "transactionLogWriterFactory is null");
        this.nodeVersion = nodeManager.getCurrentNode().getVersion();
        this.nodeId = nodeManager.getCurrentNode().getNodeIdentifier();
        this.checkpointWriterManager = Objects.requireNonNull(checkpointWriterManager, "checkpointWriterManager is null");
        this.defaultCheckpointInterval = defaultCheckpointInterval;
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        this.metadataScheduler = Objects.requireNonNull(metadataScheduler, "metadataScheduler is null");
        this.useUniqueTableLocation = useUniqueTableLocation;
        this.allowManagedTableRename = allowManagedTableRename;
        this.metadataFetchingExecutor = Objects.requireNonNull(metadataFetchingExecutor, "metadataFetchingExecutor is null");
    }

    public TableSnapshot getSnapshot(ConnectorSession session, SchemaTableName table, String tableLocation, Optional<Long> atVersion) {
        QueriedTable queriedTable;
        Optional<Long> version = atVersion.or(() -> Optional.ofNullable(this.latestTableVersions.get(table)));
        if (version.isPresent() && this.queriedSnapshots.containsKey(queriedTable = new QueriedTable(table, version.get()))) {
            return this.queriedSnapshots.get(queriedTable);
        }
        try {
            TableSnapshot snapshot = this.transactionLogAccess.loadSnapshot(session, table, tableLocation, version);
            Preconditions.checkState((this.latestTableVersions.put(table, snapshot.getVersion()) == null || atVersion.isPresent() ? 1 : 0) != 0, (String)"latestTableVersions changed concurrently for %s", (Object)table);
            this.queriedSnapshots.put(new QueriedTable(table, snapshot.getVersion()), snapshot);
            return snapshot;
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error getting snapshot for " + String.valueOf(table), (Throwable)e);
        }
    }

    private static long getVersion(TrinoFileSystem fileSystem, String tableLocation, ConnectorTableVersion version) {
        switch (version.getPointerType()) {
            default: {
                throw new MatchException(null, null);
            }
            case TEMPORAL: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support reading tables with TIMESTAMP AS OF");
            }
            case TARGET_ID: 
        }
        return DeltaLakeMetadata.getTargetVersion(fileSystem, tableLocation, version);
    }

    private static long getTargetVersion(TrinoFileSystem fileSystem, String tableLocation, ConnectorTableVersion version) {
        if (version.getVersionType() != SmallintType.SMALLINT && version.getVersionType() != TinyintType.TINYINT && version.getVersionType() != IntegerType.INTEGER && version.getVersionType() != BigintType.BIGINT) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type for table version: " + version.getVersionType().getDisplayName());
        }
        long snapshotId = (Long)version.getVersion();
        try {
            if (!fileSystem.newInputFile(TransactionLogUtil.getTransactionLogJsonEntryPath(TransactionLogUtil.getTransactionLogDir(tableLocation), snapshotId)).exists()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Delta Lake snapshot ID does not exists: " + snapshotId);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Delta Lake snapshot ID does not exists: " + snapshotId);
        }
        return snapshotId;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.metastore.getAllDatabases().stream().filter(schema -> !schema.equalsIgnoreCase("sys")).collect(ImmutableList.toImmutableList());
    }

    private static boolean isHiveTable(Table table) {
        return !HiveUtil.isDeltaLakeTable((Table)table);
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<String> targetCatalogName = DeltaLakeSessionProperties.getHiveCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional<Table> table = this.metastore.getRawMetastoreTable(tableNameBase.getSchemaName(), tableNameBase.getTableName());
        if (table.isEmpty() || TableType.VIRTUAL_VIEW.name().equals(table.get().getTableType())) {
            return Optional.empty();
        }
        if (DeltaLakeMetadata.isHiveTable(table.get())) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, tableName));
        }
        return Optional.empty();
    }

    public LocatedTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        MetadataAndProtocolEntries logEntries;
        if (startVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Read table with start version is not supported");
        }
        Objects.requireNonNull(tableName, "tableName is null");
        if (!DeltaLakeTableName.isDataTable(tableName.getTableName())) {
            return null;
        }
        Optional<Table> metastoreTable = this.metastore.getRawMetastoreTable(tableName.getSchemaName(), tableName.getTableName());
        if (metastoreTable.isEmpty()) {
            return null;
        }
        DeltaMetastoreTable table = HiveMetastoreBackedDeltaLakeMetastore.convertToDeltaMetastoreTable(metastoreTable.get());
        boolean managed = table.managed();
        String tableLocation = table.location();
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        TableSnapshot tableSnapshot = this.getSnapshot(session, tableName, tableLocation, endVersion.map(version -> DeltaLakeMetadata.getVersion(fileSystem, tableLocation, version)));
        try {
            logEntries = this.transactionLogAccess.getMetadataAndProtocolEntry(session, tableSnapshot);
        }
        catch (TrinoException e) {
            if (e.getErrorCode().equals((Object)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA.toErrorCode())) {
                return new CorruptedDeltaLakeTableHandle(tableName, managed, tableLocation, e);
            }
            throw e;
        }
        MetadataEntry metadataEntry = logEntries.metadata().orElse(null);
        if (metadataEntry == null) {
            return new CorruptedDeltaLakeTableHandle(tableName, managed, tableLocation, new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Metadata not found in transaction log for " + String.valueOf(tableSnapshot.getTable())));
        }
        ProtocolEntry protocolEntry = logEntries.protocol().orElse(null);
        if (protocolEntry == null) {
            return new CorruptedDeltaLakeTableHandle(tableName, managed, tableLocation, new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Protocol not found in transaction log for " + String.valueOf(tableSnapshot.getTable())));
        }
        if (protocolEntry.minReaderVersion() > 3) {
            LOG.debug("Skip %s because the reader version is unsupported: %d", new Object[]{tableName, protocolEntry.minReaderVersion()});
            return null;
        }
        Set<String> unsupportedReaderFeatures = DeltaLakeTableFeatures.unsupportedReaderFeatures(protocolEntry.readerFeatures().orElse((Set<String>)ImmutableSet.of()));
        if (!unsupportedReaderFeatures.isEmpty()) {
            LOG.debug("Skip %s because the table contains unsupported reader features: %s", new Object[]{tableName, unsupportedReaderFeatures});
            return null;
        }
        DeltaLakeSchemaSupport.verifySupportedColumnMapping(DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry, protocolEntry));
        if (this.metadataScheduler.canStoreTableMetadata(session, metadataEntry.getSchemaString(), Optional.ofNullable(metadataEntry.getDescription())) && endVersion.isEmpty() && !DeltaLakeTableMetadataScheduler.isSameTransactionVersion(metastoreTable.get(), tableSnapshot)) {
            this.tableUpdateInfos.put(tableName, new DeltaLakeTableMetadataScheduler.TableUpdateInfo(session, tableSnapshot.getVersion(), metadataEntry.getSchemaString(), Optional.ofNullable(metadataEntry.getDescription())));
        }
        return new DeltaLakeTableHandle(tableName.getSchemaName(), tableName.getTableName(), managed, tableLocation, metadataEntry, protocolEntry, (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), tableSnapshot.getVersion(), endVersion.isPresent());
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new ConnectorTableProperties(((DeltaLakeTableHandle)tableHandle).getEnforcedPartitionConstraint().transformKeys(ColumnHandle.class::cast), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }

    public Optional<Type> getSupportedType(ConnectorSession session, Map<String, Object> tableProperties, Type type) {
        Type newType = this.coerceType(type);
        if (type.getTypeSignature().equals((Object)newType.getTypeSignature())) {
            return Optional.empty();
        }
        return Optional.of(newType);
    }

    private Type coerceType(Type type) {
        if (type instanceof TimestampType) {
            return TimestampType.TIMESTAMP_MICROS;
        }
        if (type instanceof CharType) {
            return VarcharType.VARCHAR;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ArrayType(this.coerceType(arrayType.getElementType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapType(this.coerceType(mapType.getKeyType()), this.coerceType(mapType.getValueType()), this.typeManager.getTypeOperators());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return RowType.from((List)((List)rowType.getFields().stream().map(field -> new RowType.Field(field.getName(), this.coerceType(field.getType()))).collect(ImmutableList.toImmutableList())));
        }
        return type;
    }

    public SchemaTableName getTableName(ConnectorSession session, ConnectorTableHandle table) {
        if (table instanceof CorruptedDeltaLakeTableHandle) {
            CorruptedDeltaLakeTableHandle corruptedTableHandle = (CorruptedDeltaLakeTableHandle)table;
            return corruptedTableHandle.schemaTableName();
        }
        return ((DeltaLakeTableHandle)table).getSchemaTableName();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode;
        DeltaLakeTableHandle tableHandle = DeltaLakeMetadata.checkValidTableHandle(table);
        Preconditions.checkArgument((boolean)tableHandle.getProjectedColumns().isEmpty(), (Object)"Unexpected projected columns");
        MetadataEntry metadataEntry = tableHandle.getMetadataEntry();
        ProtocolEntry protocolEntry = tableHandle.getProtocolEntry();
        List<ColumnMetadata> columns = this.getTableColumnMetadata(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry());
        DeltaLakeTable deltaTable = DeltaLakeTable.builder(metadataEntry, protocolEntry).build();
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"location", (Object)tableHandle.getLocation());
        List<String> partitionColumnNames = metadataEntry.getLowercasePartitionColumns();
        if (!partitionColumnNames.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionColumnNames);
        }
        Optional<Long> checkpointInterval = metadataEntry.getCheckpointInterval();
        checkpointInterval.ifPresent(value -> properties.put((Object)"checkpoint_interval", value));
        DeltaLakeSchemaSupport.changeDataFeedEnabled(metadataEntry, protocolEntry).ifPresent(value -> properties.put((Object)"change_data_feed_enabled", value));
        if (DeltaLakeSchemaSupport.isDeletionVectorEnabled(metadataEntry, protocolEntry)) {
            properties.put((Object)"deletion_vectors_enabled", (Object)true);
        }
        if ((columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry, protocolEntry)) != DeltaLakeSchemaSupport.ColumnMappingMode.NONE) {
            properties.put((Object)"column_mapping_mode", (Object)columnMappingMode.name());
        }
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columns, (Map)properties.buildOrThrow(), Optional.ofNullable(metadataEntry.getDescription()), (List)deltaTable.constraints().stream().map(constraint -> {
            try {
                return SparkExpressionParser.toTrinoExpression(constraint);
            }
            catch (ParsingException e) {
                return CHECK_CONSTRAINT_CONVERT_FAIL_EXPRESSION;
            }
        }).collect(ImmutableList.toImmutableList()));
    }

    private List<ColumnMetadata> getTableColumnMetadata(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        DeltaLakeTable deltaTable = DeltaLakeTable.builder(metadataEntry, protocolEntry).build();
        return (List)this.getColumns(metadataEntry, protocolEntry).stream().map(column -> DeltaLakeMetadata.getColumnMetadata(deltaTable, column)).collect(ImmutableList.toImmutableList());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.streamTables(session, schemaName).map(TableInfo::tableName).collect(ImmutableList.toImmutableList());
    }

    public Map<SchemaTableName, RelationType> getRelationTypes(ConnectorSession session, Optional<String> schemaName) {
        return (Map)this.streamTables(session, schemaName).collect(ImmutableMap.toImmutableMap(TableInfo::tableName, this::resolveRelationType, (ignore, second) -> second));
    }

    private Stream<TableInfo> streamTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        List tasks = (List)optionalSchemaName.map(Collections::singletonList).orElseGet(() -> this.listSchemaNames(session)).stream().map(schemaName -> () -> this.metastore.getAllTables((String)schemaName)).collect(ImmutableList.toImmutableList());
        try {
            return ExecutorUtil.processWithAdditionalThreads((Collection)tasks, (Executor)this.metadataFetchingExecutor).stream().flatMap(Collection::stream);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private RelationType resolveRelationType(TableInfo tableInfo) {
        if (tableInfo.extendedRelationType() == TableInfo.ExtendedRelationType.TRINO_VIEW) {
            return RelationType.VIEW;
        }
        return RelationType.TABLE;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle table = DeltaLakeMetadata.checkValidTableHandle(tableHandle);
        return (Map)table.getProjectedColumns().map(projectColumns -> projectColumns).orElseGet(() -> this.getColumns(table.getMetadataEntry(), table.getProtocolEntry())).stream().peek(handle -> Preconditions.checkArgument((boolean)handle.isBaseColumn(), (String)"Unsupported projected column: %s", (Object)handle)).collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::baseColumnName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        DeltaLakeTable deltaTable = DeltaLakeTable.builder(table.getMetadataEntry(), table.getProtocolEntry()).build();
        return DeltaLakeMetadata.getColumnMetadata(deltaTable, (DeltaLakeColumnHandle)columnHandle);
    }

    private static ColumnMetadata getColumnMetadata(DeltaLakeTable deltaTable, DeltaLakeColumnHandle column) {
        if (column.projectionInfo().isPresent() || column.columnType() == DeltaLakeColumnType.SYNTHESIZED) {
            return DeltaLakeMetadata.getColumnMetadata(column, null, true, Optional.empty());
        }
        DeltaLakeTable.DeltaLakeColumn deltaColumn = deltaTable.findColumn(column.baseColumnName());
        return DeltaLakeMetadata.getColumnMetadata(column, deltaColumn.comment(), deltaColumn.nullable(), deltaColumn.generationExpression());
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.validateTableColumns(tableMetadata);
        List<String> partitionColumnNames = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableLayout(partitionColumnNames));
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
        List<String> partitionColumnNames = deltaLakeTableHandle.getMetadataEntry().getLowercasePartitionColumns();
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableLayout(partitionColumnNames));
    }

    public Iterator<RelationCommentMetadata> streamRelationComments(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Map<SchemaTableName, ConnectorViewDefinition> viewDefinitions = this.getViews(session, schemaName);
        ImmutableList.Builder commentMetadataBuilder = ImmutableList.builderWithExpectedSize((int)viewDefinitions.size());
        ImmutableSet.Builder viewNamesBuilder = ImmutableSet.builderWithExpectedSize((int)viewDefinitions.size());
        for (Map.Entry<SchemaTableName, ConnectorViewDefinition> viewDefinitionEntry : viewDefinitions.entrySet()) {
            RelationCommentMetadata relationCommentMetadata = RelationCommentMetadata.forRelation((SchemaTableName)viewDefinitionEntry.getKey(), (Optional)viewDefinitionEntry.getValue().getComment());
            commentMetadataBuilder.add((Object)relationCommentMetadata);
            viewNamesBuilder.add((Object)relationCommentMetadata.name());
        }
        ImmutableList views = commentMetadataBuilder.build();
        ImmutableSet viewNames = viewNamesBuilder.build();
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        Stream<RelationCommentMetadata> tables = ((Set)this.listTables(session, schemaName).stream().filter(arg_0 -> DeltaLakeMetadata.lambda$streamRelationComments$18((Set)viewNames, arg_0)).collect(Collectors.collectingAndThen(Collectors.toUnmodifiableSet(), relationFilter))).stream().map(tableName -> this.getRelationCommentMetadata(session, fileSystem, (SchemaTableName)tableName)).filter(Objects::nonNull);
        Set availableViews = (Set)relationFilter.apply((Set<SchemaTableName>)viewNames);
        return Streams.concat((Stream[])new Stream[]{views.stream().filter(commentMetadata -> availableViews.contains(commentMetadata.name())), tables}).iterator();
    }

    private RelationCommentMetadata getRelationCommentMetadata(ConnectorSession session, TrinoFileSystem fileSystem, SchemaTableName tableName) {
        if (this.redirectTable(session, tableName).isPresent()) {
            return RelationCommentMetadata.forRedirectedTable((SchemaTableName)tableName);
        }
        try {
            Optional<Table> metastoreTable = this.metastore.getRawMetastoreTable(tableName.getSchemaName(), tableName.getTableName());
            if (metastoreTable.isEmpty()) {
                return null;
            }
            Table table = metastoreTable.get();
            HiveMetastoreBackedDeltaLakeMetastore.verifyDeltaLakeTable(table);
            String tableLocation = HiveMetastoreBackedDeltaLakeMetastore.getTableLocation(table);
            if (DeltaLakeMetadata.canUseTableParametersFromMetastore(session, fileSystem, table, tableLocation)) {
                return RelationCommentMetadata.forRelation((SchemaTableName)tableName, Optional.ofNullable((String)table.getParameters().get("comment")));
            }
            TableSnapshot snapshot = this.getSnapshot(session, tableName, tableLocation, Optional.empty());
            MetadataEntry metadata = this.transactionLogAccess.getMetadataEntry(session, snapshot);
            this.enqueueUpdateInfo(session, table.getDatabaseName(), table.getTableName(), snapshot.getVersion(), metadata.getSchemaString(), Optional.ofNullable(metadata.getDescription()));
            return RelationCommentMetadata.forRelation((SchemaTableName)tableName, Optional.ofNullable(metadata.getDescription()));
        }
        catch (RuntimeException e) {
            boolean suppressed = false;
            if (e instanceof TrinoException) {
                TrinoException trinoException = (TrinoException)((Object)e);
                ErrorCode errorCode = trinoException.getErrorCode();
                boolean bl = suppressed = errorCode.equals((Object)StandardErrorCode.UNSUPPORTED_TABLE_TYPE.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.NOT_FOUND.toErrorCode()) || errorCode.getType() == ErrorType.EXTERNAL;
            }
            if (suppressed) {
                LOG.debug("Failed to get metadata for table: %s", new Object[]{tableName});
            } else {
                LOG.warn("Failed to get metadata for table: %s", new Object[]{tableName});
            }
            return RelationCommentMetadata.forRelation((SchemaTableName)tableName, Optional.empty());
        }
    }

    private static boolean canUseTableParametersFromMetastore(ConnectorSession session, TrinoFileSystem fileSystem, Table table, String tableLocation) {
        if (!DeltaLakeSessionProperties.isStoreTableMetadataInMetastoreEnabled(session)) {
            return false;
        }
        return DeltaLakeTableMetadataScheduler.getLastTransactionVersion(table).map(version -> DeltaLakeMetadata.isLatestVersion(fileSystem, tableLocation, version)).orElse(false);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List tables = prefix.getTable().map(string -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        return tables.stream().flatMap(tableName -> {
            try {
                if (this.redirectTable(session, (SchemaTableName)tableName).isPresent()) {
                    return Stream.of(TableColumnsMetadata.forRedirectedTable((SchemaTableName)tableName));
                }
                Optional<Table> metastoreTable = this.metastore.getRawMetastoreTable(tableName.getSchemaName(), tableName.getTableName());
                if (metastoreTable.isEmpty()) {
                    return Stream.of(new TableColumnsMetadata[0]);
                }
                Table table = metastoreTable.get();
                HiveMetastoreBackedDeltaLakeMetastore.verifyDeltaLakeTable(table);
                String tableLocation = HiveMetastoreBackedDeltaLakeMetastore.getTableLocation(table);
                if (DeltaLakeTableMetadataScheduler.containsSchemaString(table) && DeltaLakeMetadata.canUseTableParametersFromMetastore(session, fileSystem, table, tableLocation)) {
                    List<ColumnMetadata> columnsMetadata = this.metadataScheduler.getColumnsMetadata(table);
                    return Stream.of(TableColumnsMetadata.forTable((SchemaTableName)tableName, columnsMetadata));
                }
                TableSnapshot snapshot = this.transactionLogAccess.loadSnapshot(session, (SchemaTableName)tableName, tableLocation, Optional.empty());
                MetadataEntry metadata = this.transactionLogAccess.getMetadataEntry(session, snapshot);
                ProtocolEntry protocol = this.transactionLogAccess.getProtocolEntry(session, snapshot);
                List<ColumnMetadata> columnMetadata = this.getTableColumnMetadata(metadata, protocol);
                this.enqueueUpdateInfo(session, table.getDatabaseName(), table.getTableName(), snapshot.getVersion(), metadata.getSchemaString(), Optional.ofNullable(metadata.getDescription()));
                return Stream.of(TableColumnsMetadata.forTable((SchemaTableName)tableName, columnMetadata));
            }
            catch (NotADeltaLakeTableException | IOException e) {
                return Stream.empty();
            }
            catch (RuntimeException e) {
                LOG.debug((Throwable)e, "Ignored exception when trying to list columns from %s", new Object[]{tableName});
                return Stream.empty();
            }
        }).iterator();
    }

    private static boolean isLatestVersion(TrinoFileSystem fileSystem, String tableLocation, long version) {
        String transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        Location transactionLogJsonEntryPath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, version);
        Location nextTransactionLogJsonEntryPath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, version + 1L);
        try {
            return !fileSystem.newInputFile(nextTransactionLogJsonEntryPath).exists() && fileSystem.newInputFile(transactionLogJsonEntryPath).exists();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e, "Failed to check table location: %s", new Object[]{tableLocation});
            return false;
        }
    }

    private List<DeltaLakeColumnHandle> getColumns(MetadataEntry deltaMetadata, ProtocolEntry protocolEntry) {
        ImmutableList.Builder columns = ImmutableList.builder();
        DeltaLakeSchemaSupport.extractSchema(deltaMetadata, protocolEntry, this.typeManager).stream().map(column -> DeltaLakeMetadata.toColumnHandle(column.name(), column.type(), column.fieldId(), column.physicalName(), column.physicalColumnType(), deltaMetadata.getLowercasePartitionColumns())).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
        columns.add((Object)DeltaLakeColumnHandle.pathColumnHandle());
        columns.add((Object)DeltaLakeColumnHandle.fileSizeColumnHandle());
        columns.add((Object)DeltaLakeColumnHandle.fileModifiedTimeColumnHandle());
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle handle = DeltaLakeMetadata.checkValidTableHandle(tableHandle);
        if (!DeltaLakeSessionProperties.isTableStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        return this.tableStatisticsProvider.getTableStatistics(session, handle, this.getSnapshot(session, handle));
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Optional<String> location = DeltaLakeSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.fileSystemFactory.create(session).directoryExists(Location.of((String)locationUri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        String queryId = session.getQueryId();
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(Optional.of(owner.getType())).setOwnerName(Optional.of(owner.getName())).setParameters((Map)ImmutableMap.of((Object)"trino_query_id", (Object)queryId)).build();
        Verify.verify((boolean)DeltaLakeMetadata.getQueryId(database).orElseThrow(() -> new IllegalArgumentException("Query id is not present")).equals(queryId), (String)"Database '%s' does not have correct query id set", (Object)database.getDatabaseName());
        this.metastore.createDatabase(database);
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        if (cascade) {
            for (SchemaTableName viewName : this.listViews(session, Optional.of(schemaName))) {
                try {
                    this.dropView(session, viewName);
                }
                catch (ViewNotFoundException e) {
                    LOG.debug("View disappeared during DROP SCHEMA CASCADE: %s", new Object[]{viewName});
                }
            }
            for (SchemaTableName tableName : this.listTables(session, Optional.of(schemaName))) {
                ConnectorTableHandle table = this.getTableHandle(session, tableName, Optional.empty(), Optional.empty());
                if (table == null) {
                    LOG.debug("Table disappeared during DROP SCHEMA CASCADE: %s", new Object[]{tableName});
                    continue;
                }
                try {
                    this.dropTable(session, table);
                }
                catch (TableNotFoundException e) {
                    LOG.debug("Table disappeared during DROP SCHEMA CASCADE: %s", new Object[]{tableName});
                }
            }
        }
        Optional location = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName)).getLocation();
        boolean deleteData = location.map(path -> {
            try {
                return !this.fileSystemFactory.create(session).listFiles(Location.of((String)path)).hasNext();
            }
            catch (IOException | RuntimeException e) {
                LOG.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                return this.deleteSchemaLocationsFallback;
            }
        }).orElse(this.deleteSchemaLocationsFallback);
        this.metastore.dropDatabase(schemaName, deleteData);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        boolean replaceExistingTable;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Database schema = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        boolean external = true;
        String location = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        ConnectorTableHandle connectorTableHandle = this.getTableHandle(session, tableMetadata.getTable(), Optional.empty(), Optional.empty());
        DeltaLakeTableHandle tableHandle = null;
        if (connectorTableHandle != null) {
            tableHandle = DeltaLakeMetadata.checkValidTableHandle(connectorTableHandle);
        }
        boolean bl = replaceExistingTable = tableHandle != null && saveMode == SaveMode.REPLACE;
        if (replaceExistingTable) {
            ConnectorTableMetadata existingTableMetadata = this.getTableMetadata(session, tableHandle);
            this.validateTableForReplaceOperation(tableHandle, existingTableMetadata, tableMetadata);
            String currentLocation = DeltaLakeTableProperties.getLocation(existingTableMetadata.getProperties());
            if (location != null && !Locations.areDirectoryLocationsEquivalent((Location)Location.of((String)location), (Location)Location.of((String)currentLocation))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("The provided location '%s' does not match the existing table location '%s'", location, currentLocation));
            }
            location = currentLocation;
            boolean bl2 = external = !tableHandle.isManaged();
        }
        if (location == null) {
            location = this.getTableLocation(schema, tableName);
            this.checkPathContainsNoFiles(session, Location.of((String)location));
            external = false;
        }
        long commitVersion = 0L;
        Location deltaLogDirectory = Location.of((String)TransactionLogUtil.getTransactionLogDir(location));
        Optional<Long> checkpointInterval = DeltaLakeTableProperties.getCheckpointInterval(tableMetadata.getProperties());
        Optional<Boolean> changeDataFeedEnabled = DeltaLakeTableProperties.getChangeDataFeedEnabled(tableMetadata.getProperties());
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeTableProperties.getColumnMappingMode(tableMetadata.getProperties());
        boolean deletionVectorsEnabled = DeltaLakeTableProperties.getDeletionVectorsEnabled(tableMetadata.getProperties());
        AtomicInteger fieldId = new AtomicInteger();
        this.validateTableColumns(tableMetadata);
        boolean containsTimestampType = false;
        DeltaLakeTable.Builder deltaTable = DeltaLakeTable.builder();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            deltaTable.addColumn(column.getName(), DeltaLakeSchemaSupport.serializeColumnType(columnMappingMode, fieldId, column.getType()), column.isNullable(), column.getComment(), DeltaLakeSchemaSupport.generateColumnMetadata(columnMappingMode, fieldId));
            if (containsTimestampType) continue;
            containsTimestampType = DeltaLakeMetadata.containsTimestampType(column.getType());
        }
        OptionalInt maxFieldId = OptionalInt.empty();
        if (columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.ID || columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.NAME) {
            maxFieldId = OptionalInt.of(fieldId.get());
        }
        String schemaString = DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable.build());
        try {
            ProtocolEntry protocolEntry;
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            boolean transactionLogFileExists = fileSystem.listFiles(deltaLogDirectory).hasNext();
            if (!replaceExistingTable && transactionLogFileExists) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Using CREATE [OR REPLACE] TABLE with an existing table content is disallowed, instead use the system.register_table() procedure.");
            }
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriterWithoutTransactionIsolation(session, location);
            if (replaceExistingTable) {
                commitVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, location, tableHandle.getReadVersion()) + 1L;
                transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, location);
                try (Stream<AddFileEntry> activeFiles = this.transactionLogAccess.getActiveFiles(session, this.getSnapshot(session, tableHandle), tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), tableHandle.getEnforcedPartitionConstraint(), tableHandle.getProjectedColumns().orElse((Set<DeltaLakeColumnHandle>)ImmutableSet.of()));){
                    Iterator addFileEntryIterator = activeFiles.iterator();
                    while (addFileEntryIterator.hasNext()) {
                        long writeTimestamp = Instant.now().toEpochMilli();
                        AddFileEntry addFileEntry = (AddFileEntry)addFileEntryIterator.next();
                        transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(addFileEntry.getPath(), addFileEntry.getPartitionValues(), writeTimestamp, true, Optional.empty()));
                    }
                }
                protocolEntry = this.protocolEntryForTable(tableHandle.getProtocolEntry().minReaderVersion(), tableHandle.getProtocolEntry().minWriterVersion(), containsTimestampType, tableMetadata.getProperties());
                this.statisticsAccess.deleteExtendedStatistics(session, schemaTableName, location);
            } else {
                this.setRollback(() -> DeltaLakeMetadata.deleteRecursivelyIfExists(fileSystem, deltaLogDirectory));
                protocolEntry = this.protocolEntryForTable(1, 2, containsTimestampType, tableMetadata.getProperties());
            }
            this.appendTableEntries(commitVersion, transactionLogWriter, saveMode == SaveMode.REPLACE ? CREATE_OR_REPLACE_TABLE_OPERATION : CREATE_TABLE_OPERATION, session, protocolEntry, MetadataEntry.builder().setDescription(tableMetadata.getComment()).setSchemaString(DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable.build())).setPartitionColumns(DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties())).setConfiguration(MetadataEntry.configurationForNewTable(checkpointInterval, changeDataFeedEnabled, deletionVectorsEnabled, columnMappingMode, maxFieldId)));
            transactionLogWriter.flush();
            if (replaceExistingTable) {
                this.writeCheckpointIfNeeded(session, schemaTableName, location, tableHandle.getReadVersion(), checkpointInterval, commitVersion);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to access file system for: " + location, (Throwable)e);
        }
        Table table = this.buildTable(session, schemaTableName, location, external, tableMetadata.getComment(), commitVersion, schemaString);
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow()));
        this.statisticsAccess.invalidateCache(schemaTableName, Optional.of(location));
        this.transactionLogAccess.invalidateCache(schemaTableName, Optional.of(location));
        if (replaceExistingTable) {
            this.metastore.replaceTable(table, principalPrivileges);
        } else {
            this.metastore.createTable(table, principalPrivileges);
        }
    }

    public Table buildTable(ConnectorSession session, SchemaTableName schemaTableName, String location, boolean isExternal, Optional<String> tableComment, long version, String schemaString) {
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaTableName.getSchemaName()).setTableName(schemaTableName.getTableName()).setOwner(Optional.of(session.getUser())).setTableType(isExternal ? TableType.EXTERNAL_TABLE.name() : TableType.MANAGED_TABLE.name()).setDataColumns(DUMMY_DATA_COLUMNS).setParameters(this.deltaTableProperties(session, location, isExternal, tableComment, version, schemaString));
        DeltaLakeMetadata.setDeltaStorageFormat(tableBuilder, location);
        return tableBuilder.build();
    }

    private Map<String, String> deltaTableProperties(ConnectorSession session, String location, boolean external, Optional<String> tableComment, long version, String schemaString) {
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"trino_query_id", (Object)session.getQueryId()).put((Object)"location", (Object)location).put((Object)"spark.sql.sources.provider", (Object)"DELTA").put((Object)"numFiles", (Object)"-1").put((Object)"totalSize", (Object)"-1");
        if (external) {
            properties.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        if (this.metadataScheduler.canStoreTableMetadata(session, schemaString, tableComment)) {
            properties.putAll(DeltaLakeTableMetadataScheduler.tableMetadataParameters(version, schemaString, tableComment));
        }
        return properties.buildOrThrow();
    }

    private static void setDeltaStorageFormat(Table.Builder tableBuilder, String location) {
        tableBuilder.getStorageBuilder().setStorageFormat(DELTA_STORAGE_FORMAT).setSerdeParameters((Map)ImmutableMap.of((Object)PATH_PROPERTY, (Object)location)).setLocation(location);
    }

    public DeltaLakeOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        ProtocolEntry protocolEntry;
        this.validateTableColumns(tableMetadata);
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Database schema = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        ConnectorTableHandle connectorTableHandle = this.getTableHandle(session, tableMetadata.getTable(), Optional.empty(), Optional.empty());
        DeltaLakeTableHandle handle = null;
        if (connectorTableHandle != null) {
            handle = DeltaLakeMetadata.checkValidTableHandle(connectorTableHandle);
        }
        List<String> partitionedBy = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
        boolean replaceExistingTable = handle != null && replace;
        boolean external = true;
        String location = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        if (replaceExistingTable) {
            ConnectorTableMetadata existingTableMetadata = this.getTableMetadata(session, handle);
            this.validateTableForReplaceOperation(handle, existingTableMetadata, tableMetadata);
            String currentLocation = DeltaLakeTableProperties.getLocation(existingTableMetadata.getProperties());
            if (location != null && !Locations.areDirectoryLocationsEquivalent((Location)Location.of((String)location), (Location)Location.of((String)currentLocation))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("The provided location '%s' does not match the existing table location '%s'", location, currentLocation));
            }
            location = currentLocation;
            boolean bl = external = !handle.isManaged();
        }
        if (location == null) {
            location = this.getTableLocation(schema, tableName);
            external = false;
        }
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeTableProperties.getColumnMappingMode(tableMetadata.getProperties());
        AtomicInteger fieldId = new AtomicInteger();
        Location finalLocation = Location.of((String)location);
        boolean usePhysicalName = columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.ID || columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.NAME;
        boolean containsTimestampType = false;
        int columnSize = tableMetadata.getColumns().size();
        DeltaLakeTable.Builder deltaTable = DeltaLakeTable.builder();
        ImmutableList.Builder columnHandles = ImmutableList.builderWithExpectedSize((int)columnSize);
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            ImmutableMap columnMetadata;
            String physicalName;
            OptionalInt id;
            Type physicalType;
            containsTimestampType |= DeltaLakeMetadata.containsTimestampType(column.getType());
            Object serializedType = DeltaLakeSchemaSupport.serializeColumnType(columnMappingMode, fieldId, column.getType());
            try {
                physicalType = DeltaLakeSchemaSupport.deserializeType(this.typeManager, serializedType, usePhysicalName);
            }
            catch (DeltaLakeSchemaSupport.UnsupportedTypeException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(column.getType()));
            }
            switch (columnMappingMode) {
                case NONE: {
                    id = OptionalInt.empty();
                    physicalName = column.getName();
                    columnMetadata = ImmutableMap.of();
                    break;
                }
                case ID: 
                case NAME: {
                    columnMetadata = DeltaLakeSchemaSupport.generateColumnMetadata(columnMappingMode, fieldId);
                    id = OptionalInt.of(fieldId.get());
                    physicalName = (String)columnMetadata.get("delta.columnMapping.physicalName");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected column mapping mode: " + String.valueOf((Object)columnMappingMode));
                }
            }
            columnHandles.add((Object)DeltaLakeMetadata.toColumnHandle(column.getName(), column.getType(), id, physicalName, physicalType, partitionedBy));
            deltaTable.addColumn(column.getName(), serializedType, column.isNullable(), column.getComment(), (Map<String, Object>)columnMetadata);
        }
        OptionalInt maxFieldId = OptionalInt.empty();
        if (columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.ID || columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.NAME) {
            maxFieldId = OptionalInt.of(fieldId.get());
        }
        OptionalLong readVersion = OptionalLong.empty();
        if (replaceExistingTable) {
            protocolEntry = this.protocolEntryForTable(handle.getProtocolEntry().minReaderVersion(), handle.getProtocolEntry().minWriterVersion(), containsTimestampType, tableMetadata.getProperties());
            readVersion = OptionalLong.of(handle.getReadVersion());
        } else {
            this.checkPathContainsNoFiles(session, finalLocation);
            this.setRollback(() -> DeltaLakeMetadata.deleteRecursivelyIfExists(this.fileSystemFactory.create(session), finalLocation));
            protocolEntry = this.protocolEntryForTable(1, 2, containsTimestampType, tableMetadata.getProperties());
        }
        return new DeltaLakeOutputTableHandle(schemaName, tableName, (List<DeltaLakeColumnHandle>)columnHandles.build(), location, DeltaLakeTableProperties.getCheckpointInterval(tableMetadata.getProperties()), external, tableMetadata.getComment(), DeltaLakeTableProperties.getChangeDataFeedEnabled(tableMetadata.getProperties()), DeltaLakeTableProperties.getDeletionVectorsEnabled(tableMetadata.getProperties()), DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable.build()), columnMappingMode, maxFieldId, replace, readVersion, protocolEntry);
    }

    private Optional<String> getSchemaLocation(Database database) {
        Optional schemaLocation = database.getLocation();
        if (schemaLocation.isEmpty() || ((String)schemaLocation.get()).isEmpty()) {
            return Optional.empty();
        }
        return schemaLocation;
    }

    private String getTableLocation(Database schema, String tableName) {
        String schemaLocation = this.getSchemaLocation(schema).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The 'location' property must be specified either for the table or the schema"));
        Object tableNameLocationComponent = HiveUtil.escapeTableName((String)tableName);
        if (this.useUniqueTableLocation) {
            tableNameLocationComponent = (String)tableNameLocationComponent + "-" + UUID.randomUUID().toString().replace("-", "");
        }
        return Locations.appendPath((String)schemaLocation, (String)tableNameLocationComponent);
    }

    private void checkPathContainsNoFiles(ConnectorSession session, Location targetPath) {
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            if (fileSystem.listFiles(targetPath).hasNext()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target location cannot contain any files: " + String.valueOf(targetPath));
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to access file system for: " + String.valueOf(targetPath), (Throwable)e);
        }
    }

    private void validateTableColumns(ConnectorTableMetadata tableMetadata) {
        Sets.SetView conflicts;
        DeltaLakeMetadata.checkPartitionColumns(tableMetadata.getColumns(), DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        this.checkColumnTypes(tableMetadata.getColumns());
        if (DeltaLakeTableProperties.getChangeDataFeedEnabled(tableMetadata.getProperties()).orElse(false).booleanValue() && !(conflicts = Sets.intersection((Set)((Set)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet())), CHANGE_DATA_FEED_COLUMN_NAMES)).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unable to use %s when change data feed is enabled".formatted(conflicts));
        }
    }

    private void validateTableForReplaceOperation(DeltaLakeTableHandle tableHandle, ConnectorTableMetadata existingTableMetadata, ConnectorTableMetadata newTableMetadata) {
        if (DeltaLakeSchemaSupport.isAppendOnly(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot replace a table when 'delta.appendOnly' is set to true");
        }
        if (DeltaLakeTableProperties.getChangeDataFeedEnabled(existingTableMetadata.getProperties()).orElse(false).booleanValue() || DeltaLakeTableProperties.getChangeDataFeedEnabled(newTableMetadata.getProperties()).orElse(false).booleanValue()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE OR REPLACE is not supported for tables with change data feed enabled");
        }
    }

    private static void checkPartitionColumns(List<ColumnMetadata> columns, List<String> partitionColumnNames) {
        Set columnNames = (Set)columns.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        List invalidPartitionNames = (List)partitionColumnNames.stream().filter(partitionColumnName -> !columnNames.contains(partitionColumnName)).collect(ImmutableList.toImmutableList());
        if (columns.stream().filter(column -> partitionColumnNames.contains(column.getName())).anyMatch(column -> column.getType() instanceof ArrayType || column.getType() instanceof MapType || column.getType() instanceof RowType)) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Using array, map or row type on partitioned columns is unsupported");
        }
        if (!invalidPartitionNames.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Table property 'partitioned_by' contained column names which do not exist: " + String.valueOf(invalidPartitionNames));
        }
        if (columns.size() == partitionColumnNames.size()) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Using all columns for partition columns is unsupported");
        }
    }

    private void checkColumnTypes(List<ColumnMetadata> columnMetadata) {
        for (ColumnMetadata column : columnMetadata) {
            Type type = column.getType();
            DeltaLakeSchemaSupport.validateType(type);
        }
    }

    private static void deleteRecursivelyIfExists(TrinoFileSystem fileSystem, Location path) {
        try {
            fileSystem.deleteDirectory(path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "IOException while trying to delete '%s'", new Object[]{path});
        }
    }

    private static boolean containsTimestampType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return DeltaLakeMetadata.containsTimestampType(arrayType.getElementType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return DeltaLakeMetadata.containsTimestampType(mapType.getKeyType()) || DeltaLakeMetadata.containsTimestampType(mapType.getValueType());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return rowType.getFields().stream().anyMatch(field -> DeltaLakeMetadata.containsTimestampType(field.getType()));
        }
        Preconditions.checkArgument((boolean)type.getTypeParameters().isEmpty(), (String)"Unexpected type parameters for type %s", (Object)type);
        return type instanceof TimestampType;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeOutputTableHandle handle = (DeltaLakeOutputTableHandle)tableHandle;
        String schemaName = handle.schemaName();
        String tableName = handle.tableName();
        String location = handle.location();
        List dataFileInfos = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        SchemaTableName schemaTableName = SchemaTableName.schemaTableName((String)schemaName, (String)tableName);
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = handle.columnMappingMode();
        String schemaString = handle.schemaString();
        List columnNames = (List)handle.inputColumns().stream().map(DeltaLakeColumnHandle::baseColumnName).collect(ImmutableList.toImmutableList());
        List physicalPartitionNames = (List)handle.inputColumns().stream().filter(column -> column.columnType() == DeltaLakeColumnType.PARTITION_KEY).map(DeltaLakeColumnHandle::basePhysicalColumnName).collect(ImmutableList.toImmutableList());
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter;
            long commitVersion = 0L;
            if (handle.readVersion().isEmpty()) {
                transactionLogWriter = this.transactionLogWriterFactory.newWriterWithoutTransactionIsolation(session, handle.location());
            } else {
                TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
                commitVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, handle.location(), handle.readVersion().getAsLong()) + 1L;
                if (commitVersion != handle.readVersion().getAsLong() + 1L) {
                    throw new TransactionConflictException(String.format("Conflicting concurrent writes found. Expected transaction log version: %s, actual version: %s", handle.readVersion().getAsLong(), commitVersion - 1L));
                }
                transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.location());
            }
            this.appendTableEntries(commitVersion, transactionLogWriter, handle.replace() ? CREATE_OR_REPLACE_TABLE_AS_OPERATION : CREATE_TABLE_AS_OPERATION, session, handle.protocolEntry(), MetadataEntry.builder().setDescription(handle.comment()).setSchemaString(schemaString).setPartitionColumns(handle.partitionedBy()).setConfiguration(MetadataEntry.configurationForNewTable(handle.checkpointInterval(), handle.changeDataFeedEnabled(), handle.deletionVectorsEnabled(), columnMappingMode, handle.maxColumnId())));
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, physicalPartitionNames, columnNames, true);
            if (handle.readVersion().isPresent()) {
                long writeTimestamp = Instant.now().toEpochMilli();
                DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)this.getTableHandle(session, schemaTableName, Optional.empty(), Optional.empty());
                try (Stream<AddFileEntry> activeFiles = this.transactionLogAccess.getActiveFiles(session, this.getSnapshot(session, deltaLakeTableHandle), deltaLakeTableHandle.getMetadataEntry(), deltaLakeTableHandle.getProtocolEntry(), deltaLakeTableHandle.getEnforcedPartitionConstraint(), deltaLakeTableHandle.getProjectedColumns().orElse((Set<DeltaLakeColumnHandle>)ImmutableSet.of()));){
                    Iterator addFileEntryIterator = activeFiles.iterator();
                    while (addFileEntryIterator.hasNext()) {
                        AddFileEntry addFileEntry = (AddFileEntry)addFileEntryIterator.next();
                        transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(addFileEntry.getPath(), addFileEntry.getPartitionValues(), writeTimestamp, true, Optional.empty()));
                    }
                }
            }
            transactionLogWriter.flush();
            writeCommitted = true;
            if (handle.replace() && handle.readVersion().isPresent()) {
                this.writeCheckpointIfNeeded(session, schemaTableName, handle.location(), handle.readVersion().getAsLong(), handle.checkpointInterval(), commitVersion);
            }
            if (DeltaLakeSessionProperties.isCollectExtendedStatisticsColumnStatisticsOnWrite(session) && !computedStatistics.isEmpty()) {
                Optional<Instant> maxFileModificationTime = dataFileInfos.stream().map(DataFileInfo::creationTime).max(Long::compare).map(Instant::ofEpochMilli);
                Map physicalColumnMapping = (Map)DeltaLakeSchemaSupport.getColumnMetadata(schemaString, this.typeManager, columnMappingMode, handle.partitionedBy()).stream().map(e -> Map.entry(e.name(), e.physicalName())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
                this.updateTableStatistics(session, Optional.empty(), schemaTableName, location, maxFileModificationTime, computedStatistics, columnNames, Optional.of(physicalColumnMapping), true);
            }
            Table table = this.buildTable(session, schemaTableName, location, handle.external(), handle.comment(), commitVersion, handle.schemaString());
            PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow()));
            this.statisticsAccess.invalidateCache(schemaTableName, Optional.of(location));
            this.transactionLogAccess.invalidateCache(schemaTableName, Optional.of(location));
            if (handle.readVersion().isPresent()) {
                this.metastore.replaceTable(table, principalPrivileges);
            } else {
                this.metastore.createTable(table, principalPrivileges);
            }
        }
        catch (Exception e2) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, handle.location(), dataFileInfos);
            }
            if (handle.readVersion().isEmpty()) {
                Location transactionLogDir = Location.of((String)TransactionLogUtil.getTransactionLogDir(location));
                try {
                    this.fileSystemFactory.create(session).deleteDirectory(transactionLogDir);
                }
                catch (IOException ioException) {
                    LOG.error((Throwable)ioException, "Transaction log cleanup failed during CREATE TABLE rollback");
                }
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e2);
        }
        return Optional.empty();
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        DeltaLakeTableHandle handle = DeltaLakeMetadata.checkValidTableHandle(tableHandle);
        this.checkSupportedWriterVersion(handle);
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(handle.getMetadataEntry(), handle.getProtocolEntry());
        if (columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.ID && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NAME && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NONE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting a table comment with column mapping %s is not supported".formatted(new Object[]{columnMappingMode}));
        }
        MetadataEntry metadataEntry = handle.getMetadataEntry();
        ProtocolEntry protocolEntry = handle.getProtocolEntry();
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(protocolEntry);
        try {
            long commitVersion = handle.getReadVersion() + 1L;
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.getLocation());
            this.appendTableEntries(commitVersion, transactionLogWriter, SET_TBLPROPERTIES_OPERATION, session, protocolEntry, MetadataEntry.builder(handle.getMetadataEntry()).setDescription(comment));
            transactionLogWriter.flush();
            this.enqueueUpdateInfo(session, handle.getSchemaName(), handle.getTableName(), commitVersion, metadataEntry.getSchemaString(), comment);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to comment on table: %s.%s", handle.getSchemaName(), handle.getTableName()), (Throwable)e);
        }
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
        DeltaLakeColumnHandle deltaLakeColumnHandle = (DeltaLakeColumnHandle)column;
        Verify.verify((boolean)deltaLakeColumnHandle.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)column);
        this.checkSupportedWriterVersion(deltaLakeTableHandle);
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(deltaLakeTableHandle.getMetadataEntry(), deltaLakeTableHandle.getProtocolEntry());
        if (columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.ID && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NAME && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NONE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting a column comment with column mapping %s is not supported".formatted(new Object[]{columnMappingMode}));
        }
        ProtocolEntry protocolEntry = deltaLakeTableHandle.getProtocolEntry();
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(protocolEntry);
        try {
            long commitVersion = deltaLakeTableHandle.getReadVersion() + 1L;
            DeltaLakeTable deltaTable = DeltaLakeTable.builder(deltaLakeTableHandle.getMetadataEntry(), deltaLakeTableHandle.getProtocolEntry()).setColumnComment(deltaLakeColumnHandle.baseColumnName(), comment.orElse(null)).build();
            String schemaString = DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable);
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, deltaLakeTableHandle.getLocation());
            this.appendTableEntries(commitVersion, transactionLogWriter, CHANGE_COLUMN_OPERATION, session, protocolEntry, MetadataEntry.builder(deltaLakeTableHandle.getMetadataEntry()).setSchemaString(schemaString));
            transactionLogWriter.flush();
            this.enqueueUpdateInfo(session, deltaLakeTableHandle.getSchemaName(), deltaLakeTableHandle.getTableName(), commitVersion, schemaString, Optional.ofNullable(deltaLakeTableHandle.getMetadataEntry().getDescription()));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to add '%s' column comment for: %s.%s", deltaLakeColumnHandle.baseColumnName(), deltaLakeTableHandle.getSchemaName(), deltaLakeTableHandle.getTableName()), (Throwable)e);
        }
    }

    public void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        this.trinoViewHiveMetastore.updateViewComment(session, viewName, comment);
    }

    public void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        this.trinoViewHiveMetastore.updateViewColumnComment(session, viewName, columnName, comment);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata newColumnMetadata) {
        DeltaLakeTableHandle handle = DeltaLakeMetadata.checkValidTableHandle(tableHandle);
        ProtocolEntry protocolEntry = handle.getProtocolEntry();
        this.checkSupportedWriterVersion(handle);
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(handle.getMetadataEntry(), protocolEntry);
        Optional<Boolean> changeDataFeedEnabled = DeltaLakeSchemaSupport.changeDataFeedEnabled(handle.getMetadataEntry(), protocolEntry);
        if (changeDataFeedEnabled.orElse(false).booleanValue() && CHANGE_DATA_FEED_COLUMN_NAMES.contains(newColumnMetadata.getName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Column name %s is forbidden when change data feed is enabled".formatted(newColumnMetadata.getName()));
        }
        boolean deletionVectorEnabled = DeltaLakeSchemaSupport.isDeletionVectorEnabled(handle.getMetadataEntry(), protocolEntry);
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(protocolEntry);
        if (!newColumnMetadata.isNullable()) {
            boolean tableHasDataFiles;
            try (Stream<AddFileEntry> addFileEntries = this.transactionLogAccess.getActiveFiles(session, this.getSnapshot(session, handle), handle.getMetadataEntry(), handle.getProtocolEntry(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (Predicate<String>)Predicates.alwaysFalse());){
                tableHasDataFiles = addFileEntries.findAny().isPresent();
            }
            if (tableHasDataFiles) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to add NOT NULL column '%s' for non-empty table: %s.%s", newColumnMetadata.getName(), handle.getSchemaName(), handle.getTableName()));
            }
        }
        try {
            long commitVersion = handle.getReadVersion() + 1L;
            AtomicInteger maxColumnId = switch (columnMappingMode) {
                case DeltaLakeSchemaSupport.ColumnMappingMode.NONE -> new AtomicInteger();
                case DeltaLakeSchemaSupport.ColumnMappingMode.ID, DeltaLakeSchemaSupport.ColumnMappingMode.NAME -> new AtomicInteger(DeltaLakeSchemaSupport.getMaxColumnId(handle.getMetadataEntry()));
                default -> throw new IllegalArgumentException("Unexpected column mapping mode: " + String.valueOf((Object)columnMappingMode));
            };
            DeltaLakeTable deltaTable = DeltaLakeTable.builder(handle.getMetadataEntry(), handle.getProtocolEntry()).addColumn(newColumnMetadata.getName(), DeltaLakeSchemaSupport.serializeColumnType(columnMappingMode, maxColumnId, newColumnMetadata.getType()), newColumnMetadata.isNullable(), newColumnMetadata.getComment(), DeltaLakeSchemaSupport.generateColumnMetadata(columnMappingMode, maxColumnId)).build();
            String schemaString = DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable);
            HashMap<String, String> configuration = new HashMap<String, String>(handle.getMetadataEntry().getConfiguration());
            if (columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.ID || columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.NAME) {
                Preconditions.checkArgument((maxColumnId.get() > 0 ? 1 : 0) != 0, (String)"maxColumnId must be larger than 0: %s", (Object)maxColumnId);
                configuration.put("delta.columnMapping.maxColumnId", String.valueOf(maxColumnId.get()));
            }
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.getLocation());
            this.appendTableEntries(commitVersion, transactionLogWriter, ADD_COLUMN_OPERATION, session, this.protocolEntry(ProtocolEntry.builder(protocolEntry), DeltaLakeMetadata.containsTimestampType(newColumnMetadata.getType()), changeDataFeedEnabled, columnMappingMode, deletionVectorEnabled), MetadataEntry.builder(handle.getMetadataEntry()).setSchemaString(schemaString).setConfiguration(configuration));
            transactionLogWriter.flush();
            this.enqueueUpdateInfo(session, handle.getSchemaName(), handle.getTableName(), commitVersion, schemaString, Optional.ofNullable(handle.getMetadataEntry().getDescription()));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to add '%s' column for: %s.%s %s", newColumnMetadata.getName(), handle.getSchemaName(), handle.getTableName(), MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e)), (Throwable)e);
        }
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        DeltaLakeColumnHandle deltaLakeColumn = (DeltaLakeColumnHandle)columnHandle;
        Verify.verify((boolean)deltaLakeColumn.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)deltaLakeColumn);
        String dropColumnName = deltaLakeColumn.baseColumnName();
        MetadataEntry metadataEntry = table.getMetadataEntry();
        ProtocolEntry protocolEntry = table.getProtocolEntry();
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(protocolEntry);
        this.checkSupportedWriterVersion(table);
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry, protocolEntry);
        if (columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NAME && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.ID) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop column from table using column mapping mode " + String.valueOf((Object)columnMappingMode));
        }
        long commitVersion = table.getReadVersion() + 1L;
        List<String> partitionColumns = metadataEntry.getOriginalPartitionColumns();
        if (partitionColumns.contains(dropColumnName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition column: " + dropColumnName);
        }
        List<DeltaLakeColumnMetadata> columns = DeltaLakeSchemaSupport.extractSchema(metadataEntry, protocolEntry, this.typeManager);
        List columnNames = (List)DeltaLakeSchemaSupport.getExactColumnNames(metadataEntry).stream().filter(name -> !name.equalsIgnoreCase(dropColumnName)).collect(ImmutableList.toImmutableList());
        if (columns.size() == columnNames.size()) {
            throw new ColumnNotFoundException(table.schemaTableName(), dropColumnName);
        }
        if (columnNames.size() == partitionColumns.size()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Dropping the last non-partition column is unsupported");
        }
        Map lowerCaseToExactColumnNames = (Map)DeltaLakeSchemaSupport.getExactColumnNames(metadataEntry).stream().collect(ImmutableMap.toImmutableMap(name -> name.toLowerCase(Locale.ENGLISH), name -> name));
        Map physicalColumnNameMapping = (Map)columns.stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnMetadata::name, DeltaLakeColumnMetadata::physicalName));
        DeltaLakeTable deltaTable = DeltaLakeTable.builder(metadataEntry, protocolEntry).removeColumn(dropColumnName).build();
        if (deltaTable.columns().size() == partitionColumns.size()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Dropping the last non-partition column is unsupported");
        }
        String schemaString = DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable);
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, table.getLocation());
            this.appendTableEntries(commitVersion, transactionLogWriter, DROP_COLUMN_OPERATION, session, protocolEntry, MetadataEntry.builder(metadataEntry).setSchemaString(schemaString));
            transactionLogWriter.flush();
            this.enqueueUpdateInfo(session, table.getSchemaName(), table.getTableName(), commitVersion, schemaString, Optional.ofNullable(metadataEntry.getDescription()));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to drop '%s' column from: %s.%s", dropColumnName, table.getSchemaName(), table.getTableName()), (Throwable)e);
        }
        try {
            this.statisticsAccess.readExtendedStatistics(session, table.getSchemaTableName(), table.getLocation()).ifPresent(existingStatistics -> {
                ExtendedStatistics statistics = new ExtendedStatistics(existingStatistics.getAlreadyAnalyzedModifiedTimeMax(), (Map)existingStatistics.getColumnStatistics().entrySet().stream().filter(stats -> !((String)stats.getKey()).equalsIgnoreCase(DeltaLakeMetadata.toPhysicalColumnName(dropColumnName, lowerCaseToExactColumnNames, Optional.of(physicalColumnNameMapping)))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)), existingStatistics.getAnalyzedColumns().map(analyzedColumns -> (Set)analyzedColumns.stream().filter(column -> !column.equalsIgnoreCase(dropColumnName)).collect(ImmutableSet.toImmutableSet())));
                this.statisticsAccess.updateExtendedStatistics(session, table.getSchemaTableName(), table.getLocation(), statistics);
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Failed to update extended statistics when dropping %s column from %s table", new Object[]{dropColumnName, table.schemaTableName()});
        }
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, String newColumnName) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        DeltaLakeColumnHandle deltaLakeColumn = (DeltaLakeColumnHandle)columnHandle;
        Verify.verify((boolean)deltaLakeColumn.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)deltaLakeColumn);
        String sourceColumnName = deltaLakeColumn.baseColumnName();
        ProtocolEntry protocolEntry = table.getProtocolEntry();
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(protocolEntry);
        this.checkSupportedWriterVersion(table);
        if (DeltaLakeSchemaSupport.changeDataFeedEnabled(table.getMetadataEntry(), protocolEntry).orElse(false).booleanValue()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot rename column when change data feed is enabled");
        }
        MetadataEntry metadataEntry = table.getMetadataEntry();
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry, protocolEntry);
        if (columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NAME && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.ID) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot rename column in table using column mapping mode " + String.valueOf((Object)columnMappingMode));
        }
        long commitVersion = table.getReadVersion() + 1L;
        List partitionColumns = (List)metadataEntry.getOriginalPartitionColumns().stream().map(columnName -> columnName.equalsIgnoreCase(sourceColumnName) ? newColumnName : columnName).collect(ImmutableList.toImmutableList());
        DeltaLakeTable deltaTable = DeltaLakeTable.builder(metadataEntry, protocolEntry).renameColumn(sourceColumnName, newColumnName).build();
        String schemaString = DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable);
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, table.getLocation());
            this.appendTableEntries(commitVersion, transactionLogWriter, RENAME_COLUMN_OPERATION, session, protocolEntry, MetadataEntry.builder(metadataEntry).setSchemaString(schemaString).setPartitionColumns(partitionColumns));
            transactionLogWriter.flush();
            this.enqueueUpdateInfo(session, table.getSchemaName(), table.getTableName(), commitVersion, schemaString, Optional.ofNullable(metadataEntry.getDescription()));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to rename '%s' column for: %s.%s", sourceColumnName, table.getSchemaName(), table.getTableName()), (Throwable)e);
        }
    }

    public void dropNotNullConstraint(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        DeltaLakeColumnHandle column = (DeltaLakeColumnHandle)columnHandle;
        Verify.verify((boolean)column.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)column);
        String columnName = column.baseColumnName();
        MetadataEntry metadataEntry = table.getMetadataEntry();
        ProtocolEntry protocolEntry = table.getProtocolEntry();
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(protocolEntry);
        this.checkSupportedWriterVersion(table);
        DeltaLakeTable deltaTable = DeltaLakeTable.builder(metadataEntry, protocolEntry).dropNotNullConstraint(columnName).build();
        long commitVersion = table.getReadVersion() + 1L;
        String schemaString = DeltaLakeSchemaSupport.serializeSchemaAsJson(deltaTable);
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, table.getLocation());
            this.appendTableEntries(commitVersion, transactionLogWriter, CHANGE_COLUMN_OPERATION, session, protocolEntry, MetadataEntry.builder(metadataEntry).setSchemaString(schemaString));
            transactionLogWriter.flush();
            this.enqueueUpdateInfo(session, table.getSchemaName(), table.getTableName(), commitVersion, schemaString, Optional.ofNullable(metadataEntry.getDescription()));
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to drop not null constraint from '%s' column in: %s", columnName, table.getSchemaTableName()), (Throwable)e);
        }
    }

    private void appendTableEntries(long commitVersion, TransactionLogWriter transactionLogWriter, String operation, ConnectorSession session, ProtocolEntry protocolEntry, MetadataEntry.Builder metadataEntry) {
        long createdTime = System.currentTimeMillis();
        transactionLogWriter.appendCommitInfoEntry(this.getCommitInfoEntry(session, DeltaLakeSchemaSupport.IsolationLevel.WRITESERIALIZABLE, commitVersion, createdTime, operation, 0L, true));
        transactionLogWriter.appendProtocolEntry(protocolEntry);
        transactionLogWriter.appendMetadataEntry(metadataEntry.setCreatedTime(createdTime).build());
    }

    private static void appendAddFileEntries(TransactionLogWriter transactionLogWriter, List<DataFileInfo> dataFileInfos, List<String> partitionColumnNames, List<String> originalColumnNames, boolean dataChange) throws JsonProcessingException {
        Map toOriginalColumnNames = (Map)originalColumnNames.stream().collect(ImmutableMap.toImmutableMap(name -> name.toLowerCase(Locale.ENGLISH), Function.identity()));
        for (DataFileInfo info : dataFileInfos) {
            HashMap<String, String> partitionValues = new HashMap<String, String>();
            for (int i = 0; i < partitionColumnNames.size(); ++i) {
                partitionValues.put(partitionColumnNames.get(i), info.partitionValues().get(i));
            }
            Optional<Map<String, Object>> minStats = DeltaLakeMetadata.toOriginalColumnNames(info.statistics().getMinValues(), toOriginalColumnNames);
            Optional<Map<String, Object>> maxStats = DeltaLakeMetadata.toOriginalColumnNames(info.statistics().getMaxValues(), toOriginalColumnNames);
            Optional<Map<String, Object>> nullStats = DeltaLakeMetadata.toOriginalColumnNames(info.statistics().getNullCount(), toOriginalColumnNames);
            DeltaLakeJsonFileStatistics statisticsWithExactNames = new DeltaLakeJsonFileStatistics(info.statistics().getNumRecords(), minStats, maxStats, nullStats);
            partitionValues = Collections.unmodifiableMap(partitionValues);
            transactionLogWriter.appendAddFileEntry(new AddFileEntry(DeltaLakeMetadata.toUriFormat(info.path()), partitionValues, info.size(), info.creationTime(), dataChange, Optional.of(DeltaLakeSchemaSupport.serializeStatsAsJson(statisticsWithExactNames)), Optional.empty(), (Map<String, String>)ImmutableMap.of(), info.deletionVector()));
        }
    }

    private static Optional<Map<String, Object>> toOriginalColumnNames(Optional<Map<String, Object>> statistics, Map<String, String> lowerCaseToExactColumnNames) {
        return statistics.map(statsMap -> (Map)statsMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(stats -> lowerCaseToExactColumnNames.getOrDefault(((String)stats.getKey()).toLowerCase(Locale.ENGLISH), (String)stats.getKey()), Map.Entry::getValue)));
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        this.checkWriteAllowed(session, table);
        this.checkWriteSupported(table);
        List inputColumns = (List)columns.stream().map(handle -> (DeltaLakeColumnHandle)handle).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, table);
        this.checkAllColumnsPassedOnInsert(tableMetadata, inputColumns);
        return this.createInsertHandle(retryMode, table, inputColumns);
    }

    private DeltaLakeInsertTableHandle createInsertHandle(RetryMode retryMode, DeltaLakeTableHandle table, List<DeltaLakeColumnHandle> inputColumns) {
        String tableLocation = table.getLocation();
        return new DeltaLakeInsertTableHandle(table.getSchemaTableName(), tableLocation, table.getMetadataEntry(), table.getProtocolEntry(), inputColumns, table.getReadVersion(), retryMode != RetryMode.NO_RETRIES);
    }

    private void checkAllColumnsPassedOnInsert(ConnectorTableMetadata tableMetadata, List<DeltaLakeColumnHandle> insertColumns) {
        List allColumnNames = (List)tableMetadata.getColumns().stream().filter(Predicate.not(ColumnMetadata::isHidden)).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        List insertColumnNames = (List)insertColumns.stream().map(column -> column.baseColumnName().toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)allColumnNames.equals(insertColumnNames), (String)"Not all table columns passed on INSERT; table columns=%s; insert columns=%s", (Object)allColumnNames, (Object)insertColumnNames);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeInsertTableHandle handle = (DeltaLakeInsertTableHandle)insertHandle;
        List dataFileInfos = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        if (handle.retriesEnabled()) {
            this.cleanExtraOutputFiles(session, Location.of((String)handle.location()), dataFileInfos);
        }
        boolean writeCommitted = false;
        try {
            DeltaLakeSchemaSupport.IsolationLevel isolationLevel = DeltaLakeSchemaSupport.getIsolationLevel(handle.metadataEntry());
            AtomicReference<Long> readVersion = new AtomicReference<Long>(handle.readVersion());
            long commitVersion = (Long)Failsafe.with(TRANSACTION_CONFLICT_RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(context -> this.commitInsertOperation(session, handle, sourceTableHandles, isolationLevel, dataFileInfos, readVersion, context.getAttemptCount()));
            writeCommitted = true;
            this.writeCheckpointIfNeeded(session, handle.tableName(), handle.location(), handle.readVersion(), handle.metadataEntry().getCheckpointInterval(), commitVersion);
            this.enqueueUpdateInfo(session, handle.tableName().getSchemaName(), handle.tableName().getTableName(), commitVersion, handle.metadataEntry().getSchemaString(), Optional.ofNullable(handle.metadataEntry().getDescription()));
            if (DeltaLakeSessionProperties.isCollectExtendedStatisticsColumnStatisticsOnWrite(session) && !computedStatistics.isEmpty() && !dataFileInfos.isEmpty()) {
                Optional<Instant> maxFileModificationTime = dataFileInfos.stream().map(DataFileInfo::creationTime).max(Long::compare).map(Instant::ofEpochMilli);
                this.updateTableStatistics(session, Optional.empty(), handle.tableName(), handle.location(), maxFileModificationTime, computedStatistics, DeltaLakeSchemaSupport.getExactColumnNames(handle.metadataEntry()), Optional.of((Map)DeltaLakeSchemaSupport.extractSchema(handle.metadataEntry(), handle.protocolEntry(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnMetadata::name, DeltaLakeColumnMetadata::physicalName))), true);
            }
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, handle.location(), dataFileInfos);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
        return Optional.empty();
    }

    private long commitInsertOperation(ConnectorSession session, DeltaLakeInsertTableHandle handle, List<ConnectorTableHandle> sourceTableHandles, DeltaLakeSchemaSupport.IsolationLevel isolationLevel, List<DataFileInfo> dataFileInfos, AtomicReference<Long> readVersion, int attemptCount) throws IOException {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        long currentVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, handle.location(), readVersion.get());
        List<DeltaLakeTableHandle> sameAsTargetSourceTableHandles = this.getSameAsTargetSourceTableHandles(sourceTableHandles, handle.tableName());
        List enforcedSourcePartitionConstraints = (List)sameAsTargetSourceTableHandles.stream().map(DeltaLakeTableHandle::getEnforcedPartitionConstraint).collect(ImmutableList.toImmutableList());
        this.checkForConcurrentTransactionConflicts(session, fileSystem, enforcedSourcePartitionConstraints, isolationLevel, currentVersion, readVersion, handle.location(), attemptCount);
        long commitVersion = currentVersion + 1L;
        this.writeTransactionLogForInsertOperation(session, handle, sameAsTargetSourceTableHandles.isEmpty(), isolationLevel, dataFileInfos, commitVersion, currentVersion);
        return commitVersion;
    }

    private List<DeltaLakeTableHandle> getSameAsTargetSourceTableHandles(List<ConnectorTableHandle> sourceTableHandles, SchemaTableName schemaTableName) {
        return (List)sourceTableHandles.stream().filter(sourceTableHandle -> sourceTableHandle instanceof DeltaLakeTableHandle).map(DeltaLakeTableHandle.class::cast).filter(tableHandle -> schemaTableName.equals((Object)tableHandle.getSchemaTableName()) && !tableHandle.isTimeTravel()).collect(ImmutableList.toImmutableList());
    }

    private void checkForConcurrentTransactionConflicts(ConnectorSession session, TrinoFileSystem fileSystem, List<TupleDomain<DeltaLakeColumnHandle>> enforcedSourcePartitionConstraints, DeltaLakeSchemaSupport.IsolationLevel isolationLevel, long currentVersion, AtomicReference<Long> readVersion, String tableLocation, int attemptCount) {
        long readVersionValue = readVersion.get();
        if (currentVersion > readVersionValue) {
            String transactionLogDirectory = TransactionLogUtil.getTransactionLogDir(tableLocation);
            for (long version = readVersionValue + 1L; version <= currentVersion; ++version) {
                TransactionLogEntries transactionLogEntries;
                try {
                    long finalVersion = version;
                    transactionLogEntries = TransactionLogTail.getEntriesFromJson(version, transactionLogDirectory, fileSystem, DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, "Delta Lake log entries are missing for version " + finalVersion));
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Failed to access table metadata", (Throwable)e);
                }
                DeltaLakeCommitSummary commitSummary = new DeltaLakeCommitSummary(version, transactionLogEntries, fileSystem);
                DeltaLakeMetadata.checkNoMetadataUpdates(commitSummary);
                DeltaLakeMetadata.checkNoProtocolUpdates(commitSummary);
                switch (isolationLevel) {
                    case WRITESERIALIZABLE: {
                        if (enforcedSourcePartitionConstraints.isEmpty()) break;
                        TupleDomain enforcedSourcePartitionConstraintsUnion = TupleDomain.columnWiseUnion(enforcedSourcePartitionConstraints);
                        DeltaLakeMetadata.checkIfCommittedAddedFilesConflictWithCurrentOperation((TupleDomain<DeltaLakeColumnHandle>)enforcedSourcePartitionConstraintsUnion, commitSummary);
                        DeltaLakeMetadata.checkIfCommittedRemovedFilesConflictWithCurrentOperation((TupleDomain<DeltaLakeColumnHandle>)enforcedSourcePartitionConstraintsUnion, commitSummary);
                        break;
                    }
                    case SERIALIZABLE: {
                        throw new TransactionFailedException("Conflicting concurrent writes with the current operation on Serializable isolation level");
                    }
                }
                LOG.debug("Completed checking for conflicts in the query %s for target table version: %s Attempt: %s ", new Object[]{session.getQueryId(), commitSummary.getVersion(), attemptCount});
            }
            readVersion.set(currentVersion);
        }
    }

    private static void checkNoProtocolUpdates(DeltaLakeCommitSummary commitSummary) {
        if (commitSummary.getProtocol().isPresent()) {
            throw new TransactionFailedException("Conflicting concurrent writes found. Protocol changed by concurrent write operation");
        }
    }

    private static void checkNoMetadataUpdates(DeltaLakeCommitSummary commitSummary) {
        if (!commitSummary.getMetadataUpdates().isEmpty()) {
            throw new TransactionFailedException("Conflicting concurrent writes found. Metadata changed by concurrent write operation");
        }
    }

    private static void checkIfCommittedAddedFilesConflictWithCurrentOperation(TupleDomain<DeltaLakeColumnHandle> enforcedSourcePartitionConstraints, DeltaLakeCommitSummary commitSummary) {
        Set<Object> addedFilesCanonicalPartitionValues;
        Set<Object> set = addedFilesCanonicalPartitionValues = commitSummary.getIsBlindAppend().orElse(false) != false ? Set.of() : commitSummary.getAddedFilesCanonicalPartitionValues();
        if (addedFilesCanonicalPartitionValues.isEmpty()) {
            return;
        }
        boolean readWholeTable = enforcedSourcePartitionConstraints.isAll();
        if (readWholeTable) {
            throw new TransactionFailedException("Conflicting concurrent writes found. Data files added in the modified table by concurrent write operation.");
        }
        Map enforcedDomains = (Map)enforcedSourcePartitionConstraints.getDomains().orElseThrow();
        boolean conflictingAddFilesFound = addedFilesCanonicalPartitionValues.stream().anyMatch(canonicalPartitionValues -> DeltaLakeSplitManager.partitionMatchesPredicate(canonicalPartitionValues, enforcedDomains));
        if (conflictingAddFilesFound) {
            throw new TransactionFailedException("Conflicting concurrent writes found. Data files were added in the modified table by another concurrent write operation.");
        }
    }

    private static void checkIfCommittedRemovedFilesConflictWithCurrentOperation(TupleDomain<DeltaLakeColumnHandle> enforcedSourcePartitionConstraints, DeltaLakeCommitSummary commitSummary) {
        if (commitSummary.getIsBlindAppend().orElse(false).booleanValue()) {
            Preconditions.checkState((boolean)commitSummary.getRemovedFilesCanonicalPartitionValues().isEmpty(), (String)"Blind append transaction %s cannot contain removed files", (long)commitSummary.getVersion());
            Preconditions.checkState((!commitSummary.isContainsRemoveFileWithoutPartitionValues() ? 1 : 0) != 0, (String)"Blind append transaction %s cannot contain removed files", (long)commitSummary.getVersion());
            return;
        }
        if (commitSummary.isContainsRemoveFileWithoutPartitionValues()) {
            throw new TransactionFailedException("Conflicting concurrent writes found. Data files removed in the modified table by another concurrent write operation.");
        }
        if (commitSummary.getRemovedFilesCanonicalPartitionValues().isEmpty()) {
            return;
        }
        boolean readWholeTable = enforcedSourcePartitionConstraints.isAll();
        if (readWholeTable) {
            throw new TransactionFailedException("Conflicting concurrent writes found. Data files removed in the modified table by another concurrent write operation.");
        }
        Map enforcedDomains = (Map)enforcedSourcePartitionConstraints.getDomains().orElseThrow();
        boolean conflictingRemoveFilesFound = commitSummary.getRemovedFilesCanonicalPartitionValues().stream().anyMatch(canonicalPartitionValues -> DeltaLakeSplitManager.partitionMatchesPredicate(canonicalPartitionValues, enforcedDomains));
        if (conflictingRemoveFilesFound) {
            throw new TransactionFailedException("Conflicting concurrent writes found. Data files were removed from the modified table by another concurrent write operation.");
        }
    }

    private void writeTransactionLogForInsertOperation(ConnectorSession session, DeltaLakeInsertTableHandle insertTableHandle, boolean isBlindAppend, DeltaLakeSchemaSupport.IsolationLevel isolationLevel, List<DataFileInfo> dataFileInfos, long commitVersion, long currentVersion) throws IOException {
        TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, insertTableHandle.location());
        transactionLogWriter.appendCommitInfoEntry(this.getCommitInfoEntry(session, isolationLevel, commitVersion, Instant.now().toEpochMilli(), INSERT_OPERATION, currentVersion, isBlindAppend));
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(insertTableHandle.metadataEntry(), insertTableHandle.protocolEntry());
        List<String> partitionColumns = DeltaLakeMetadata.getPartitionColumns(insertTableHandle.metadataEntry().getOriginalPartitionColumns(), insertTableHandle.inputColumns(), columnMappingMode);
        List<String> exactColumnNames = DeltaLakeSchemaSupport.getExactColumnNames(insertTableHandle.metadataEntry());
        DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, partitionColumns, exactColumnNames, true);
        transactionLogWriter.flush();
    }

    private static List<String> getPartitionColumns(List<String> originalPartitionColumns, List<DeltaLakeColumnHandle> dataColumns, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode) {
        return switch (columnMappingMode) {
            default -> throw new MatchException(null, null);
            case DeltaLakeSchemaSupport.ColumnMappingMode.ID, DeltaLakeSchemaSupport.ColumnMappingMode.NAME -> DeltaLakeMetadata.getPartitionColumnsForNameOrIdMapping(originalPartitionColumns, dataColumns);
            case DeltaLakeSchemaSupport.ColumnMappingMode.NONE -> originalPartitionColumns;
            case DeltaLakeSchemaSupport.ColumnMappingMode.UNKNOWN -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column mapping mode");
        };
    }

    private static List<String> getPartitionColumnsForNameOrIdMapping(List<String> originalPartitionColumns, List<DeltaLakeColumnHandle> dataColumns) {
        Map nameToDataColumns = (Map)dataColumns.stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::columnName, Function.identity()));
        return (List)originalPartitionColumns.stream().map(columnName -> {
            DeltaLakeColumnHandle dataColumn = (DeltaLakeColumnHandle)nameToDataColumns.get(columnName);
            if (dataColumn.basePhysicalColumnName().equalsIgnoreCase((String)columnName)) {
                return columnName;
            }
            return dataColumn.basePhysicalColumnName();
        }).collect(ImmutableList.toImmutableList());
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW;
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return DeltaLakeColumnHandle.mergeRowIdColumnHandle();
    }

    public Optional<ConnectorPartitioningHandle> getUpdateLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return Optional.of(DeltaLakeUpdateHandle.INSTANCE);
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, Map<Integer, Collection<ColumnHandle>> updateCaseColumns, RetryMode retryMode) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        if (DeltaLakeSchemaSupport.isAppendOnly(handle.getMetadataEntry(), handle.getProtocolEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot modify rows from a table with 'delta.appendOnly' set to true");
        }
        this.checkWriteAllowed(session, handle);
        this.checkWriteSupported(handle);
        List inputColumns = (List)this.getColumns(handle.getMetadataEntry(), handle.getProtocolEntry()).stream().filter(column -> column.columnType() != DeltaLakeColumnType.SYNTHESIZED).collect(ImmutableList.toImmutableList());
        DeltaLakeInsertTableHandle insertHandle = this.createInsertHandle(retryMode, handle, inputColumns);
        Map<String, DeletionVectorEntry> deletionVectors = this.loadDeletionVectors(session, handle);
        return new DeltaLakeMergeTableHandle(handle, insertHandle, deletionVectors);
    }

    private Map<String, DeletionVectorEntry> loadDeletionVectors(ConnectorSession session, DeltaLakeTableHandle handle) {
        if (!DeltaLakeSchemaSupport.isDeletionVectorEnabled(handle.getMetadataEntry(), handle.getProtocolEntry())) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder deletionVectors = ImmutableMap.builder();
        try (Stream<AddFileEntry> activeFiles = this.transactionLogAccess.getActiveFiles(session, this.getSnapshot(session, handle), handle.getMetadataEntry(), handle.getProtocolEntry(), handle.getEnforcedPartitionConstraint(), handle.getProjectedColumns().orElse((Set<DeltaLakeColumnHandle>)ImmutableSet.of()));){
            Iterator addFileEntryIterator = activeFiles.iterator();
            while (addFileEntryIterator.hasNext()) {
                AddFileEntry addFileEntry = (AddFileEntry)addFileEntryIterator.next();
                addFileEntry.getDeletionVector().ifPresent(deletionVector -> deletionVectors.put((Object)addFileEntry.getPath(), deletionVector));
            }
        }
        return deletionVectors.buildKeepingLast();
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle mergeTableHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeMergeTableHandle mergeHandle = (DeltaLakeMergeTableHandle)mergeTableHandle;
        DeltaLakeTableHandle handle = mergeHandle.tableHandle();
        List mergeResults = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.mergeResultJsonCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        List allFiles = (List)mergeResults.stream().map(DeltaLakeMergeResult::newFile).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
        if (mergeHandle.insertTableHandle().retriesEnabled()) {
            this.cleanExtraOutputFiles(session, Location.of((String)handle.getLocation()), allFiles);
        }
        Optional<Long> checkpointInterval = handle.getMetadataEntry().getCheckpointInterval();
        String tableLocation = handle.getLocation();
        boolean writeCommitted = false;
        try {
            DeltaLakeSchemaSupport.IsolationLevel isolationLevel = DeltaLakeSchemaSupport.getIsolationLevel(handle.getMetadataEntry());
            AtomicReference<Long> readVersion = new AtomicReference<Long>(handle.getReadVersion());
            long commitVersion = (Long)Failsafe.with(TRANSACTION_CONFLICT_RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(context -> this.commitMergeOperation(session, mergeHandle, mergeResults, sourceTableHandles, isolationLevel, allFiles, readVersion, context.getAttemptCount()));
            writeCommitted = true;
            this.enqueueUpdateInfo(session, handle.getSchemaName(), handle.getTableName(), commitVersion, handle.getMetadataEntry().getSchemaString(), Optional.ofNullable(handle.getMetadataEntry().getDescription()));
            this.writeCheckpointIfNeeded(session, handle.getSchemaTableName(), handle.getLocation(), handle.getReadVersion(), checkpointInterval, commitVersion);
        }
        catch (RuntimeException e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, tableLocation, allFiles);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private long commitMergeOperation(ConnectorSession session, DeltaLakeMergeTableHandle mergeHandle, List<DeltaLakeMergeResult> mergeResults, List<ConnectorTableHandle> sourceTableHandles, DeltaLakeSchemaSupport.IsolationLevel isolationLevel, List<DataFileInfo> allFiles, AtomicReference<Long> readVersion, int attemptCount) throws IOException {
        Map<Boolean, List<DataFileInfo>> split = allFiles.stream().collect(Collectors.partitioningBy(dataFile -> dataFile.dataFileType() == DataFileInfo.DataFileType.DATA));
        ImmutableList newFiles = ImmutableList.copyOf((Collection)split.get(true));
        ImmutableList cdcFiles = ImmutableList.copyOf((Collection)split.get(false));
        DeltaLakeTableHandle handle = mergeHandle.tableHandle();
        String tableLocation = handle.getLocation();
        TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
        long createdTime = Instant.now().toEpochMilli();
        List<DeltaLakeTableHandle> sameAsTargetSourceTableHandles = this.getSameAsTargetSourceTableHandles(sourceTableHandles, handle.getSchemaTableName());
        List enforcedSourcePartitionConstraints = (List)sameAsTargetSourceTableHandles.stream().map(DeltaLakeTableHandle::getEnforcedPartitionConstraint).collect(ImmutableList.toImmutableList());
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        long currentVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, tableLocation, readVersion.get());
        this.checkForConcurrentTransactionConflicts(session, fileSystem, enforcedSourcePartitionConstraints, isolationLevel, currentVersion, readVersion, handle.getLocation(), attemptCount);
        long commitVersion = currentVersion + 1L;
        transactionLogWriter.appendCommitInfoEntry(this.getCommitInfoEntry(session, isolationLevel, commitVersion, createdTime, MERGE_OPERATION, handle.getReadVersion(), sameAsTargetSourceTableHandles.isEmpty()));
        long writeTimestamp = Instant.now().toEpochMilli();
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(handle.getMetadataEntry(), handle.getProtocolEntry());
        List<String> partitionColumns = DeltaLakeMetadata.getPartitionColumns(handle.getMetadataEntry().getOriginalPartitionColumns(), mergeHandle.insertTableHandle().inputColumns(), columnMappingMode);
        if (!cdcFiles.isEmpty()) {
            DeltaLakeMetadata.appendCdcFilesInfos(transactionLogWriter, (List<DataFileInfo>)cdcFiles, partitionColumns);
        }
        for (DeltaLakeMergeResult mergeResult : mergeResults) {
            if (mergeResult.oldFile().isEmpty()) continue;
            transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(DeltaLakeMetadata.toUriFormat(mergeResult.oldFile().get()), DeltaLakeMetadata.createPartitionValuesMap(partitionColumns, mergeResult.partitionValues()), writeTimestamp, true, mergeResult.oldDeletionVector()));
        }
        DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, (List<DataFileInfo>)newFiles, partitionColumns, DeltaLakeSchemaSupport.getExactColumnNames(handle.getMetadataEntry()), true);
        transactionLogWriter.flush();
        return commitVersion;
    }

    private static Map<String, String> createPartitionValuesMap(List<String> partitionColumnNames, List<String> partitionValues) {
        Preconditions.checkArgument((partitionColumnNames.size() == partitionValues.size() ? 1 : 0) != 0, (Object)"partitionColumnNames and partitionValues sizes don't match");
        HashMap<String, String> partitionValuesMap = new HashMap<String, String>();
        for (int i = 0; i < partitionColumnNames.size(); ++i) {
            partitionValuesMap.put(partitionColumnNames.get(i), partitionValues.get(i));
        }
        return Collections.unmodifiableMap(partitionValuesMap);
    }

    private static Map<String, String> createPartitionValuesMap(Map<String, Optional<String>> canonicalPartitionValues) {
        HashMap<String, String> partitionValuesMap = new HashMap<String, String>();
        for (Map.Entry<String, Optional<String>> entry : canonicalPartitionValues.entrySet()) {
            partitionValuesMap.put(entry.getKey(), entry.getValue().orElse(null));
        }
        return Collections.unmodifiableMap(partitionValuesMap);
    }

    private static void appendCdcFilesInfos(TransactionLogWriter transactionLogWriter, List<DataFileInfo> cdcFilesInfos, List<String> partitionColumnNames) {
        for (DataFileInfo info : cdcFilesInfos) {
            HashMap<String, String> partitionValues = new HashMap<String, String>();
            for (int i = 0; i < partitionColumnNames.size(); ++i) {
                partitionValues.put(partitionColumnNames.get(i), info.partitionValues().get(i));
            }
            partitionValues = Collections.unmodifiableMap(partitionValues);
            transactionLogWriter.appendCdcEntry(new CdcEntry(DeltaLakeMetadata.toUriFormat(info.path()), partitionValues, info.size()));
        }
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorAccessControl accessControl, ConnectorTableHandle connectorTableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        DeltaLakeTableProcedureId procedureId;
        DeltaLakeTableHandle tableHandle = DeltaLakeMetadata.checkValidTableHandle(connectorTableHandle);
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(tableHandle.getProtocolEntry());
        try {
            procedureId = DeltaLakeTableProcedureId.valueOf(procedureName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
        }
        switch (procedureId) {
            default: {
                throw new MatchException(null, null);
            }
            case OPTIMIZE: 
        }
        return this.getTableHandleForOptimize(tableHandle, executeProperties, retryMode);
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(DeltaLakeTableHandle tableHandle, Map<String, Object> executeProperties, RetryMode retryMode) {
        this.checkWriteSupported(tableHandle);
        DataSize maxScannedFileSize = (DataSize)executeProperties.get("file_size_threshold");
        List columns = (List)this.getColumns(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry()).stream().filter(column -> column.columnType() != DeltaLakeColumnType.SYNTHESIZED).collect(ImmutableList.toImmutableList());
        return Optional.of(new DeltaLakeTableExecuteHandle(tableHandle.getSchemaTableName(), DeltaLakeTableProcedureId.OPTIMIZE, new DeltaTableOptimizeHandle(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), columns, tableHandle.getMetadataEntry().getOriginalPartitionColumns(), maxScannedFileSize, Optional.empty(), retryMode != RetryMode.NO_RETRIES, tableHandle.getEnforcedPartitionConstraint()), tableHandle.getLocation()));
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.procedureId()) {
            default: {
                throw new MatchException(null, null);
            }
            case OPTIMIZE: 
        }
        return this.getLayoutForOptimize(executeHandle);
    }

    private Optional<ConnectorTableLayout> getLayoutForOptimize(DeltaLakeTableExecuteHandle executeHandle) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.procedureHandle();
        List<String> partitionColumnNames = optimizeHandle.getMetadataEntry().getLowercasePartitionColumns();
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        Map columnsByName = (Map)optimizeHandle.getTableColumns().stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::columnName, Function.identity()));
        ImmutableList.Builder partitioningColumns = ImmutableList.builder();
        for (String columnName : partitionColumnNames) {
            partitioningColumns.add((Object)((DeltaLakeColumnHandle)columnsByName.get(columnName)));
        }
        DeltaLakePartitioningHandle partitioningHandle = new DeltaLakePartitioningHandle((List<DeltaLakeColumnHandle>)partitioningColumns.build());
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumnNames, true));
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)updatedSourceTableHandle;
        switch (executeHandle.procedureId()) {
            default: {
                throw new MatchException(null, null);
            }
            case OPTIMIZE: 
        }
        return this.beginOptimize(session, executeHandle, table);
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, DeltaLakeTableExecuteHandle executeHandle, DeltaLakeTableHandle table) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.procedureHandle();
        this.checkWriteAllowed(session, table);
        this.checkSupportedWriterVersion(table);
        return new BeginTableExecuteResult((Object)executeHandle.withProcedureHandle(optimizeHandle.withCurrentVersion(table.getReadVersion()).withEnforcedPartitionConstraint(table.getEnforcedPartitionConstraint())), (Object)table.forOptimize(true, optimizeHandle.getMaxScannedFileSize()));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.procedureId()) {
            case OPTIMIZE: {
                this.finishOptimize(session, executeHandle, fragments, splitSourceInfo);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + String.valueOf((Object)executeHandle.procedureId()) + "'");
    }

    private void finishOptimize(ConnectorSession session, DeltaLakeTableExecuteHandle executeHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.procedureHandle();
        String tableLocation = executeHandle.tableLocation();
        Set scannedDataFiles = (Set)splitSourceInfo.stream().map(DeltaLakeScannedDataFile.class::cast).collect(ImmutableSet.toImmutableSet());
        List dataFileInfos = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        if (optimizeHandle.isRetriesEnabled()) {
            this.cleanExtraOutputFiles(session, Location.of((String)executeHandle.tableLocation()), dataFileInfos);
        }
        boolean writeCommitted = false;
        try {
            DeltaLakeSchemaSupport.IsolationLevel isolationLevel = DeltaLakeSchemaSupport.getIsolationLevel(optimizeHandle.getMetadataEntry());
            AtomicReference<Long> readVersion = new AtomicReference<Long>(optimizeHandle.getCurrentVersion().orElseThrow(() -> new IllegalArgumentException("currentVersion not set")));
            long commitVersion = (Long)Failsafe.with(TRANSACTION_CONFLICT_RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(context -> this.commitOptimizeOperation(session, optimizeHandle, isolationLevel, tableLocation, scannedDataFiles, dataFileInfos, readVersion, context.getAttemptCount()));
            writeCommitted = true;
            this.enqueueUpdateInfo(session, executeHandle.schemaTableName().getSchemaName(), executeHandle.schemaTableName().getTableName(), commitVersion, optimizeHandle.getMetadataEntry().getSchemaString(), Optional.ofNullable(optimizeHandle.getMetadataEntry().getDescription()));
            Optional<Long> checkpointInterval = Optional.of(1L);
            this.writeCheckpointIfNeeded(session, executeHandle.schemaTableName(), executeHandle.tableLocation(), optimizeHandle.getCurrentVersion().orElseThrow(), checkpointInterval, commitVersion);
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, tableLocation, dataFileInfos);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private long commitOptimizeOperation(ConnectorSession session, DeltaTableOptimizeHandle optimizeHandle, DeltaLakeSchemaSupport.IsolationLevel isolationLevel, String tableLocation, Set<DeltaLakeScannedDataFile> scannedDataFiles, List<DataFileInfo> dataFileInfos, AtomicReference<Long> readVersion, int attemptCount) throws IOException {
        TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
        long createdTime = Instant.now().toEpochMilli();
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        long currentVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, tableLocation, readVersion.get());
        this.checkForConcurrentTransactionConflicts(session, fileSystem, (List<TupleDomain<DeltaLakeColumnHandle>>)ImmutableList.of(optimizeHandle.getEnforcedPartitionConstraint()), isolationLevel, currentVersion, readVersion, tableLocation, attemptCount);
        long commitVersion = currentVersion + 1L;
        transactionLogWriter.appendCommitInfoEntry(this.getCommitInfoEntry(session, isolationLevel, commitVersion, createdTime, OPTIMIZE_OPERATION, optimizeHandle.getCurrentVersion().orElseThrow(() -> new IllegalArgumentException("currentVersion not set")), false));
        long writeTimestamp = Instant.now().toEpochMilli();
        for (DeltaLakeScannedDataFile scannedFile : scannedDataFiles) {
            String relativePath = DeltaLakeMetadata.relativePath(tableLocation, scannedFile.path());
            Map<String, Optional<String>> canonicalPartitionValues = scannedFile.partitionKeys();
            transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(DeltaLakeMetadata.toUriFormat(relativePath), DeltaLakeMetadata.createPartitionValuesMap(canonicalPartitionValues), writeTimestamp, false, Optional.empty()));
        }
        List<String> partitionColumns = DeltaLakeMetadata.getPartitionColumns(optimizeHandle.getMetadataEntry().getOriginalPartitionColumns(), optimizeHandle.getTableColumns(), DeltaLakeSchemaSupport.getColumnMappingMode(optimizeHandle.getMetadataEntry(), optimizeHandle.getProtocolEntry()));
        DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, partitionColumns, DeltaLakeSchemaSupport.getExactColumnNames(optimizeHandle.getMetadataEntry()), false);
        transactionLogWriter.flush();
        return commitVersion;
    }

    private void checkWriteAllowed(ConnectorSession session, DeltaLakeTableHandle table) {
        if (!this.allowWrite(session, table)) {
            String fileSystem = Location.of((String)table.getLocation()).scheme().orElse("unknown");
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Writes are not enabled on the %1$s filesystem in order to avoid eventual data corruption which may be caused by concurrent data modifications on the table. Writes to the %1$s filesystem can be however enabled with the '%2$s' configuration property.", fileSystem, ENABLE_NON_CONCURRENT_WRITES_CONFIGURATION_KEY));
        }
    }

    private boolean allowWrite(ConnectorSession session, DeltaLakeTableHandle tableHandle) {
        try {
            String tableMetadataDirectory = TransactionLogUtil.getTransactionLogDir(tableHandle.getLocation());
            boolean requiresOptIn = this.transactionLogWriterFactory.newWriter(session, tableMetadataDirectory).isUnsafe();
            return !requiresOptIn || this.unsafeWritesEnabled;
        }
        catch (TrinoException e) {
            if (e.getErrorCode() == StandardErrorCode.NOT_SUPPORTED.toErrorCode()) {
                return false;
            }
            throw e;
        }
    }

    private void checkWriteSupported(DeltaLakeTableHandle handle) {
        this.checkSupportedWriterVersion(handle);
        this.checkUnsupportedGeneratedColumns(handle.getMetadataEntry());
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(handle.getMetadataEntry(), handle.getProtocolEntry());
        if (columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NONE && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.NAME && columnMappingMode != DeltaLakeSchemaSupport.ColumnMappingMode.ID) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing with column mapping %s is not supported".formatted(new Object[]{columnMappingMode}));
        }
        if (DeltaLakeSchemaSupport.getColumnIdentities(handle.getMetadataEntry(), handle.getProtocolEntry()).values().stream().anyMatch(identity -> identity)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with identity columns is not supported");
        }
        DeltaLakeMetadata.checkUnsupportedUniversalFormat(handle.getMetadataEntry());
        DeltaLakeMetadata.checkUnsupportedWriterFeatures(handle.getProtocolEntry());
    }

    public static void checkUnsupportedUniversalFormat(MetadataEntry metadataEntry) {
        List<String> universalFormats = DeltaLakeSchemaSupport.enabledUniversalFormats(metadataEntry);
        if (!universalFormats.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported universal formats: " + String.valueOf(universalFormats));
        }
    }

    private static void checkUnsupportedWriterFeatures(ProtocolEntry protocolEntry) {
        Set<String> unsupportedWriterFeatures = DeltaLakeTableFeatures.unsupportedWriterFeatures(protocolEntry.writerFeatures().orElse((Set<String>)ImmutableSet.of()));
        if (!unsupportedWriterFeatures.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported writer features: " + String.valueOf(unsupportedWriterFeatures));
        }
    }

    private void checkUnsupportedGeneratedColumns(MetadataEntry metadataEntry) {
        Map<String, String> columnGeneratedExpressions = DeltaLakeSchemaSupport.getGeneratedColumnExpressions(metadataEntry);
        if (!columnGeneratedExpressions.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with generated columns is not supported");
        }
    }

    private void checkSupportedWriterVersion(DeltaLakeTableHandle handle) {
        int requiredWriterVersion = handle.getProtocolEntry().minWriterVersion();
        if (requiredWriterVersion > 7) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table %s requires Delta Lake writer version %d which is not supported", handle.getSchemaTableName(), requiredWriterVersion));
        }
    }

    private TableSnapshot getSnapshot(ConnectorSession session, DeltaLakeTableHandle table) {
        return this.getSnapshot(session, table.getSchemaTableName(), table.getLocation(), Optional.of(table.getReadVersion()));
    }

    private ProtocolEntry protocolEntryForTable(int readerVersion, int writerVersion, boolean containsTimestampType, Map<String, Object> properties) {
        return this.protocolEntry(ProtocolEntry.builder(readerVersion, writerVersion), containsTimestampType, DeltaLakeTableProperties.getChangeDataFeedEnabled(properties), DeltaLakeTableProperties.getColumnMappingMode(properties), DeltaLakeTableProperties.getDeletionVectorsEnabled(properties));
    }

    private ProtocolEntry protocolEntry(ProtocolEntry.Builder protocolEntry, boolean containsTimestampType, Optional<Boolean> changeDataFeedEnabled, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, boolean deletionVectorsEnabled) {
        if (changeDataFeedEnabled.isPresent() && changeDataFeedEnabled.get().booleanValue()) {
            protocolEntry.enableChangeDataFeed();
        }
        if (columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.ID || columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.NAME) {
            protocolEntry.enableColumnMapping();
        }
        if (containsTimestampType) {
            protocolEntry.enableTimestampNtz();
        }
        if (deletionVectorsEnabled) {
            protocolEntry.enableDeletionVector();
        }
        return protocolEntry.build();
    }

    private void writeCheckpointIfNeeded(ConnectorSession session, SchemaTableName table, String tableLocation, long readVersion, Optional<Long> checkpointInterval, long newVersion) {
        try {
            TableSnapshot snapshot = this.getSnapshot(session, table, tableLocation, Optional.of(readVersion));
            long lastCheckpointVersion = snapshot.getLastCheckpointVersion().orElse(0L);
            if (newVersion - lastCheckpointVersion < checkpointInterval.orElse(this.defaultCheckpointInterval)) {
                return;
            }
            if (snapshot.getVersion() > newVersion) {
                LOG.info("Snapshot for table %s already at version %s when checkpoint requested for version %s", new Object[]{table, snapshot.getVersion(), newVersion});
            }
            TableSnapshot updatedSnapshot = snapshot.getUpdatedSnapshot(this.fileSystemFactory.create(session), Optional.of(newVersion)).orElseThrow();
            this.checkpointWriterManager.writeCheckpoint(session, updatedSnapshot);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to write checkpoint for table %s for version %s", new Object[]{table, newVersion});
        }
    }

    private void cleanupFailedWrite(ConnectorSession session, String tableLocation, List<DataFileInfo> dataFiles) {
        Location location = Location.of((String)tableLocation);
        List filesToDelete = (List)dataFiles.stream().map(DataFileInfo::path).map(arg_0 -> ((Location)location).appendPath(arg_0)).collect(ImmutableList.toImmutableList());
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            fileSystem.deleteFiles((Collection)filesToDelete);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Failed cleanup of leftover files from failed write, files are: %s", new Object[]{filesToDelete});
        }
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)table;
        boolean isPartitioned = !handle.getMetadataEntry().getLowercasePartitionColumns().isEmpty();
        return Optional.of(new DeltaLakeInputInfo(isPartitioned, handle.getReadVersion()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        LocatedTableHandle handle = (LocatedTableHandle)tableHandle;
        boolean deleteData = handle.managed();
        this.metastore.dropTable(handle.schemaTableName(), handle.location(), deleteData);
        if (deleteData) {
            try {
                this.fileSystemFactory.create(session).deleteDirectory(Location.of((String)handle.location()));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, String.format("Failed to delete directory %s of the table %s", handle.location(), handle.schemaTableName()), (Throwable)e);
            }
        }
        this.statisticsAccess.invalidateCache(handle.schemaTableName(), Optional.of(handle.location()));
        this.transactionLogAccess.invalidateCache(handle.schemaTableName(), Optional.of(handle.location()));
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        DeltaLakeTableHandle handle = DeltaLakeMetadata.checkValidTableHandle(tableHandle);
        DeltaMetastoreTable table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (table.managed() && !this.allowManagedTableRename) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming managed tables is not allowed with current metastore configuration");
        }
        this.metastore.renameTable(handle.getSchemaTableName(), newTableName);
    }

    private CommitInfoEntry getCommitInfoEntry(ConnectorSession session, DeltaLakeSchemaSupport.IsolationLevel isolationLevel, long commitVersion, long createdTime, String operation, long readVersion, boolean isBlindAppend) {
        return new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), operation, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, readVersion, isolationLevel.getValue(), Optional.of(isBlindAppend), (Map<String, String>)ImmutableMap.of());
    }

    public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Optional<Object>> properties) {
        DeltaLakeTableHandle handle = DeltaLakeMetadata.checkValidTableHandle(tableHandle);
        Sets.SetView unsupportedProperties = Sets.difference(properties.keySet(), UPDATABLE_TABLE_PROPERTIES);
        if (!unsupportedProperties.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The following properties cannot be updated: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)unsupportedProperties));
        }
        ProtocolEntry currentProtocolEntry = handle.getProtocolEntry();
        long createdTime = Instant.now().toEpochMilli();
        int requiredWriterVersion = currentProtocolEntry.minWriterVersion();
        Optional<Object> metadataEntry = Optional.empty();
        if (properties.containsKey("change_data_feed_enabled")) {
            boolean changeDataFeedEnabled = (Boolean)properties.get("change_data_feed_enabled").orElseThrow(() -> new IllegalArgumentException("The change_data_feed_enabled property cannot be empty"));
            if (changeDataFeedEnabled) {
                Set columnNames = (Set)this.getColumns(handle.getMetadataEntry(), handle.getProtocolEntry()).stream().map(DeltaLakeColumnHandle::baseColumnName).collect(ImmutableSet.toImmutableSet());
                Sets.SetView conflicts = Sets.intersection((Set)columnNames, CHANGE_DATA_FEED_COLUMN_NAMES);
                if (!conflicts.isEmpty()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unable to enable change data feed because table contains %s columns".formatted(conflicts));
                }
                requiredWriterVersion = Ints.max((int[])new int[]{requiredWriterVersion, 4});
            }
            HashMap<String, String> configuration = new HashMap<String, String>(handle.getMetadataEntry().getConfiguration());
            configuration.put("delta.enableChangeDataFeed", String.valueOf(changeDataFeedEnabled));
            metadataEntry = Optional.of(this.buildMetadataEntry(handle.getMetadataEntry(), configuration, createdTime));
        }
        long readVersion = handle.getReadVersion();
        long commitVersion = readVersion + 1L;
        Optional<Object> protocolEntry = Optional.empty();
        if (requiredWriterVersion != currentProtocolEntry.minWriterVersion()) {
            protocolEntry = Optional.of(new ProtocolEntry(currentProtocolEntry.minReaderVersion(), requiredWriterVersion, currentProtocolEntry.readerFeatures(), currentProtocolEntry.writerFeatures()));
        }
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.getLocation());
            transactionLogWriter.appendCommitInfoEntry(this.getCommitInfoEntry(session, DeltaLakeSchemaSupport.IsolationLevel.WRITESERIALIZABLE, commitVersion, createdTime, SET_TBLPROPERTIES_OPERATION, readVersion, true));
            protocolEntry.ifPresent(transactionLogWriter::appendProtocolEntry);
            metadataEntry.ifPresent(transactionLogWriter::appendMetadataEntry);
            transactionLogWriter.flush();
            this.enqueueUpdateInfo(session, handle.getSchemaName(), handle.getTableName(), commitVersion, ((MetadataEntry)metadataEntry.orElseThrow()).getSchemaString(), Optional.ofNullable(((MetadataEntry)metadataEntry.orElseThrow()).getDescription()));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private MetadataEntry buildMetadataEntry(MetadataEntry metadataEntry, Map<String, String> configuration, long createdTime) {
        return new MetadataEntry(metadataEntry.getId(), metadataEntry.getName(), metadataEntry.getDescription(), metadataEntry.getFormat(), metadataEntry.getSchemaString(), metadataEntry.getOriginalPartitionColumns(), configuration, createdTime);
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, String schemaName) {
        if (HiveUtil.isHiveSystemSchema((String)schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Schema properties are not supported for system schema: " + schemaName);
        }
        return this.metastore.getDatabase(schemaName).map(DeltaLakeSchemaProperties::fromDatabase).orElseThrow(() -> new SchemaNotFoundException(schemaName));
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, Map<String, Object> viewProperties, boolean replace) {
        Preconditions.checkArgument((boolean)viewProperties.isEmpty(), (Object)"This connector does not support creating views with properties");
        this.trinoViewHiveMetastore.createView(session, viewName, definition, replace);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        this.trinoViewHiveMetastore.dropView(viewName);
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return this.trinoViewHiveMetastore.listViews(schemaName);
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        return this.trinoViewHiveMetastore.getViews(schemaName);
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.trinoViewHiveMetastore.getView(viewName);
    }

    public void createRole(ConnectorSession session, String role, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.createRole(session, role, grantor.map(HivePrincipal::from));
    }

    public void dropRole(ConnectorSession session, String role) {
        this.accessControlMetadata.dropRole(session, role);
    }

    public Set<String> listRoles(ConnectorSession session) {
        return this.accessControlMetadata.listRoles(session);
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, TrinoPrincipal principal) {
        return ImmutableSet.copyOf((Collection)this.accessControlMetadata.listRoleGrants(session, HivePrincipal.from((TrinoPrincipal)principal)));
    }

    public void grantRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean withAdminOption, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.grantRoles(session, roles, HivePrincipal.from(grantees), withAdminOption, grantor.map(HivePrincipal::from));
    }

    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOptionFor, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.revokeRoles(session, roles, HivePrincipal.from(grantees), adminOptionFor, grantor.map(HivePrincipal::from));
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, TrinoPrincipal principal) {
        return this.accessControlMetadata.listApplicableRoles(session, HivePrincipal.from((TrinoPrincipal)principal));
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        return this.accessControlMetadata.listEnabledRoles(session);
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from((TrinoPrincipal)grantee), grantOption);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from((TrinoPrincipal)grantee), grantOption);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        return this.accessControlMetadata.listTablePrivileges(session, this.listTables(session, schemaTablePrefix));
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        SchemaTableName tableName = prefix.toSchemaTableName();
        return (List)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).map(table -> ImmutableList.of((Object)tableName)).orElse(ImmutableList.of());
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private static String toUriFormat(String path) {
        Verify.verify((!path.startsWith("/") && !path.contains(":/") ? 1 : 0) != 0, (String)"unexpected path: %s", (Object)path);
        try {
            return new URI(null, null, path, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid path: " + path, e);
        }
    }

    static String relativePath(String basePath, String path) {
        Object basePathDirectory = basePath.endsWith("/") ? basePath : basePath + "/";
        Preconditions.checkArgument((path.startsWith((String)basePathDirectory) && path.length() > ((String)basePathDirectory).length() ? 1 : 0) != 0, (String)"path [%s] must be a subdirectory of basePath [%s]", (Object)path, (Object)basePath);
        return path.substring(((String)basePathDirectory).length());
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        Set newConstraintColumns;
        TupleDomain newUnenforcedConstraint;
        TupleDomain newEnforcedConstraint;
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)handle;
        SchemaTableName tableName = tableHandle.getSchemaTableName();
        Preconditions.checkArgument((boolean)constraint.getSummary().getDomains().isPresent(), (Object)"constraint summary is NONE");
        UtcConstraintExtractor.ExtractionResult extractionResult = UtcConstraintExtractor.extractTupleDomain((Constraint)constraint);
        TupleDomain predicate = extractionResult.tupleDomain();
        if (predicate.isAll() && constraint.getPredicateColumns().isEmpty()) {
            return Optional.empty();
        }
        if (predicate.isNone()) {
            newEnforcedConstraint = TupleDomain.none();
            newUnenforcedConstraint = TupleDomain.all();
            newConstraintColumns = (Set)constraint.getPredicateColumns().stream().flatMap(Collection::stream).map(DeltaLakeColumnHandle.class::cast).collect(ImmutableSet.toImmutableSet());
        } else {
            ImmutableSet partitionColumns = ImmutableSet.copyOf(DeltaLakeSchemaSupport.extractPartitionColumns(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), this.typeManager));
            Map constraintDomains = (Map)predicate.getDomains().orElseThrow();
            ImmutableMap.Builder enforceableDomains = ImmutableMap.builder();
            ImmutableMap.Builder unenforceableDomains = ImmutableMap.builder();
            ImmutableSet.Builder constraintColumns = ImmutableSet.builder();
            constraint.getPredicateColumns().stream().flatMap(Collection::stream).map(DeltaLakeColumnHandle.class::cast).forEach(arg_0 -> ((ImmutableSet.Builder)constraintColumns).add(arg_0));
            for (Map.Entry domainEntry : constraintDomains.entrySet()) {
                DeltaLakeColumnHandle column = (DeltaLakeColumnHandle)domainEntry.getKey();
                if (!partitionColumns.contains(column)) {
                    unenforceableDomains.put((Object)column, (Object)((Domain)domainEntry.getValue()));
                } else {
                    enforceableDomains.put((Object)column, (Object)((Domain)domainEntry.getValue()));
                }
                constraintColumns.add((Object)column);
            }
            newEnforcedConstraint = TupleDomain.withColumnDomains((Map)enforceableDomains.buildOrThrow());
            newUnenforcedConstraint = TupleDomain.withColumnDomains((Map)unenforceableDomains.buildOrThrow());
            newConstraintColumns = constraintColumns.build();
        }
        DeltaLakeTableHandle newHandle = new DeltaLakeTableHandle(tableName.getSchemaName(), tableName.getTableName(), tableHandle.isManaged(), tableHandle.getLocation(), tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), (TupleDomain<DeltaLakeColumnHandle>)tableHandle.getEnforcedPartitionConstraint().intersect(newEnforcedConstraint), (TupleDomain<DeltaLakeColumnHandle>)tableHandle.getNonPartitionConstraint().intersect(newUnenforcedConstraint).simplify(this.domainCompactionThreshold), (Set<DeltaLakeColumnHandle>)Sets.union(tableHandle.getConstraintColumns(), (Set)newConstraintColumns), tableHandle.getWriteType(), tableHandle.getProjectedColumns(), tableHandle.getUpdatedColumns(), tableHandle.getUpdateRowIdColumns(), Optional.empty(), false, false, Optional.empty(), tableHandle.getReadVersion(), tableHandle.isTimeTravel());
        if (tableHandle.getEnforcedPartitionConstraint().equals(newHandle.getEnforcedPartitionConstraint()) && tableHandle.getNonPartitionConstraint().equals(newHandle.getNonPartitionConstraint()) && tableHandle.getConstraintColumns().equals(newHandle.getConstraintColumns())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHandle, newUnenforcedConstraint.transformKeys(ColumnHandle.class::cast), extractionResult.remainingExpression(), false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        Map columnProjections;
        DeltaLakeTableHandle deltaLakeTableHandle;
        block8: {
            block7: {
                deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
                Set projectedExpressions = (Set)projections.stream().flatMap(expression -> ApplyProjectionUtil.extractSupportedProjectedColumns((ConnectorExpression)expression).stream()).collect(ImmutableSet.toImmutableSet());
                columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), ApplyProjectionUtil::createProjectedColumnRepresentation));
                if (!DeltaLakeSessionProperties.isProjectionPushdownEnabled(session)) break block7;
                if (!columnProjections.values().stream().allMatch(ApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) break block8;
            }
            Set projectedColumns = (Set)assignments.values().stream().map(DeltaLakeColumnHandle.class::cast).collect(ImmutableSet.toImmutableSet());
            if (deltaLakeTableHandle.getProjectedColumns().isPresent() && deltaLakeTableHandle.getProjectedColumns().get().equals(projectedColumns)) {
                return Optional.empty();
            }
            List newColumnAssignments = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((DeltaLakeColumnHandle)assignment.getValue()).baseType())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)deltaLakeTableHandle.withProjectedColumns(projectedColumns), projections, newColumnAssignments, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            DeltaLakeColumnHandle projectedColumnHandle;
            String projectedColumnName;
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            ApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (ApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            Optional<String> existingColumn = DeltaLakeMetadata.find(assignments, projectedColumn);
            if (existingColumn.isPresent()) {
                projectedColumnName = existingColumn.get();
                projectedColumnHandle = (DeltaLakeColumnHandle)assignments.get(projectedColumnName);
            } else {
                DeltaLakeColumnHandle oldColumnHandle = (DeltaLakeColumnHandle)assignments.get(projectedColumn.getVariable().getName());
                projectedColumnHandle = DeltaLakeMetadata.projectColumn(oldColumnHandle, projectedColumn.getDereferenceIndices(), expression2.getType(), DeltaLakeSchemaSupport.getColumnMappingMode(deltaLakeTableHandle.getMetadataEntry(), deltaLakeTableHandle.getProtocolEntry()));
                projectedColumnName = projectedColumnHandle.qualifiedPhysicalName();
            }
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, (ColumnHandle)projectedColumnHandle, expression2.getType());
            newAssignments.putIfAbsent(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.buildOrThrow();
        List newProjections = (List)projections.stream().map(arg_0 -> DeltaLakeMetadata.lambda$applyProjection$76((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        ImmutableList outputAssignments = ImmutableList.copyOf(newAssignments.values());
        return Optional.of(new ProjectionApplicationResult((Object)deltaLakeTableHandle.withProjectedColumns((Set<DeltaLakeColumnHandle>)projectedColumnsBuilder.build()), newProjections, (List)outputAssignments, false));
    }

    private static DeltaLakeColumnHandle projectColumn(DeltaLakeColumnHandle column, List<Integer> indices, Type projectedColumnType, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode) {
        RowType.Field field;
        int index;
        if (indices.isEmpty()) {
            return column;
        }
        Optional<DeltaLakeColumnProjectionInfo> existingProjectionInfo = column.projectionInfo();
        ImmutableList.Builder dereferenceNames = ImmutableList.builder();
        ImmutableList.Builder dereferenceIndices = ImmutableList.builder();
        if (!column.isBaseColumn()) {
            dereferenceNames.addAll(existingProjectionInfo.orElseThrow().getDereferencePhysicalNames());
            dereferenceIndices.addAll(existingProjectionInfo.orElseThrow().getDereferenceIndices());
        }
        Type columnType = switch (columnMappingMode) {
            case DeltaLakeSchemaSupport.ColumnMappingMode.ID, DeltaLakeSchemaSupport.ColumnMappingMode.NAME -> column.basePhysicalType();
            case DeltaLakeSchemaSupport.ColumnMappingMode.NONE -> column.baseType();
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Projecting columns with column mapping %s is not supported".formatted(new Object[]{columnMappingMode}));
        };
        Object object = dereferenceIndices.build().iterator();
        while (object.hasNext()) {
            index = (Integer)object.next();
            field = (RowType.Field)((RowType)columnType).getFields().get(index);
            columnType = field.getType();
        }
        object = indices.iterator();
        while (object.hasNext()) {
            index = (Integer)object.next();
            field = (RowType.Field)((RowType)columnType).getFields().get(index);
            dereferenceNames.add((Object)((String)field.getName().orElseThrow()));
            columnType = field.getType();
        }
        dereferenceIndices.addAll(indices);
        DeltaLakeColumnProjectionInfo projectionInfo = new DeltaLakeColumnProjectionInfo(projectedColumnType, (List<Integer>)dereferenceIndices.build(), (List<String>)dereferenceNames.build());
        return new DeltaLakeColumnHandle(column.baseColumnName(), column.baseType(), column.baseFieldId(), column.basePhysicalColumnName(), column.basePhysicalType(), DeltaLakeColumnType.REGULAR, Optional.of(projectionInfo));
    }

    private static Optional<String> find(Map<String, ColumnHandle> assignments, ApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn) {
        DeltaLakeColumnHandle variableColumn = (DeltaLakeColumnHandle)assignments.get(projectedColumn.getVariable().getName());
        Objects.requireNonNull(variableColumn, "variableColumn is null");
        String baseColumnName = variableColumn.baseColumnName();
        List variableColumnIndices = variableColumn.projectionInfo().map(DeltaLakeColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of());
        ImmutableList projectionIndices = ImmutableList.builder().addAll((Iterable)variableColumnIndices).addAll((Iterable)projectedColumn.getDereferenceIndices()).build();
        for (Map.Entry<String, ColumnHandle> entry : assignments.entrySet()) {
            DeltaLakeColumnHandle column = (DeltaLakeColumnHandle)entry.getValue();
            if (!column.baseColumnName().equals(baseColumnName) || !column.projectionInfo().map(DeltaLakeColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of()).equals(projectionIndices)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    public void validateScan(ConnectorSession session, ConnectorTableHandle handle) {
        List<String> partitionColumns;
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)handle;
        if (DeltaLakeSessionProperties.isQueryPartitionFilterRequired(session) && !(partitionColumns = deltaLakeTableHandle.getMetadataEntry().getOriginalPartitionColumns()).isEmpty()) {
            if (deltaLakeTableHandle.getAnalyzeHandle().isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "ANALYZE statement can not be performed on partitioned tables because filtering is required on at least one partition. However, the partition filtering check can be disabled with the catalog session property 'query_partition_filter_required'.");
            }
            Set referencedColumns = (Set)deltaLakeTableHandle.getConstraintColumns().stream().map(DeltaLakeColumnHandle::baseColumnName).collect(ImmutableSet.toImmutableSet());
            if (Collections.disjoint(referencedColumns, partitionColumns)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Filter required on %s for at least one partition column: %s", deltaLakeTableHandle.getSchemaTableName(), String.join((CharSequence)", ", partitionColumns)));
            }
        }
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        Optional oldAnalyzeColumnNames;
        if (!DeltaLakeSessionProperties.isExtendedStatisticsEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("ANALYZE not supported if extended statistics are disabled. Enable via %s config property or %s session property.", "delta.extended-statistics.enabled", "extended_statistics_enabled"));
        }
        DeltaLakeTableHandle handle = DeltaLakeMetadata.checkValidTableHandle(tableHandle);
        MetadataEntry metadata = handle.getMetadataEntry();
        Optional<Instant> filesModifiedAfterFromProperties = DeltaLakeAnalyzeProperties.getFilesModifiedAfterProperty(analyzeProperties);
        DeltaLakeAnalyzeProperties.AnalyzeMode analyzeMode = DeltaLakeAnalyzeProperties.getRefreshMode(analyzeProperties);
        Optional<Object> statistics = Optional.empty();
        if (analyzeMode == DeltaLakeAnalyzeProperties.AnalyzeMode.INCREMENTAL) {
            statistics = this.statisticsAccess.readExtendedStatistics(session, handle.getSchemaTableName(), handle.getLocation());
        }
        Optional<Instant> alreadyAnalyzedModifiedTimeMax = statistics.map(ExtendedStatistics::getAlreadyAnalyzedModifiedTimeMax);
        Optional<Instant> filesModifiedAfter = Optional.empty();
        if (filesModifiedAfterFromProperties.isPresent() || alreadyAnalyzedModifiedTimeMax.isPresent()) {
            filesModifiedAfter = Optional.of((Instant)Comparators.max((Comparable)filesModifiedAfterFromProperties.orElse(Instant.EPOCH), (Comparable)alreadyAnalyzedModifiedTimeMax.orElse(Instant.EPOCH)));
        }
        List<DeltaLakeColumnMetadata> columnsMetadata = DeltaLakeSchemaSupport.extractSchema(metadata, handle.getProtocolEntry(), this.typeManager);
        Set allColumnNames = columnsMetadata.stream().map(columnMetadata -> columnMetadata.name().toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        Optional<Set<String>> analyzeColumnNames = DeltaLakeAnalyzeProperties.getColumnNames(analyzeProperties);
        if (analyzeColumnNames.isPresent()) {
            Set<String> columnNames = analyzeColumnNames.get();
            if (columnNames.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Cannot specify empty list of columns for analysis");
            }
            if (!allColumnNames.containsAll(columnNames)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid columns specified for analysis: %s", Sets.difference(columnNames, allColumnNames)));
            }
        }
        if ((oldAnalyzeColumnNames = statistics.flatMap(ExtendedStatistics::getAnalyzedColumns)).isPresent() && (analyzeColumnNames.isEmpty() || !((Set)oldAnalyzeColumnNames.get()).containsAll((Collection)analyzeColumnNames.get()))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("List of columns to be analyzed must be a subset of previously used: %s. To extend list of analyzed columns drop table statistics", oldAnalyzeColumnNames.get()));
        }
        AnalyzeHandle analyzeHandle = new AnalyzeHandle(statistics.isEmpty() ? DeltaLakeAnalyzeProperties.AnalyzeMode.FULL_REFRESH : DeltaLakeAnalyzeProperties.AnalyzeMode.INCREMENTAL, filesModifiedAfter, analyzeColumnNames);
        DeltaLakeTableHandle newHandle = new DeltaLakeTableHandle(handle.getSchemaTableName().getSchemaName(), handle.getSchemaTableName().getTableName(), handle.isManaged(), handle.getLocation(), metadata, handle.getProtocolEntry(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(analyzeHandle), handle.getReadVersion(), handle.isTimeTravel());
        TableStatisticsMetadata statisticsMetadata = this.getStatisticsCollectionMetadata((List)columnsMetadata.stream().map(DeltaLakeColumnMetadata::columnMetadata).collect(ImmutableList.toImmutableList()), analyzeColumnNames.orElse(allColumnNames), statistics.isPresent(), false);
        return new ConnectorAnalyzeMetadata((ConnectorTableHandle)newHandle, statisticsMetadata);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        if (!DeltaLakeSessionProperties.isCollectExtendedStatisticsColumnStatisticsOnWrite(session)) {
            return TableStatisticsMetadata.empty();
        }
        Set allColumnNames = (Set)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        Optional<Set<Object>> analyzeColumnNames = Optional.empty();
        String tableLocation = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        Optional<Object> existingStatistics = Optional.empty();
        if (tableLocation != null) {
            existingStatistics = this.statisticsAccess.readExtendedStatistics(session, tableMetadata.getTable(), tableLocation);
            analyzeColumnNames = existingStatistics.flatMap(ExtendedStatistics::getAnalyzedColumns);
        }
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), analyzeColumnNames.orElse(allColumnNames), existingStatistics.isPresent(), true);
    }

    private TableStatisticsMetadata getStatisticsCollectionMetadata(List<ColumnMetadata> tableColumns, Set<String> analyzeColumnNames, boolean extendedStatisticsExists, boolean isCollectionOnWrite) {
        boolean collectFileStatistics = !extendedStatisticsExists && !isCollectionOnWrite;
        ImmutableSet.Builder columnStatistics = ImmutableSet.builder();
        tableColumns.stream().filter(DeltaLakeMetadata::shouldCollectExtendedStatistics).filter(columnMetadata -> analyzeColumnNames.contains(columnMetadata.getName())).forEach(columnMetadata -> {
            if (!(columnMetadata.getType() instanceof FixedWidthType)) {
                columnStatistics.add((Object)new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.TOTAL_SIZE_IN_BYTES));
            }
            columnStatistics.add((Object)new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY));
            if (collectFileStatistics) {
                if (!(columnMetadata.getType().equals((Object)VarcharType.VARCHAR) || columnMetadata.getType().equals((Object)BooleanType.BOOLEAN) || columnMetadata.getType().equals((Object)VarbinaryType.VARBINARY))) {
                    columnStatistics.add((Object)new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.MIN_VALUE));
                    columnStatistics.add((Object)new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.MAX_VALUE));
                }
                columnStatistics.add((Object)new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES));
            }
        });
        if (!isCollectionOnWrite) {
            columnStatistics.add((Object)new ColumnStatisticMetadata("$file_modified_time", ColumnStatisticType.MAX_VALUE));
        }
        ImmutableSet tableStatistics = ImmutableSet.of();
        ImmutableList groupingColumns = ImmutableList.of();
        if (collectFileStatistics) {
            tableStatistics = ImmutableSet.of((Object)TableStatisticType.ROW_COUNT);
            groupingColumns = ImmutableList.of((Object)"$path");
        }
        return new TableStatisticsMetadata((Set)columnStatistics.build(), (Set)tableStatistics, (List)groupingColumns);
    }

    private static boolean shouldCollectExtendedStatistics(ColumnMetadata columnMetadata) {
        if (columnMetadata.isHidden()) {
            return false;
        }
        Type type = columnMetadata.getType();
        return !(type instanceof MapType) && !(type instanceof RowType) && !(type instanceof ArrayType);
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle table, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)table;
        AnalyzeHandle analyzeHandle = tableHandle.getAnalyzeHandle().orElseThrow(() -> new IllegalArgumentException("analyzeHandle not set"));
        if (analyzeHandle.analyzeMode() == DeltaLakeAnalyzeProperties.AnalyzeMode.FULL_REFRESH) {
            this.generateMissingFileStatistics(session, tableHandle, computedStatistics);
        }
        Optional<Instant> maxFileModificationTime = DeltaLakeMetadata.getMaxFileModificationTime(computedStatistics);
        Map physicalColumnNameMapping = (Map)DeltaLakeSchemaSupport.extractSchema(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnMetadata::name, DeltaLakeColumnMetadata::physicalName));
        this.updateTableStatistics(session, Optional.of(analyzeHandle), tableHandle.getSchemaTableName(), tableHandle.getLocation(), maxFileModificationTime, computedStatistics, DeltaLakeSchemaSupport.getExactColumnNames(tableHandle.getMetadataEntry()), Optional.of(physicalColumnNameMapping), false);
    }

    private void generateMissingFileStatistics(ConnectorSession session, DeltaLakeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        Map addFileEntriesWithNoStats;
        try (Stream<AddFileEntry> activeFiles = this.transactionLogAccess.getActiveFiles(session, this.getSnapshot(session, tableHandle), tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (Predicate<String>)Predicates.alwaysTrue());){
            addFileEntriesWithNoStats = (Map)activeFiles.filter(addFileEntry -> addFileEntry.getStats().isEmpty() || addFileEntry.getStats().get().getNumRecords().isEmpty() || addFileEntry.getStats().get().getMaxValues().isEmpty() || addFileEntry.getStats().get().getMinValues().isEmpty() || addFileEntry.getStats().get().getNullCount().isEmpty()).filter(addFileEntry -> !URI.create(addFileEntry.getPath()).isAbsolute()).collect(ImmutableMap.toImmutableMap(addFileEntry -> DeltaLakeSplitManager.buildSplitPath(Location.of((String)tableHandle.getLocation()), addFileEntry).toString(), Function.identity()));
        }
        if (addFileEntriesWithNoStats.isEmpty()) {
            return;
        }
        Map lowercaseToColumnsHandles = (Map)this.getColumns(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry()).stream().filter(column -> column.columnType() == DeltaLakeColumnType.REGULAR).collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.baseColumnName().toLowerCase(Locale.ENGLISH), Function.identity()));
        List updatedAddFileEntries = (List)computedStatistics.stream().map(statistics -> {
            String filePathFromStatistics = VarcharType.VARCHAR.getSlice((Block)Iterables.getOnlyElement((Iterable)statistics.getGroupingValues()), 0).toStringUtf8();
            AddFileEntry addFileEntry = (AddFileEntry)addFileEntriesWithNoStats.get(filePathFromStatistics);
            if (addFileEntry != null) {
                return Optional.of(this.prepareUpdatedAddFileEntry((ComputedStatistics)statistics, addFileEntry, lowercaseToColumnsHandles));
            }
            return Optional.empty();
        }).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
        if (updatedAddFileEntries.isEmpty()) {
            return;
        }
        try {
            long createdTime = Instant.now().toEpochMilli();
            long readVersion = tableHandle.getReadVersion();
            long commitVersion = readVersion + 1L;
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableHandle.getLocation());
            transactionLogWriter.appendCommitInfoEntry(this.getCommitInfoEntry(session, DeltaLakeSchemaSupport.IsolationLevel.WRITESERIALIZABLE, commitVersion, createdTime, OPTIMIZE_OPERATION, readVersion, true));
            updatedAddFileEntries.forEach(transactionLogWriter::appendAddFileEntry);
            transactionLogWriter.flush();
        }
        catch (Throwable e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to access file system for: " + tableHandle.getLocation(), e);
        }
    }

    private AddFileEntry prepareUpdatedAddFileEntry(ComputedStatistics stats, AddFileEntry addFileEntry, Map<String, DeltaLakeColumnHandle> lowercaseToColumnsHandles) {
        DeltaLakeJsonFileStatistics deltaLakeJsonFileStatistics = DeltaLakeComputedStatistics.toDeltaLakeJsonFileStatistics(stats, lowercaseToColumnsHandles);
        try {
            return new AddFileEntry(addFileEntry.getPath(), addFileEntry.getPartitionValues(), addFileEntry.getSize(), addFileEntry.getModificationTime(), false, Optional.of(DeltaLakeSchemaSupport.serializeStatsAsJson(deltaLakeJsonFileStatistics)), Optional.empty(), addFileEntry.getTags(), addFileEntry.getDeletionVector());
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Statistics serialization error", (Throwable)e);
        }
    }

    private void updateTableStatistics(ConnectorSession session, Optional<AnalyzeHandle> analyzeHandle, SchemaTableName schemaTableName, String location, Optional<Instant> maxFileModificationTime, Collection<ComputedStatistics> computedStatistics, List<String> originalColumnNames, Optional<Map<String, String>> physicalColumnNameMapping, boolean ignoreFailure) {
        boolean loadExistingStats;
        Optional<Object> oldStatistics = Optional.empty();
        boolean bl = loadExistingStats = analyzeHandle.isEmpty() || analyzeHandle.get().analyzeMode() == DeltaLakeAnalyzeProperties.AnalyzeMode.INCREMENTAL;
        if (loadExistingStats) {
            oldStatistics = this.statisticsAccess.readExtendedStatistics(session, schemaTableName, location);
        }
        oldStatistics.ifPresent(statistics -> Preconditions.checkArgument((statistics.getModelVersion() == 4L ? 1 : 0) != 0, (Object)"Existing table statistics are incompatible, run the drop statistics procedure on this table before re-analyzing"));
        Map lowerCaseToExactColumnNames = (Map)originalColumnNames.stream().collect(ImmutableMap.toImmutableMap(name -> name.toLowerCase(Locale.ENGLISH), Function.identity()));
        Map oldColumnStatistics = oldStatistics.map(ExtendedStatistics::getColumnStatistics).orElseGet(ImmutableMap::of);
        Map<String, DeltaLakeColumnStatistics> newColumnStatistics = DeltaLakeMetadata.toDeltaLakeColumnStatistics(computedStatistics);
        Map mergedColumnStatistics = (Map)newColumnStatistics.entrySet().stream().map(entry -> {
            String columnName = (String)entry.getKey();
            String physicalColumnName = DeltaLakeMetadata.toPhysicalColumnName(columnName, lowerCaseToExactColumnNames, physicalColumnNameMapping);
            return Map.entry(physicalColumnName, (DeltaLakeColumnStatistics)entry.getValue());
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            String columnName = (String)entry.getKey();
            DeltaLakeColumnStatistics newStats = (DeltaLakeColumnStatistics)entry.getValue();
            DeltaLakeColumnStatistics oldStats = (DeltaLakeColumnStatistics)oldColumnStatistics.get(columnName);
            return oldStats == null ? newStats : oldStats.update(newStats);
        }));
        Instant finalAlreadyAnalyzedModifiedTimeMax = Instant.now();
        if (maxFileModificationTime.isPresent()) {
            finalAlreadyAnalyzedModifiedTimeMax = (Instant)Comparators.min((Comparable)maxFileModificationTime.get(), (Comparable)finalAlreadyAnalyzedModifiedTimeMax);
        }
        if (oldStatistics.isPresent()) {
            finalAlreadyAnalyzedModifiedTimeMax = (Instant)Comparators.max((Comparable)((ExtendedStatistics)oldStatistics.get()).getAlreadyAnalyzedModifiedTimeMax(), (Comparable)finalAlreadyAnalyzedModifiedTimeMax);
        }
        Optional<Set<String>> analyzedColumns = analyzeHandle.flatMap(AnalyzeHandle::columns);
        if (analyzeHandle.isEmpty()) {
            analyzedColumns = oldStatistics.flatMap(ExtendedStatistics::getAnalyzedColumns);
        }
        analyzedColumns.ifPresent(analyzeColumns -> {
            Set analyzePhysicalColumns = (Set)analyzeColumns.stream().map(columnName -> DeltaLakeMetadata.toPhysicalColumnName(columnName, lowerCaseToExactColumnNames, physicalColumnNameMapping)).collect(ImmutableSet.toImmutableSet());
            if (!mergedColumnStatistics.keySet().equals(analyzePhysicalColumns)) {
                throw new IllegalStateException(String.format("Unexpected columns in in mergedColumnStatistics %s; expected %s", mergedColumnStatistics.keySet(), analyzePhysicalColumns));
            }
        });
        ExtendedStatistics mergedExtendedStatistics = new ExtendedStatistics(finalAlreadyAnalyzedModifiedTimeMax, mergedColumnStatistics, analyzedColumns);
        try {
            this.statisticsAccess.updateExtendedStatistics(session, schemaTableName, location, mergedExtendedStatistics);
        }
        catch (Exception e) {
            if (ignoreFailure) {
                LOG.error((Throwable)e, "Failed to write extended statistics for the table %s", new Object[]{schemaTableName});
            }
            throw e;
        }
    }

    private static String toPhysicalColumnName(String columnName, Map<String, String> lowerCaseToExactColumnNames, Optional<Map<String, String>> physicalColumnNameMapping) {
        String originalColumnName = lowerCaseToExactColumnNames.get(columnName.toLowerCase(Locale.ENGLISH));
        Preconditions.checkArgument((originalColumnName != null ? 1 : 0) != 0, (String)"%s doesn't contain '%s'", lowerCaseToExactColumnNames.keySet(), (Object)columnName);
        if (physicalColumnNameMapping.isPresent()) {
            String physicalColumnName = physicalColumnNameMapping.get().get(originalColumnName);
            return Objects.requireNonNull(physicalColumnName, () -> "%s doesn't exist in %s".formatted(columnName, physicalColumnNameMapping));
        }
        return originalColumnName;
    }

    private void cleanExtraOutputFiles(ConnectorSession session, Location baseLocation, List<DataFileInfo> validDataFiles) {
        Set writtenFilePaths = (Set)validDataFiles.stream().map(dataFileInfo -> baseLocation.appendPath(dataFileInfo.path())).collect(ImmutableSet.toImmutableSet());
        this.cleanExtraOutputFiles(session, writtenFilePaths);
    }

    private void cleanExtraOutputFiles(ConnectorSession session, Set<Location> validWrittenFilePaths) {
        Set fileLocations = (Set)validWrittenFilePaths.stream().map(Location::parentDirectory).collect(ImmutableSet.toImmutableSet());
        for (Location location : fileLocations) {
            this.cleanExtraOutputFiles(session, session.getQueryId(), location, validWrittenFilePaths);
        }
    }

    private void cleanExtraOutputFiles(ConnectorSession session, String queryId, Location location, Set<Location> filesToKeep) {
        ArrayDeque<Location> filesToDelete = new ArrayDeque<Location>();
        try {
            LOG.debug("Deleting failed attempt files from %s for query %s", new Object[]{location, queryId});
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            FileIterator iterator = fileSystem.listFiles(location);
            while (iterator.hasNext()) {
                Location file = iterator.next().location();
                if (!file.parentDirectory().equals((Object)location) || !DeltaLakeMetadata.isFileCreatedByQuery(file, queryId) || filesToKeep.contains(file)) continue;
                filesToDelete.add(file);
            }
            if (filesToDelete.isEmpty()) {
                return;
            }
            LOG.info("Found %s files to delete and %s to retain in location %s for query %s", new Object[]{filesToDelete.size(), filesToKeep.size(), location, queryId});
            fileSystem.deleteFiles(filesToDelete);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Failed to clean up extraneous output files", (Throwable)e);
        }
    }

    private static boolean isFileCreatedByQuery(Location file, String queryId) {
        Verify.verify((!queryId.contains("-") ? 1 : 0) != 0, (String)"queryId(%s) should not contain hyphens", (Object)queryId);
        return file.fileName().startsWith(queryId + "-");
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.getRawSystemTable(session, tableName).map(systemTable -> new ClassLoaderSafeSystemTable(systemTable, this.getClass().getClassLoader()));
    }

    private Optional<SystemTable> getRawSystemTable(ConnectorSession session, SchemaTableName systemTableName) {
        Optional<DeltaMetastoreTable> table;
        Optional<DeltaLakeTableType> tableType = DeltaLakeTableName.tableTypeFrom(systemTableName.getTableName());
        if (tableType.isEmpty() || tableType.get() == DeltaLakeTableType.DATA) {
            return Optional.empty();
        }
        String tableName = DeltaLakeTableName.tableNameFrom(systemTableName.getTableName());
        try {
            table = this.metastore.getTable(systemTableName.getSchemaName(), tableName);
        }
        catch (NotADeltaLakeTableException e) {
            return Optional.empty();
        }
        if (table.isEmpty()) {
            return Optional.empty();
        }
        String tableLocation = table.get().location();
        return switch (tableType.get()) {
            default -> throw new MatchException(null, null);
            case DeltaLakeTableType.DATA -> throw new VerifyException("Unexpected DATA table type");
            case DeltaLakeTableType.HISTORY -> Optional.of(new DeltaLakeHistoryTable(systemTableName, tableLocation, this.fileSystemFactory, this.transactionLogAccess, this.typeManager));
            case DeltaLakeTableType.TRANSACTIONS -> Optional.of(new DeltaLakeTransactionsTable(systemTableName, tableLocation, this.fileSystemFactory, this.transactionLogAccess, this.typeManager));
            case DeltaLakeTableType.PROPERTIES -> Optional.of(new DeltaLakePropertiesTable(systemTableName, tableLocation, this.transactionLogAccess));
            case DeltaLakeTableType.PARTITIONS -> Optional.of(new DeltaLakePartitionsTable(session, systemTableName, tableLocation, this.transactionLogAccess, this.typeManager));
        };
    }

    public boolean allowSplittingReadIntoMultipleSubQueries(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return true;
    }

    public WriterScalingOptions getNewTableWriterScalingOptions(ConnectorSession session, SchemaTableName tableName, Map<String, Object> tableProperties) {
        return WriterScalingOptions.ENABLED;
    }

    public WriterScalingOptions getInsertWriterScalingOptions(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return WriterScalingOptions.ENABLED;
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.executeDelete(session, DeltaLakeMetadata.checkValidTableHandle(tableHandle), TRUNCATE_OPERATION);
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)handle;
        if (DeltaLakeSchemaSupport.changeDataFeedEnabled(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry()).orElse(false).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(tableHandle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return this.executeDelete(session, handle, DELETE_OPERATION);
    }

    private OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle handle, String operation) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)handle;
        if (DeltaLakeSchemaSupport.isAppendOnly(tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot modify rows from a table with 'delta.appendOnly' set to true");
        }
        this.checkWriteAllowed(session, tableHandle);
        this.checkWriteSupported(tableHandle);
        try {
            DeltaLakeSchemaSupport.IsolationLevel isolationLevel = DeltaLakeSchemaSupport.getIsolationLevel(tableHandle.getMetadataEntry());
            AtomicReference<Long> readVersion = new AtomicReference<Long>(tableHandle.getReadVersion());
            CommitDeleteOperationResult commitDeleteOperationResult = (CommitDeleteOperationResult)Failsafe.with(TRANSACTION_CONFLICT_RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(context -> this.commitDeleteOperation(session, tableHandle, operation, isolationLevel, readVersion, context.getAttemptCount()));
            this.writeCheckpointIfNeeded(session, tableHandle.getSchemaTableName(), tableHandle.location(), tableHandle.getReadVersion(), tableHandle.getMetadataEntry().getCheckpointInterval(), commitDeleteOperationResult.commitVersion());
            this.enqueueUpdateInfo(session, tableHandle.getSchemaName(), tableHandle.getTableName(), commitDeleteOperationResult.commitVersion, tableHandle.getMetadataEntry().getSchemaString(), Optional.ofNullable(tableHandle.getMetadataEntry().getDescription()));
            return commitDeleteOperationResult.deletedRecords();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private CommitDeleteOperationResult commitDeleteOperation(ConnectorSession session, DeltaLakeTableHandle tableHandle, String operation, DeltaLakeSchemaSupport.IsolationLevel isolationLevel, AtomicReference<Long> readVersion, int attemptCount) throws IOException {
        String tableLocation = tableHandle.location();
        TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
        long writeTimestamp = Instant.now().toEpochMilli();
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        long currentVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, tableLocation, readVersion.get());
        this.checkForConcurrentTransactionConflicts(session, fileSystem, (List<TupleDomain<DeltaLakeColumnHandle>>)ImmutableList.of(tableHandle.getEnforcedPartitionConstraint()), isolationLevel, currentVersion, readVersion, tableHandle.getLocation(), attemptCount);
        long commitVersion = currentVersion + 1L;
        transactionLogWriter.appendCommitInfoEntry(this.getCommitInfoEntry(session, isolationLevel, commitVersion, writeTimestamp, operation, tableHandle.getReadVersion(), false));
        long deletedRecords = 0L;
        boolean allDeletedFilesStatsPresent = true;
        try (Stream<AddFileEntry> activeFiles = this.getAddFileEntriesMatchingEnforcedPartitionConstraint(session, tableHandle);){
            Iterator addFileEntryIterator = activeFiles.iterator();
            while (addFileEntryIterator.hasNext()) {
                AddFileEntry addFileEntry = (AddFileEntry)addFileEntryIterator.next();
                transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(addFileEntry.getPath(), addFileEntry.getPartitionValues(), writeTimestamp, true, Optional.empty()));
                Optional fileRecords = addFileEntry.getStats().flatMap(DeltaLakeFileStatistics::getNumRecords);
                allDeletedFilesStatsPresent &= fileRecords.isPresent();
                deletedRecords += fileRecords.orElse(0L).longValue();
            }
        }
        transactionLogWriter.flush();
        return new CommitDeleteOperationResult(commitVersion, allDeletedFilesStatsPresent ? OptionalLong.of(deletedRecords) : OptionalLong.empty());
    }

    private void enqueueUpdateInfo(ConnectorSession session, String schemaName, String tableName, long version, String schemaString, Optional<String> tableComment) {
        if (!this.metadataScheduler.canStoreTableMetadata(session, schemaString, tableComment)) {
            return;
        }
        this.tableUpdateInfos.put(new SchemaTableName(schemaName, tableName), new DeltaLakeTableMetadataScheduler.TableUpdateInfo(session, version, schemaString, tableComment));
    }

    public void commit() {
        this.metadataScheduler.putAll(this.tableUpdateInfos);
        this.tableUpdateInfos.clear();
    }

    private Stream<AddFileEntry> getAddFileEntriesMatchingEnforcedPartitionConstraint(ConnectorSession session, DeltaLakeTableHandle tableHandle) {
        TableSnapshot tableSnapshot = this.getSnapshot(session, tableHandle);
        Stream<AddFileEntry> validDataFiles = this.transactionLogAccess.getActiveFiles(session, tableSnapshot, tableHandle.getMetadataEntry(), tableHandle.getProtocolEntry(), tableHandle.getEnforcedPartitionConstraint(), tableHandle.getProjectedColumns().orElse((Set<DeltaLakeColumnHandle>)ImmutableSet.of()));
        TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint = tableHandle.getEnforcedPartitionConstraint();
        if (enforcedPartitionConstraint.isAll()) {
            return validDataFiles;
        }
        Map enforcedDomains = (Map)enforcedPartitionConstraint.getDomains().orElseThrow();
        return validDataFiles.filter(addAction -> DeltaLakeSplitManager.partitionMatchesPredicate(addAction.getCanonicalPartitionValues(), enforcedDomains));
    }

    private static Map<String, DeltaLakeColumnStatistics> toDeltaLakeColumnStatistics(Collection<ComputedStatistics> computedStatistics) {
        return (Map)computedStatistics.stream().map(statistics -> (ImmutableMap)DeltaLakeMetadata.createColumnToComputedStatisticsMap(statistics.getColumnStatistics()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> DeltaLakeMetadata.createDeltaLakeColumnStatistics((Map)entry.getValue())))).map(Map::entrySet).flatMap(Collection::stream).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, DeltaLakeColumnStatistics::update));
    }

    private static Map<String, Map<ColumnStatisticType, Block>> createColumnToComputedStatisticsMap(Map<ColumnStatisticMetadata, Block> computedStatistics) {
        ImmutableTable.Builder result = ImmutableTable.builder();
        computedStatistics.forEach((metadata, block) -> {
            if (metadata.getColumnName().equals("$file_modified_time")) {
                return;
            }
            if (!SUPPORTED_STATISTICS_TYPE.contains(metadata.getStatisticType())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected statistics collection: " + String.valueOf(metadata));
            }
            result.put((Object)metadata.getColumnName(), (Object)metadata.getStatisticType(), block);
        });
        return result.buildOrThrow().rowMap();
    }

    private static DeltaLakeColumnStatistics createDeltaLakeColumnStatistics(Map<ColumnStatisticType, Block> computedStatistics) {
        OptionalLong totalSize = OptionalLong.empty();
        if (computedStatistics.containsKey(ColumnStatisticType.TOTAL_SIZE_IN_BYTES)) {
            totalSize = DeltaLakeMetadata.getLongValue(computedStatistics.get(ColumnStatisticType.TOTAL_SIZE_IN_BYTES));
        }
        HyperLogLog ndvSummary = DeltaLakeMetadata.getHyperLogLogForNdv(computedStatistics.get(ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY));
        return DeltaLakeColumnStatistics.create(totalSize, ndvSummary);
    }

    private static OptionalLong getLongValue(Block block) {
        if (block.isNull(0)) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(BigintType.BIGINT.getLong(block, 0));
    }

    private static HyperLogLog getHyperLogLogForNdv(Block block) {
        if (block.isNull(0)) {
            return HyperLogLog.newInstance((int)4096);
        }
        Slice serializedSummary = (Slice)Utils.blockToNativeValue((Type)HyperLogLogType.HYPER_LOG_LOG, (Block)block);
        return HyperLogLog.newInstance((Slice)serializedSummary);
    }

    private static Optional<Instant> getMaxFileModificationTime(Collection<ComputedStatistics> computedStatistics) {
        return computedStatistics.stream().map(ComputedStatistics::getColumnStatistics).map(Map::entrySet).flatMap(Collection::stream).filter(entry -> ((ColumnStatisticMetadata)entry.getKey()).getColumnName().equals("$file_modified_time")).flatMap(entry -> {
            ColumnStatisticMetadata columnStatisticMetadata = (ColumnStatisticMetadata)entry.getKey();
            if (columnStatisticMetadata.getStatisticType() != ColumnStatisticType.MAX_VALUE) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected statistics collection: " + String.valueOf(columnStatisticMetadata));
            }
            if (((Block)entry.getValue()).isNull(0)) {
                return Stream.of(new Instant[0]);
            }
            return Stream.of(Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong((Block)entry.getValue(), 0))));
        }).max(Comparator.naturalOrder());
    }

    public DeltaLakeMetastore getMetastore() {
        return this.metastore;
    }

    private static ColumnMetadata getColumnMetadata(DeltaLakeColumnHandle column, @Nullable String comment, boolean nullability, Optional<String> generationExpression) {
        Type columnType;
        String columnName;
        if (column.isBaseColumn()) {
            columnName = column.baseColumnName();
            columnType = column.baseType();
        } else {
            DeltaLakeColumnProjectionInfo projectionInfo = column.projectionInfo().orElseThrow();
            columnName = column.qualifiedPhysicalName();
            columnType = projectionInfo.getType();
        }
        return ColumnMetadata.builder().setName(columnName).setType(columnType).setHidden(column.columnType() == DeltaLakeColumnType.SYNTHESIZED).setComment(Optional.ofNullable(comment)).setNullable(nullability).setExtraInfo(generationExpression.map(expression -> "generated: " + expression)).build();
    }

    public static DeltaLakeTableHandle checkValidTableHandle(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        if (tableHandle instanceof CorruptedDeltaLakeTableHandle) {
            CorruptedDeltaLakeTableHandle corruptedTableHandle = (CorruptedDeltaLakeTableHandle)tableHandle;
            throw corruptedTableHandle.createException();
        }
        return (DeltaLakeTableHandle)tableHandle;
    }

    public static TupleDomain<DeltaLakeColumnHandle> createStatisticsPredicate(AddFileEntry addFileEntry, List<DeltaLakeColumnMetadata> schema, List<String> canonicalPartitionColumns) {
        return addFileEntry.getStats().map(deltaLakeFileStatistics -> TupleDomain.withColumnDomains((Map)((Map)schema.stream().filter(column -> DeltaLakeMetadata.canUseInPredicate(column.columnMetadata())).collect(ImmutableMap.toImmutableMap(column -> DeltaLakeMetadata.toColumnHandle(column.name(), column.type(), column.fieldId(), column.physicalName(), column.physicalColumnType(), canonicalPartitionColumns), column -> DeltaLakeMetadata.buildColumnDomain(column, deltaLakeFileStatistics, canonicalPartitionColumns)))))).orElseGet(TupleDomain::all);
    }

    private static boolean canUseInPredicate(ColumnMetadata column) {
        Type type = column.getType();
        return type.equals((Object)TinyintType.TINYINT) || type.equals((Object)SmallintType.SMALLINT) || type.equals((Object)IntegerType.INTEGER) || type.equals((Object)BigintType.BIGINT) || type.equals((Object)RealType.REAL) || type.equals((Object)DoubleType.DOUBLE) || type.equals((Object)BooleanType.BOOLEAN) || type.equals((Object)DateType.DATE) || type instanceof TimestampWithTimeZoneType || type instanceof DecimalType || type.equals((Object)VarcharType.VARCHAR);
    }

    private static Domain buildColumnDomain(DeltaLakeColumnMetadata column, DeltaLakeFileStatistics stats, List<String> canonicalPartitionColumns) {
        Optional<Object> maxValue;
        Optional<Long> nullCount = stats.getNullCount(column.physicalName());
        if (nullCount.isEmpty()) {
            return Domain.all((Type)column.type());
        }
        if (stats.getNumRecords().equals(nullCount)) {
            return Domain.onlyNull((Type)column.type());
        }
        boolean hasNulls = nullCount.get() > 0L;
        DeltaLakeColumnHandle deltaLakeColumnHandle = DeltaLakeMetadata.toColumnHandle(column.name(), column.type(), column.fieldId(), column.physicalName(), column.physicalColumnType(), canonicalPartitionColumns);
        Optional<Object> minValue = stats.getMinColumnValue(deltaLakeColumnHandle);
        if (minValue.isPresent() && TypeUtils.isFloatingPointNaN((Type)column.type(), (Object)minValue.get())) {
            return DeltaLakeMetadata.allValues(column.type(), hasNulls);
        }
        if (DeltaLakeMetadata.isNotFinite(minValue, column.type())) {
            minValue = Optional.empty();
        }
        if ((maxValue = stats.getMaxColumnValue(deltaLakeColumnHandle)).isPresent() && TypeUtils.isFloatingPointNaN((Type)column.type(), (Object)maxValue.get())) {
            return DeltaLakeMetadata.allValues(column.type(), hasNulls);
        }
        if (DeltaLakeMetadata.isNotFinite(maxValue, column.type())) {
            maxValue = Optional.empty();
        }
        if (minValue.isPresent() && maxValue.isPresent()) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)column.type(), (Object)minValue.get(), (boolean)true, (Object)maxValue.get(), (boolean)true), (Range[])new Range[0]), (boolean)hasNulls);
        }
        if (minValue.isPresent()) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)column.type(), (Object)minValue.get()), (Range[])new Range[0]), (boolean)hasNulls);
        }
        return maxValue.map(value -> Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)column.type(), (Object)value), (Range[])new Range[0]), (boolean)hasNulls)).orElseGet(() -> Domain.all((Type)column.type()));
    }

    private static boolean isNotFinite(Optional<Object> value, Type type) {
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return value.map(Double.class::cast).filter(val -> !Double.isFinite(val)).isPresent();
        }
        if (type.equals((Object)RealType.REAL)) {
            return value.map(Long.class::cast).map(Math::toIntExact).map(Float::intBitsToFloat).filter(val -> !Float.isFinite(val.floatValue())).isPresent();
        }
        return false;
    }

    private static Domain allValues(Type type, boolean includeNull) {
        if (includeNull) {
            return Domain.all((Type)type);
        }
        return Domain.notNull((Type)type);
    }

    private static DeltaLakeColumnHandle toColumnHandle(String originalName, Type type, OptionalInt fieldId, String physicalName, Type physicalType, Collection<String> partitionColumns) {
        boolean isPartitionKey = partitionColumns.stream().anyMatch(partition -> partition.equalsIgnoreCase(originalName));
        return new DeltaLakeColumnHandle(originalName, type, fieldId, physicalName, physicalType, isPartitionKey ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR, Optional.empty());
    }

    private static Optional<String> getQueryId(Database database) {
        return Optional.ofNullable((String)database.getParameters().get("trino_query_id"));
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$76(Map newVariables, ConnectorExpression expression) {
        return ApplyProjectionUtil.replaceWithNewVariables((ConnectorExpression)expression, (Map)newVariables);
    }

    private static /* synthetic */ boolean lambda$streamRelationComments$18(Set viewNames, SchemaTableName tableName) {
        return !viewNames.contains(tableName);
    }

    private record QueriedTable(SchemaTableName schemaTableName, long version) {
        QueriedTable {
            Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }
    }

    private record CommitDeleteOperationResult(long commitVersion, OptionalLong deletedRecords) {
        CommitDeleteOperationResult {
            Objects.requireNonNull(deletedRecords, "deletedRecords is null");
        }
    }
}

