/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public record DeltaLakeOutputTableHandle(String schemaName, String tableName, List<DeltaLakeColumnHandle> inputColumns, String location, Optional<Long> checkpointInterval, boolean external, Optional<String> comment, Optional<Boolean> changeDataFeedEnabled, boolean deletionVectorsEnabled, String schemaString, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, OptionalInt maxColumnId, boolean replace, OptionalLong readVersion, ProtocolEntry protocolEntry) implements ConnectorOutputTableHandle
{
    public DeltaLakeOutputTableHandle {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        inputColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputColumns, "inputColumns is null"));
        Objects.requireNonNull(location, "location is null");
        Objects.requireNonNull(checkpointInterval, "checkpointInterval is null");
        Objects.requireNonNull(comment, "comment is null");
        Objects.requireNonNull(changeDataFeedEnabled, "changeDataFeedEnabled is null");
        Objects.requireNonNull(schemaString, "schemaString is null");
        Objects.requireNonNull(columnMappingMode, "columnMappingMode is null");
        Objects.requireNonNull(maxColumnId, "maxColumnId is null");
        Objects.requireNonNull(readVersion, "readVersion is null");
        Objects.requireNonNull(protocolEntry, "protocolEntry is null");
    }

    public List<String> partitionedBy() {
        return (List)this.inputColumns().stream().filter(column -> column.columnType() == DeltaLakeColumnType.PARTITION_KEY).map(DeltaLakeColumnHandle::columnName).collect(ImmutableList.toImmutableList());
    }
}

