/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.util.PageListBuilder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DeltaLakePartitionsTable
implements SystemTable {
    private final TableSnapshot tableSnapshot;
    private final TransactionLogAccess transactionLogAccess;
    private final TypeManager typeManager;
    private final MetadataEntry metadataEntry;
    private final ProtocolEntry protocolEntry;
    private final ConnectorTableMetadata tableMetadata;
    private final List<DeltaLakeColumnMetadata> schema;
    private final List<DeltaLakeColumnHandle> partitionColumns;
    private final List<RowType.Field> partitionFields;
    private final List<DeltaLakeColumnHandle> regularColumns;
    private final Optional<RowType> dataColumnType;
    private final List<RowType> columnMetricTypes;

    public DeltaLakePartitionsTable(ConnectorSession session, SchemaTableName tableName, String tableLocation, TransactionLogAccess transactionLogAccess, TypeManager typeManager) {
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        try {
            this.tableSnapshot = transactionLogAccess.loadSnapshot(session, tableName, tableLocation, Optional.empty());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error getting snapshot from location: " + tableLocation, (Throwable)e);
        }
        this.metadataEntry = transactionLogAccess.getMetadataEntry(session, this.tableSnapshot);
        this.protocolEntry = transactionLogAccess.getProtocolEntry(session, this.tableSnapshot);
        this.schema = DeltaLakeSchemaSupport.extractSchema(this.metadataEntry, this.protocolEntry, typeManager);
        this.partitionColumns = this.getPartitionColumns();
        this.partitionFields = (List)this.partitionColumns.stream().map(column -> RowType.field((String)column.baseColumnName(), (Type)column.type())).collect(ImmutableList.toImmutableList());
        this.regularColumns = (List)this.getColumns().stream().filter(column -> column.columnType() == DeltaLakeColumnType.REGULAR).collect(ImmutableList.toImmutableList());
        this.dataColumnType = DeltaLakePartitionsTable.getMetricsColumnType(this.regularColumns);
        ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
        if (!this.partitionFields.isEmpty()) {
            columnMetadataBuilder.add((Object)new ColumnMetadata("partition", (Type)RowType.from(this.partitionFields)));
        }
        columnMetadataBuilder.add((Object)new ColumnMetadata("file_count", (Type)BigintType.BIGINT));
        columnMetadataBuilder.add((Object)new ColumnMetadata("total_size", (Type)BigintType.BIGINT));
        if (this.dataColumnType.isPresent()) {
            columnMetadataBuilder.add((Object)new ColumnMetadata("data", (Type)this.dataColumnType.get()));
            this.columnMetricTypes = (List)this.dataColumnType.get().getFields().stream().map(RowType.Field::getType).map(RowType.class::cast).collect(ImmutableList.toImmutableList());
        } else {
            this.columnMetricTypes = ImmutableList.of();
        }
        this.tableMetadata = new ConnectorTableMetadata(tableName, (List)columnMetadataBuilder.build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (this.partitionColumns.isEmpty()) {
            return new EmptyPageSource();
        }
        return new FixedPageSource(this.buildPages(session));
    }

    private List<Page> buildPages(ConnectorSession session) {
        Map<Map<String, Optional<String>>, DeltaLakePartitionStatistics> statisticsByPartition;
        PageListBuilder pageListBuilder = PageListBuilder.forTable(this.tableMetadata);
        try (Stream<AddFileEntry> activeFiles = this.transactionLogAccess.loadActiveFiles(session, this.tableSnapshot, this.metadataEntry, this.protocolEntry, (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (Predicate<String>)Predicates.alwaysTrue());){
            statisticsByPartition = this.getStatisticsByPartition(activeFiles);
        }
        for (Map.Entry<Map<String, Optional<String>>, DeltaLakePartitionStatistics> partitionEntry : statisticsByPartition.entrySet()) {
            Map<String, Optional<String>> partitionValue = partitionEntry.getKey();
            DeltaLakePartitionStatistics deltaLakePartitionStatistics = partitionEntry.getValue();
            RowType partitionValuesRowType = RowType.from(this.partitionFields);
            SqlRow partitionValuesRow = RowValueBuilder.buildRowValue((RowType)partitionValuesRowType, fields -> {
                for (int i = 0; i < this.partitionColumns.size(); ++i) {
                    DeltaLakeColumnHandle column = this.partitionColumns.get(i);
                    Type type = column.type();
                    Optional value = (Optional)partitionValue.get(column.basePhysicalColumnName());
                    Object deserializedPartitionValue = TransactionLogParser.deserializePartitionValue(column, value);
                    TypeUtils.writeNativeValue((Type)type, (BlockBuilder)((BlockBuilder)fields.get(i)), (Object)deserializedPartitionValue);
                }
            });
            pageListBuilder.beginRow();
            pageListBuilder.appendNativeValue((Type)partitionValuesRowType, partitionValuesRow);
            pageListBuilder.appendBigint(deltaLakePartitionStatistics.fileCount());
            pageListBuilder.appendBigint(deltaLakePartitionStatistics.size());
            this.dataColumnType.ifPresent(dataColumnType -> {
                SqlRow dataColumnRow = RowValueBuilder.buildRowValue((RowType)dataColumnType, fields -> {
                    for (int i = 0; i < this.columnMetricTypes.size(); ++i) {
                        String fieldName = this.regularColumns.get(i).baseColumnName();
                        Object min = deltaLakePartitionStatistics.minValues().getOrDefault(fieldName, null);
                        Object max = deltaLakePartitionStatistics.maxValues().getOrDefault(fieldName, null);
                        Long nullCount = deltaLakePartitionStatistics.nullCounts().getOrDefault(fieldName, null);
                        RowType columnMetricType = this.columnMetricTypes.get(i);
                        columnMetricType.writeObject((BlockBuilder)fields.get(i), (Object)DeltaLakePartitionsTable.getColumnMetricBlock(columnMetricType, min, max, nullCount));
                    }
                });
                pageListBuilder.appendNativeValue((Type)dataColumnType, dataColumnRow);
            });
            pageListBuilder.endRow();
        }
        return pageListBuilder.build();
    }

    private Map<Map<String, Optional<String>>, DeltaLakePartitionStatistics> getStatisticsByPartition(Stream<AddFileEntry> addFileEntryStream) {
        HashMap partitionValueStatistics = new HashMap();
        addFileEntryStream.forEach(addFileEntry -> {
            Map<String, Optional<String>> partitionValues = addFileEntry.getCanonicalPartitionValues();
            partitionValueStatistics.computeIfAbsent(partitionValues, key -> new DeltaLakePartitionStatistics.Builder(this.regularColumns, this.typeManager)).acceptAddFileEntry((AddFileEntry)addFileEntry);
        });
        return (Map)partitionValueStatistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DeltaLakePartitionStatistics.Builder)entry.getValue()).build()));
    }

    private List<DeltaLakeColumnHandle> getPartitionColumns() {
        Map columnsMetadataByName = (Map)this.schema.stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnMetadata::name, Function.identity()));
        return (List)this.metadataEntry.getOriginalPartitionColumns().stream().map(partitionColumnName -> {
            DeltaLakeColumnMetadata columnMetadata = (DeltaLakeColumnMetadata)columnsMetadataByName.get(partitionColumnName);
            return new DeltaLakeColumnHandle(columnMetadata.name(), columnMetadata.type(), OptionalInt.empty(), columnMetadata.physicalName(), columnMetadata.physicalColumnType(), DeltaLakeColumnType.PARTITION_KEY, Optional.empty());
        }).collect(ImmutableList.toImmutableList());
    }

    private List<DeltaLakeColumnHandle> getColumns() {
        return (List)this.schema.stream().map(column -> {
            boolean isPartitionKey = this.metadataEntry.getOriginalPartitionColumns().contains(column.name());
            return new DeltaLakeColumnHandle(column.name(), column.type(), column.fieldId(), column.physicalName(), column.physicalColumnType(), isPartitionKey ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR, Optional.empty());
        }).collect(ImmutableList.toImmutableList());
    }

    private static SqlRow getColumnMetricBlock(RowType columnMetricType, Object min, Object max, Long nullCount) {
        return RowValueBuilder.buildRowValue((RowType)columnMetricType, fieldBuilders -> {
            List fields = columnMetricType.getFields();
            TypeUtils.writeNativeValue((Type)((RowType.Field)fields.get(0)).getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(0)), (Object)min);
            TypeUtils.writeNativeValue((Type)((RowType.Field)fields.get(1)).getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(1)), (Object)max);
            TypeUtils.writeNativeValue((Type)((RowType.Field)fields.get(2)).getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(2)), (Object)nullCount);
        });
    }

    private static Optional<RowType> getMetricsColumnType(List<DeltaLakeColumnHandle> columns) {
        List metricColumns = (List)columns.stream().map(column -> RowType.field((String)column.baseColumnName(), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("min"), column.type()), (Object)new RowType.Field(Optional.of("max"), column.type()), (Object)new RowType.Field(Optional.of("null_count"), (Type)BigintType.BIGINT))))).collect(ImmutableList.toImmutableList());
        if (metricColumns.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(RowType.from((List)metricColumns));
    }

    private record DeltaLakePartitionStatistics(long fileCount, long size, Map<String, Object> minValues, Map<String, Object> maxValues, Map<String, Long> nullCounts) {
        private DeltaLakePartitionStatistics {
            minValues = ImmutableMap.copyOf(Objects.requireNonNull(minValues, "minValues is null"));
            maxValues = ImmutableMap.copyOf(Objects.requireNonNull(maxValues, "maxValues is null"));
            nullCounts = ImmutableMap.copyOf(Objects.requireNonNull(nullCounts, "nullCounts is null"));
        }

        private static class Builder {
            private final List<DeltaLakeColumnHandle> columns;
            private final TypeManager typeManager;
            private long fileCount;
            private long size;
            private final Map<String, ColumnStatistics> columnStatistics = new HashMap<String, ColumnStatistics>();
            private final Map<String, Long> nullCounts = new HashMap<String, Long>();
            private boolean ignoreDataColumn;

            public Builder(List<DeltaLakeColumnHandle> columns, TypeManager typeManager) {
                this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
                this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            }

            public void acceptAddFileEntry(AddFileEntry addFileEntry) {
                if (addFileEntry.getDeletionVector().isPresent()) {
                    return;
                }
                ++this.fileCount;
                this.size += addFileEntry.getSize();
                if (this.ignoreDataColumn) {
                    return;
                }
                addFileEntry.getStats().ifPresentOrElse(stats -> {
                    for (DeltaLakeColumnHandle column : this.columns) {
                        this.updateMinMaxStats(column.baseColumnName(), column.type(), stats.getMinColumnValue(column).orElse(null), stats.getMaxColumnValue(column).orElse(null), stats.getNumRecords().orElse(0L));
                        this.updateNullCountStats(column.baseColumnName(), stats.getNullCount(column.basePhysicalColumnName()).orElse(null));
                    }
                }, () -> {
                    this.columnStatistics.clear();
                    this.nullCounts.clear();
                    this.ignoreDataColumn = true;
                });
            }

            public DeltaLakePartitionStatistics build() {
                ImmutableMap.Builder minValues = ImmutableMap.builder();
                ImmutableMap.Builder maxValues = ImmutableMap.builder();
                this.columnStatistics.forEach((key, statistics) -> {
                    statistics.getMin().ifPresent(min -> minValues.put(key, min));
                    statistics.getMax().ifPresent(max -> maxValues.put(key, max));
                });
                return new DeltaLakePartitionStatistics(this.fileCount, this.size, (Map<String, Object>)minValues.buildOrThrow(), (Map<String, Object>)maxValues.buildOrThrow(), (Map<String, Long>)ImmutableMap.copyOf(this.nullCounts));
            }

            private void updateNullCountStats(String key, Long nullCount) {
                if (nullCount != null) {
                    this.nullCounts.merge(key, nullCount, Long::sum);
                }
            }

            private void updateMinMaxStats(String key, Type type, Object lowerBound, Object upperBound, long recordCount) {
                if (type.isOrderable() && recordCount != 0L) {
                    this.columnStatistics.computeIfAbsent(key, ignored -> {
                        MethodHandle comparisonHandle = this.typeManager.getTypeOperators().getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
                        return new ColumnStatistics(comparisonHandle, lowerBound, upperBound);
                    }).updateMinMax(lowerBound, upperBound);
                }
            }

            private static class ColumnStatistics {
                private final MethodHandle comparisonHandle;
                private Optional<Object> min;
                private Optional<Object> max;

                public ColumnStatistics(MethodHandle comparisonHandle, Object initialMin, Object initialMax) {
                    this.comparisonHandle = Objects.requireNonNull(comparisonHandle, "comparisonHandle is null");
                    this.min = Optional.ofNullable(initialMin);
                    this.max = Optional.ofNullable(initialMax);
                }

                public Optional<Object> getMin() {
                    return this.min;
                }

                public Optional<Object> getMax() {
                    return this.max;
                }

                public void updateMinMax(Object lowerBound, Object upperBound) {
                    if (this.min.isPresent()) {
                        if (lowerBound == null) {
                            this.min = Optional.empty();
                        } else if (this.compareTrinoValue(lowerBound, this.min.get()) < 0L) {
                            this.min = Optional.of(lowerBound);
                        }
                    }
                    if (this.max.isPresent()) {
                        if (upperBound == null) {
                            this.max = Optional.empty();
                        } else if (this.compareTrinoValue(upperBound, this.max.get()) > 0L) {
                            this.max = Optional.of(upperBound);
                        }
                    }
                }

                private long compareTrinoValue(Object value, Object otherValue) {
                    try {
                        return this.comparisonHandle.invoke(value, otherValue);
                    }
                    catch (Throwable throwable) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to compare Delta min/max values", throwable);
                    }
                }
            }
        }
    }
}

