/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeTableName;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.util.PageListBuilder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakePropertiesTable
implements SystemTable {
    private static final String DELTA_FEATURE_PREFIX = "delta.feature.";
    private static final String MIN_READER_VERSION_KEY = "delta.minReaderVersion";
    private static final String MIN_WRITER_VERSION_KEY = "delta.minWriterVersion";
    private static final List<ColumnMetadata> COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("key", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("value", (Type)VarcharType.VARCHAR)).build();
    private final SchemaTableName tableName;
    private final String tableLocation;
    private final TransactionLogAccess transactionLogAccess;
    private final ConnectorTableMetadata tableMetadata;

    public DeltaLakePropertiesTable(SchemaTableName tableName, String tableLocation, TransactionLogAccess transactionLogAccess) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), COLUMNS);
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        ProtocolEntry protocolEntry;
        MetadataEntry metadataEntry;
        try {
            SchemaTableName baseTableName = new SchemaTableName(this.tableName.getSchemaName(), DeltaLakeTableName.tableNameFrom(this.tableName.getTableName()));
            TableSnapshot tableSnapshot = this.transactionLogAccess.loadSnapshot(session, baseTableName, this.tableLocation, Optional.empty());
            metadataEntry = this.transactionLogAccess.getMetadataEntry(session, tableSnapshot);
            protocolEntry = this.transactionLogAccess.getProtocolEntry(session, tableSnapshot);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Unable to load table metadata from location: " + this.tableLocation, (Throwable)e);
        }
        return new FixedPageSource(this.buildPages(metadataEntry, protocolEntry));
    }

    private List<Page> buildPages(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(this.tableMetadata);
        metadataEntry.getConfiguration().forEach((key, value) -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar((String)key);
            pagesBuilder.appendVarchar((String)value);
            pagesBuilder.endRow();
        });
        pagesBuilder.beginRow();
        pagesBuilder.appendVarchar(MIN_READER_VERSION_KEY);
        pagesBuilder.appendVarchar(String.valueOf(protocolEntry.minReaderVersion()));
        pagesBuilder.endRow();
        pagesBuilder.beginRow();
        pagesBuilder.appendVarchar(MIN_WRITER_VERSION_KEY);
        pagesBuilder.appendVarchar(String.valueOf(protocolEntry.minWriterVersion()));
        pagesBuilder.endRow();
        ImmutableSet.builder().addAll((Iterable)protocolEntry.readerFeatures().orElseGet(ImmutableSet::of)).addAll((Iterable)protocolEntry.writerFeatures().orElseGet(ImmutableSet::of)).build().forEach(feature -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar(DELTA_FEATURE_PREFIX + feature);
            pagesBuilder.appendVarchar("supported");
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }
}

