/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class DeltaLakeTableProperties {
    public static final String LOCATION_PROPERTY = "location";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String CHECKPOINT_INTERVAL_PROPERTY = "checkpoint_interval";
    public static final String CHANGE_DATA_FEED_ENABLED_PROPERTY = "change_data_feed_enabled";
    public static final String COLUMN_MAPPING_MODE_PROPERTY = "column_mapping_mode";
    public static final String DELETION_VECTORS_ENABLED_PROPERTY = "deletion_vectors_enabled";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public DeltaLakeTableProperties(DeltaLakeConfig config) {
        this.tableProperties = ImmutableList.builder().add((Object)PropertyMetadata.stringProperty((String)LOCATION_PROPERTY, (String)"File system location URI for the table", null, (boolean)false)).add((Object)new PropertyMetadata(PARTITIONED_BY_PROPERTY, "Partition columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((Collection)value).stream().map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).add((Object)PropertyMetadata.longProperty((String)CHECKPOINT_INTERVAL_PROPERTY, (String)"Checkpoint interval", null, (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)CHANGE_DATA_FEED_ENABLED_PROPERTY, (String)"Enables storing change data feed entries", null, (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)COLUMN_MAPPING_MODE_PROPERTY, (String)"Column mapping mode. Possible values: [ID, NAME, NONE]", (String)DeltaLakeSchemaSupport.ColumnMappingMode.NONE.name(), value -> {
            EnumSet<DeltaLakeSchemaSupport.ColumnMappingMode> allowed = EnumSet.of(DeltaLakeSchemaSupport.ColumnMappingMode.ID, DeltaLakeSchemaSupport.ColumnMappingMode.NAME, DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
            if (allowed.stream().map(Enum::name).noneMatch(mode -> mode.equalsIgnoreCase((String)value))) {
                throw new IllegalArgumentException(String.format("Invalid value [%s]. Valid values: [ID, NAME, NONE]", value));
            }
        }, (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)DELETION_VECTORS_ENABLED_PROPERTY, (String)"Enables deletion vectors", (Boolean)config.isDeletionVectorsEnabled(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static String getLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(LOCATION_PROPERTY);
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        List partitionedBy = (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
        return partitionedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitionedBy);
    }

    public static Optional<Long> getCheckpointInterval(Map<String, Object> tableProperties) {
        Optional<Long> checkpointInterval = Optional.ofNullable((Long)tableProperties.get(CHECKPOINT_INTERVAL_PROPERTY));
        checkpointInterval.ifPresent(value -> {
            if (value <= 0L) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be greater than 0", CHECKPOINT_INTERVAL_PROPERTY));
            }
        });
        return checkpointInterval;
    }

    public static Optional<Boolean> getChangeDataFeedEnabled(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Boolean)tableProperties.get(CHANGE_DATA_FEED_ENABLED_PROPERTY));
    }

    public static DeltaLakeSchemaSupport.ColumnMappingMode getColumnMappingMode(Map<String, Object> tableProperties) {
        return DeltaLakeSchemaSupport.ColumnMappingMode.valueOf(tableProperties.get(COLUMN_MAPPING_MODE_PROPERTY).toString().toUpperCase(Locale.ENGLISH));
    }

    public static boolean getDeletionVectorsEnabled(Map<String, Object> tableProperties) {
        return (Boolean)tableProperties.getOrDefault(DELETION_VECTORS_ENABLED_PROPERTY, false);
    }
}

