/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.util.List;

public final class DeltaLakeTypes {
    private DeltaLakeTypes() {
    }

    public static Type toParquetType(TypeOperators typeOperators, Type type) {
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestamp = (TimestampWithTimeZoneType)type;
            Verify.verify((timestamp.getPrecision() == 3 ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)type);
            return TimestampType.TIMESTAMP_MILLIS;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return new ArrayType(DeltaLakeTypes.toParquetType(typeOperators, arrayType.getElementType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return new MapType(DeltaLakeTypes.toParquetType(typeOperators, mapType.getKeyType()), DeltaLakeTypes.toParquetType(typeOperators, mapType.getValueType()), typeOperators);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return RowType.from((List)((List)rowType.getFields().stream().map(field -> RowType.field((String)((String)field.getName().orElseThrow()), (Type)DeltaLakeTypes.toParquetType(typeOperators, field.getType()))).collect(ImmutableList.toImmutableList())));
        }
        return type;
    }
}

