/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.trino.filesystem.Location;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeParquetStatisticsUtils;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.spi.Page;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.FileMetaData;

public final class DeltaLakeWriter
implements FileWriter {
    private final ParquetFileWriter fileWriter;
    private final Location rootTableLocation;
    private final String relativeFilePath;
    private final List<String> partitionValues;
    private final DeltaLakeWriterStats stats;
    private final long creationTime;
    private final Map<Integer, Function<Block, Block>> coercers;
    private final List<DeltaLakeColumnHandle> columnHandles;
    private final DataFileInfo.DataFileType dataFileType;
    private long rowCount;
    private long inputSizeInBytes;

    public DeltaLakeWriter(ParquetFileWriter fileWriter, Location rootTableLocation, String relativeFilePath, List<String> partitionValues, DeltaLakeWriterStats stats, List<DeltaLakeColumnHandle> columnHandles, DataFileInfo.DataFileType dataFileType) {
        this.fileWriter = Objects.requireNonNull(fileWriter, "fileWriter is null");
        this.rootTableLocation = Objects.requireNonNull(rootTableLocation, "rootTableLocation is null");
        this.relativeFilePath = Objects.requireNonNull(relativeFilePath, "relativeFilePath is null");
        this.partitionValues = partitionValues;
        this.stats = stats;
        this.creationTime = Instant.now().toEpochMilli();
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableMap.Builder coercers = ImmutableMap.builder();
        for (int i = 0; i < columnHandles.size(); ++i) {
            Optional<Function<Block, Block>> coercer = DeltaLakeWriter.createCoercer(columnHandles.get(i).baseType());
            if (!coercer.isPresent()) continue;
            coercers.put((Object)i, coercer.get());
        }
        this.coercers = coercers.buildOrThrow();
        this.dataFileType = Objects.requireNonNull(dataFileType, "dataFileType is null");
    }

    public long getWrittenBytes() {
        return this.fileWriter.getWrittenBytes();
    }

    public long getMemoryUsage() {
        return this.fileWriter.getMemoryUsage();
    }

    public void appendRows(Page originalPage) {
        Page page = originalPage;
        if (!this.coercers.isEmpty()) {
            Block[] translatedBlocks = new Block[originalPage.getChannelCount()];
            for (int index = 0; index < translatedBlocks.length; ++index) {
                Block originalBlock = originalPage.getBlock(index);
                Function<Block, Block> coercer = this.coercers.get(index);
                translatedBlocks[index] = coercer != null ? new LazyBlock(originalBlock.getPositionCount(), (LazyBlockLoader)new CoercionLazyBlockLoader(originalBlock, coercer)) : originalBlock;
            }
            page = new Page(originalPage.getPositionCount(), translatedBlocks);
        }
        this.stats.addInputPageSizesInBytes(page.getRetainedSizeInBytes());
        this.fileWriter.appendRows(page);
        this.rowCount += (long)page.getPositionCount();
        this.inputSizeInBytes += page.getSizeInBytes();
    }

    public Closeable commit() {
        return this.fileWriter.commit();
    }

    public void rollback() {
        this.fileWriter.rollback();
    }

    public long getValidationCpuNanos() {
        return 0L;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public DataFileInfo getDataFileInfo() throws IOException {
        Location path = this.rootTableLocation.appendPath(this.relativeFilePath);
        FileMetaData fileMetaData = this.fileWriter.getFileMetadata();
        ParquetMetadata parquetMetadata = new ParquetMetadata(fileMetaData, new ParquetDataSourceId(path.toString()));
        return new DataFileInfo(this.relativeFilePath, this.getWrittenBytes(), this.creationTime, this.dataFileType, this.partitionValues, DeltaLakeWriter.readStatistics(parquetMetadata, this.columnHandles, this.rowCount), Optional.empty());
    }

    public static DeltaLakeJsonFileStatistics readStatistics(ParquetMetadata parquetMetadata, List<DeltaLakeColumnHandle> columnHandles, long rowCount) throws IOException {
        Map typeForColumn = (Map)columnHandles.stream().collect(ImmutableMap.toImmutableMap(column -> column.basePhysicalColumnName().toLowerCase(Locale.ENGLISH), DeltaLakeColumnHandle::basePhysicalType));
        ImmutableMultimap.Builder metadataForColumn = ImmutableMultimap.builder();
        for (BlockMetadata blockMetaData : parquetMetadata.getBlocks()) {
            for (ColumnChunkMetadata columnChunkMetaData : blockMetaData.columns()) {
                if (columnChunkMetaData.getPath().size() != 1) continue;
                String columnName = (String)Iterables.getOnlyElement((Iterable)columnChunkMetaData.getPath());
                metadataForColumn.put((Object)columnName, (Object)columnChunkMetaData);
            }
        }
        return DeltaLakeWriter.mergeStats((Multimap<String, ColumnChunkMetadata>)metadataForColumn.build(), typeForColumn, rowCount);
    }

    @VisibleForTesting
    static DeltaLakeJsonFileStatistics mergeStats(Multimap<String, ColumnChunkMetadata> metadataForColumn, Map<String, Type> typeForColumn, long rowCount) {
        Map statsForColumn = (Map)metadataForColumn.keySet().stream().collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), key -> DeltaLakeWriter.mergeMetadataList(metadataForColumn.get(key))));
        Map nullCount = (Map)statsForColumn.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Statistics)((Optional)entry.getValue()).get()).getNumNulls()));
        return new DeltaLakeJsonFileStatistics(Optional.of(rowCount), Optional.of(DeltaLakeParquetStatisticsUtils.jsonEncodeMin(statsForColumn, typeForColumn)), Optional.of(DeltaLakeParquetStatisticsUtils.jsonEncodeMax(statsForColumn, typeForColumn)), Optional.of(nullCount));
    }

    private static Optional<Statistics<?>> mergeMetadataList(Collection<ColumnChunkMetadata> metadataList) {
        if (DeltaLakeParquetStatisticsUtils.hasInvalidStatistics(metadataList)) {
            return Optional.empty();
        }
        return metadataList.stream().map(ColumnChunkMetadata::getStatistics).reduce((statsA, statsB) -> {
            statsA.mergeStatistics(statsB);
            return statsA;
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileWriter", (Object)this.fileWriter).add("relativeFilePath", (Object)this.relativeFilePath).add("partitionValues", this.partitionValues).add("creationTime", this.creationTime).add("rowCount", this.rowCount).add("inputSizeInBytes", this.inputSizeInBytes).toString();
    }

    private static Optional<Function<Block, Block>> createCoercer(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return DeltaLakeWriter.createCoercer(arrayType.getElementType()).map(ArrayCoercer::new);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return Optional.of(new MapCoercer(mapType));
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return Optional.of(new RowCoercer(rowType));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return Optional.of(new TimestampCoercer());
        }
        return Optional.empty();
    }

    private static final class CoercionLazyBlockLoader
    implements LazyBlockLoader {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public Block load() {
            Preconditions.checkState((this.block != null ? 1 : 0) != 0, (Object)"Already loaded");
            Block loaded = this.coercer.apply(this.block.getLoadedBlock());
            this.block = null;
            return loaded;
        }
    }

    private static class MapCoercer
    implements Function<Block, Block> {
        private final MapType mapType;
        private final Optional<Function<Block, Block>> keyCoercer;
        private final Optional<Function<Block, Block>> valueCoercer;

        public MapCoercer(MapType mapType) {
            this.mapType = Objects.requireNonNull(mapType, "mapType is null");
            this.keyCoercer = DeltaLakeWriter.createCoercer(mapType.getKeyType());
            this.valueCoercer = DeltaLakeWriter.createCoercer(mapType.getValueType());
        }

        @Override
        public Block apply(Block block) {
            ColumnarMap mapBlock = ColumnarMap.toColumnarMap((Block)block);
            Block keysBlock = this.keyCoercer.isEmpty() ? mapBlock.getKeysBlock() : this.keyCoercer.get().apply(mapBlock.getKeysBlock());
            Block valuesBlock = this.valueCoercer.isEmpty() ? mapBlock.getValuesBlock() : this.valueCoercer.get().apply(mapBlock.getValuesBlock());
            boolean[] valueIsNull = new boolean[mapBlock.getPositionCount()];
            int[] offsets = new int[mapBlock.getPositionCount() + 1];
            for (int i = 0; i < mapBlock.getPositionCount(); ++i) {
                valueIsNull[i] = mapBlock.isNull(i);
                offsets[i + 1] = offsets[i] + mapBlock.getEntryCount(i);
            }
            return this.mapType.createBlockFromKeyValue(Optional.of(valueIsNull), offsets, keysBlock, valuesBlock);
        }
    }

    private static class RowCoercer
    implements Function<Block, Block> {
        private final List<Optional<Function<Block, Block>>> fieldCoercers;

        public RowCoercer(RowType rowType) {
            this.fieldCoercers = (List)rowType.getTypeParameters().stream().map(DeltaLakeWriter::createCoercer).collect(ImmutableList.toImmutableList());
        }

        @Override
        public Block apply(Block block) {
            if ((block = block.getLoadedBlock()) instanceof RunLengthEncodedBlock) {
                RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block;
                RowBlock rowBlock = (RowBlock)runLengthEncodedBlock.getValue();
                RowBlock newRowBlock = RowBlock.fromNotNullSuppressedFieldBlocks((int)1, rowBlock.isNull(0) ? Optional.of(new boolean[]{true}) : Optional.empty(), (Block[])this.coerceFields(rowBlock.getFieldBlocks()));
                return RunLengthEncodedBlock.create((Block)newRowBlock, (int)runLengthEncodedBlock.getPositionCount());
            }
            if (block instanceof DictionaryBlock) {
                DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
                RowBlock rowBlock = (RowBlock)dictionaryBlock.getDictionary();
                List<Block> fieldBlocks = rowBlock.getFieldBlocks().stream().map(arg_0 -> ((DictionaryBlock)dictionaryBlock).createProjection(arg_0)).toList();
                return RowBlock.fromNotNullSuppressedFieldBlocks((int)dictionaryBlock.getPositionCount(), RowCoercer.getNulls((Block)dictionaryBlock), (Block[])this.coerceFields(fieldBlocks));
            }
            RowBlock rowBlock = (RowBlock)block;
            return RowBlock.fromNotNullSuppressedFieldBlocks((int)rowBlock.getPositionCount(), RowCoercer.getNulls((Block)rowBlock), (Block[])this.coerceFields(rowBlock.getFieldBlocks()));
        }

        private static Optional<boolean[]> getNulls(Block rowBlock) {
            if (!rowBlock.mayHaveNull()) {
                return Optional.empty();
            }
            boolean[] valueIsNull = new boolean[rowBlock.getPositionCount()];
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                valueIsNull[i] = rowBlock.isNull(i);
            }
            return Optional.of(valueIsNull);
        }

        private Block[] coerceFields(List<Block> fields) {
            Preconditions.checkArgument((fields.size() == this.fieldCoercers.size() ? 1 : 0) != 0);
            Block[] newFields = new Block[this.fieldCoercers.size()];
            for (int i = 0; i < this.fieldCoercers.size(); ++i) {
                Optional<Function<Block, Block>> coercer = this.fieldCoercers.get(i);
                Block fieldBlock = fields.get(i);
                newFields[i] = coercer.isPresent() ? coercer.get().apply(fieldBlock) : fieldBlock;
            }
            return newFields;
        }
    }

    private static class TimestampCoercer
    implements Function<Block, Block> {
        private TimestampCoercer() {
        }

        @Override
        public Block apply(Block block) {
            int positionCount = block.getPositionCount();
            long[] values = new long[positionCount];
            boolean mayHaveNulls = block.mayHaveNull();
            boolean[] valueIsNull = mayHaveNulls ? new boolean[positionCount] : null;
            for (int position = 0; position < positionCount; ++position) {
                if (mayHaveNulls && block.isNull(position)) {
                    valueIsNull[position] = true;
                    continue;
                }
                values[position] = TimeUnit.MILLISECONDS.toMicros(DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong(block, position)));
            }
            return new LongArrayBlock(positionCount, Optional.ofNullable(valueIsNull), values);
        }
    }

    private static class ArrayCoercer
    implements Function<Block, Block> {
        private final Function<Block, Block> elementCoercer;

        public ArrayCoercer(Function<Block, Block> elementCoercer) {
            this.elementCoercer = Objects.requireNonNull(elementCoercer, "elementCoercer is null");
        }

        @Override
        public Block apply(Block block) {
            ColumnarArray arrayBlock = ColumnarArray.toColumnarArray((Block)block);
            Block elementsBlock = this.elementCoercer.apply(arrayBlock.getElementsBlock());
            boolean[] valueIsNull = new boolean[arrayBlock.getPositionCount()];
            int[] offsets = new int[arrayBlock.getPositionCount() + 1];
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                valueIsNull[i] = arrayBlock.isNull(i);
                offsets[i + 1] = offsets[i] + arrayBlock.getLength(i);
            }
            return ArrayBlock.fromElementBlock((int)arrayBlock.getPositionCount(), Optional.of(valueIsNull), (int[])offsets, (Block)elementsBlock);
        }
    }
}

