/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.cache;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import java.util.Optional;

public class DeltaLakeCacheKeyProvider
implements CacheKeyProvider {
    private final boolean deltaLogCacheDisabled;

    @Inject
    public DeltaLakeCacheKeyProvider(DeltaLakeConfig deltaLakeConfig) {
        this.deltaLogCacheDisabled = deltaLakeConfig.isDeltaLogFileSystemCacheDisabled();
    }

    public Optional<String> getCacheKey(TrinoInputFile inputFile) {
        String path = inputFile.location().path();
        if (this.deltaLogCacheDisabled && path.contains("/_delta_log/")) {
            return Optional.empty();
        }
        if (path.endsWith(".trinoSchema") || path.contains("/.trinoPermissions/")) {
            return Optional.empty();
        }
        if (path.endsWith("/_delta_log/_last_checkpoint") || path.contains("/_delta_log/_trino_meta/") || path.contains("/_delta_log/_starburst_meta/")) {
            return Optional.empty();
        }
        return Optional.of(path);
    }
}

