/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import com.google.common.base.MoreObjects;
import io.trino.plugin.deltalake.expression.Literal;
import io.trino.plugin.deltalake.expression.SparkExpressionTreeVisitor;
import java.util.Objects;

public class StringLiteral
extends Literal {
    private final String value;

    public StringLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(SparkExpressionTreeVisitor<R, C> visitor, C context) {
        return visitor.visitStringLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLiteral that = (StringLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.value).toString();
    }
}

