/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.plugin.deltalake.metastore.file.DeltaLakeFileMetastoreModule;
import io.trino.plugin.deltalake.metastore.glue.DeltaLakeGlueMetastoreModule;
import io.trino.plugin.deltalake.metastore.glue.v1.DeltaLakeGlueV1MetastoreModule;
import io.trino.plugin.deltalake.metastore.thrift.DeltaLakeThriftMetastoreModule;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.CachingHiveMetastoreModule;
import io.trino.plugin.hive.metastore.MetastoreTypeConfig;

public class DeltaLakeMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(Key.get(Boolean.TYPE, HideDeltaLakeTables.class)).toInstance((Object)false);
        this.bindMetastoreModule("thrift", (Module)new DeltaLakeThriftMetastoreModule());
        this.bindMetastoreModule("file", (Module)new DeltaLakeFileMetastoreModule());
        this.bindMetastoreModule("glue", (Module)new DeltaLakeGlueMetastoreModule());
        this.bindMetastoreModule("glue-v1", (Module)new DeltaLakeGlueV1MetastoreModule());
        this.install((Module)new CachingHiveMetastoreModule());
    }

    private void bindMetastoreModule(String name, Module module) {
        this.install(ConditionalModule.conditionalModule(MetastoreTypeConfig.class, metastore -> name.equalsIgnoreCase(metastore.getMetastoreType()), (Module)module));
    }
}

