/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoOptional;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.deltalake.AllowDeltaLakeManagedTableRename;
import io.trino.plugin.deltalake.MaxTableParameterLength;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperationsProvider;
import io.trino.plugin.deltalake.metastore.glue.DeltaLakeGlueMetastoreConfig;
import io.trino.plugin.deltalake.metastore.glue.DeltaLakeGlueMetastoreTableOperationsProvider;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreModule;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import java.util.EnumSet;
import java.util.Set;
import org.weakref.jmx.guice.ExportBinder;

public class DeltaLakeGlueMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(DeltaLakeGlueMetastoreConfig.class);
        this.install((Module)new GlueMetastoreModule());
        binder.bind(GlueMetastoreStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(GlueMetastoreStats.class).withGeneratedName();
        binder.bind(DeltaLakeTableOperationsProvider.class).to(DeltaLakeGlueMetastoreTableOperationsProvider.class).in(Scopes.SINGLETON);
        binder.bind(Key.get(Boolean.TYPE, AllowDeltaLakeManagedTableRename.class)).toInstance((Object)true);
        binder.bind(Key.get(Integer.TYPE, MaxTableParameterLength.class)).toInstance((Object)512000);
    }

    @ProvidesIntoOptional(value=ProvidesIntoOptional.Type.ACTUAL)
    @Singleton
    public static Set<GlueHiveMetastore.TableKind> getTableKinds(DeltaLakeGlueMetastoreConfig config) {
        if (config.isHideNonDeltaLakeTables()) {
            return EnumSet.of(GlueHiveMetastore.TableKind.DELTA);
        }
        return EnumSet.allOf(GlueHiveMetastore.TableKind.class);
    }
}

