/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue.v1;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableMetadataScheduler;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperations;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.v1.GlueInputConverter;
import io.trino.plugin.hive.metastore.glue.v1.GlueToTrinoConverter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeGlueV1MetastoreTableOperations
implements DeltaLakeTableOperations {
    private final AWSGlueAsync glueClient;
    private final GlueMetastoreStats stats;

    public DeltaLakeGlueV1MetastoreTableOperations(AWSGlueAsync glueClient, GlueMetastoreStats stats) {
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public void commitToExistingTable(SchemaTableName schemaTableName, long version, String schemaString, Optional<String> tableComment) {
        Table currentTable;
        GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(schemaTableName.getSchemaName()).withName(schemaTableName.getTableName());
        try {
            currentTable = this.glueClient.getTable(getTableRequest).getTable();
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(schemaTableName);
        }
        String glueVersionId = currentTable.getVersionId();
        TableInput tableInput = GlueInputConverter.convertGlueTableToTableInput((Table)currentTable);
        ImmutableMap.Builder parameters = ImmutableMap.builder();
        parameters.putAll(GlueToTrinoConverter.getTableParameters((Table)currentTable));
        parameters.putAll(DeltaLakeTableMetadataScheduler.tableMetadataParameters(version, schemaString, tableComment));
        tableInput.withParameters((Map)parameters.buildKeepingLast());
        UpdateTableRequest updateTableRequest = new UpdateTableRequest().withDatabaseName(schemaTableName.getSchemaName()).withTableInput(tableInput).withVersionId(glueVersionId);
        this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(updateTableRequest));
    }
}

