/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import io.trino.hive.thrift.metastore.Table;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableMetadataScheduler;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperations;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeThriftMetastoreTableOperations
implements DeltaLakeTableOperations {
    private final ConnectorSession session;
    private final HiveMetastore metastore;
    private final ThriftMetastore thriftMetastore;

    public DeltaLakeThriftMetastoreTableOperations(ConnectorSession session, HiveMetastore metastore, ThriftMetastore thriftMetastore) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.thriftMetastore = Objects.requireNonNull(thriftMetastore, "thriftMetastore is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitToExistingTable(SchemaTableName schemaTableName, long version, String schemaString, Optional<String> tableComment) {
        long lockId = this.thriftMetastore.acquireTableExclusiveLock(new AcidTransactionOwner(this.session.getUser()), this.session.getQueryId(), schemaTableName.getSchemaName(), schemaTableName.getTableName());
        try {
            io.trino.metastore.Table currentTable = ThriftMetastoreUtil.fromMetastoreApiTable((Table)((Table)this.thriftMetastore.getTable(schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName))));
            ImmutableMap parameters = ImmutableMap.builder().putAll(currentTable.getParameters()).putAll(DeltaLakeTableMetadataScheduler.tableMetadataParameters(version, schemaString, tableComment)).buildKeepingLast();
            io.trino.metastore.Table updatedTable = currentTable.withParameters((Map)parameters);
            this.metastore.replaceTable(currentTable.getDatabaseName(), currentTable.getTableName(), updatedTable, MetastoreUtil.buildInitialPrivilegeSet((String)((String)currentTable.getOwner().orElseThrow())));
        }
        finally {
            this.thriftMetastore.releaseTableLock(lockId);
        }
    }
}

