/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.thrift;

import com.google.inject.Inject;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperations;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperationsProvider;
import io.trino.plugin.deltalake.metastore.thrift.DeltaLakeThriftMetastoreTableOperations;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeThriftMetastoreTableOperationsProvider
implements DeltaLakeTableOperationsProvider {
    private final HiveMetastoreFactory hiveMetastoreFactory;
    private final ThriftMetastoreFactory thriftMetastoreFactory;

    @Inject
    public DeltaLakeThriftMetastoreTableOperationsProvider(HiveMetastoreFactory hiveMetastoreFactory, ThriftMetastoreFactory thriftMetastoreFactory) {
        this.hiveMetastoreFactory = Objects.requireNonNull(hiveMetastoreFactory, "hiveMetastoreFactory is null");
        this.thriftMetastoreFactory = Objects.requireNonNull(thriftMetastoreFactory, "thriftMetastoreFactory is null");
    }

    @Override
    public DeltaLakeTableOperations createTableOperations(ConnectorSession session) {
        Optional<ConnectorIdentity> identity = Optional.of(session.getIdentity());
        return new DeltaLakeThriftMetastoreTableOperations(session, this.hiveMetastoreFactory.createMetastore(identity), this.thriftMetastoreFactory.createMetastore(identity));
    }
}

