/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record CheckpointMetadataEntry(long version, Optional<Map<String, String>> tags) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(CheckpointMetadataEntry.class);

    public CheckpointMetadataEntry {
        Preconditions.checkArgument((version > 0L ? 1 : 0) != 0, (String)"version is not positive: %s", (long)version);
        Objects.requireNonNull(tags, "tags is null");
        tags = tags.map(ImmutableMap::copyOf);
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + 8) + SizeOf.sizeOf(this.tags, tagsMap -> SizeOf.estimatedSizeOf((Map)tagsMap, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf));
    }
}

