/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;

public class MetadataEntry {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MetadataEntry.class);
    public static final String DELTA_CHECKPOINT_WRITE_STATS_AS_JSON_PROPERTY = "delta.checkpoint.writeStatsAsJson";
    public static final String DELTA_CHECKPOINT_WRITE_STATS_AS_STRUCT_PROPERTY = "delta.checkpoint.writeStatsAsStruct";
    public static final String DELTA_CHANGE_DATA_FEED_ENABLED_PROPERTY = "delta.enableChangeDataFeed";
    private static final String DELTA_CHECKPOINT_INTERVAL_PROPERTY = "delta.checkpointInterval";
    private final String id;
    private final String name;
    private final String description;
    private final Format format;
    private final String schemaString;
    private final List<String> partitionColumns;
    private final List<String> canonicalPartitionColumns;
    private final Map<String, String> configuration;
    private final long createdTime;

    @JsonCreator
    public MetadataEntry(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="format") Format format, @JsonProperty(value="schemaString") String schemaString, @JsonProperty(value="partitionColumns") List<String> partitionColumns, @JsonProperty(value="configuration") Map<String, String> configuration, @JsonProperty(value="createdTime") long createdTime) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.format = format;
        this.schemaString = schemaString;
        this.partitionColumns = partitionColumns;
        this.canonicalPartitionColumns = (List)partitionColumns.stream().map(value -> value.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        this.configuration = configuration;
        this.createdTime = createdTime;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public Format getFormat() {
        return this.format;
    }

    @JsonProperty
    public String getSchemaString() {
        return this.schemaString;
    }

    @JsonProperty(value="partitionColumns")
    public List<String> getOriginalPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonIgnore
    public List<String> getLowercasePartitionColumns() {
        return this.canonicalPartitionColumns;
    }

    @JsonProperty
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @JsonProperty
    public long getCreatedTime() {
        return this.createdTime;
    }

    @JsonIgnore
    public Optional<Long> getCheckpointInterval() {
        if (this.getConfiguration() == null) {
            return Optional.empty();
        }
        String value = this.getConfiguration().get(DELTA_CHECKPOINT_INTERVAL_PROPERTY);
        if (value == null) {
            return Optional.empty();
        }
        try {
            long tableCheckpointInterval = Long.parseLong(value);
            if (tableCheckpointInterval <= 0L) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("%s must be greater than 0", DELTA_CHECKPOINT_INTERVAL_PROPERTY));
            }
            return Optional.of(tableCheckpointInterval);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Invalid value for %s property: %s", DELTA_CHECKPOINT_INTERVAL_PROPERTY, value));
        }
    }

    public static Map<String, String> configurationForNewTable(Optional<Long> checkpointInterval, Optional<Boolean> changeDataFeedEnabled, boolean deletionVectorsEnabled, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, OptionalInt maxFieldId) {
        ImmutableMap.Builder configurationMapBuilder = ImmutableMap.builder();
        checkpointInterval.ifPresent(interval -> configurationMapBuilder.put((Object)DELTA_CHECKPOINT_INTERVAL_PROPERTY, (Object)String.valueOf(interval)));
        changeDataFeedEnabled.ifPresent(enabled -> configurationMapBuilder.put((Object)DELTA_CHANGE_DATA_FEED_ENABLED_PROPERTY, (Object)String.valueOf(enabled)));
        configurationMapBuilder.put((Object)"delta.enableDeletionVectors", (Object)Boolean.toString(deletionVectorsEnabled));
        switch (columnMappingMode) {
            case NONE: {
                break;
            }
            case ID: 
            case NAME: {
                configurationMapBuilder.put((Object)"delta.columnMapping.mode", (Object)columnMappingMode.name().toLowerCase(Locale.ENGLISH));
                configurationMapBuilder.put((Object)"delta.columnMapping.maxColumnId", (Object)String.valueOf(maxFieldId.orElseThrow()));
                break;
            }
            case UNKNOWN: {
                throw new UnsupportedOperationException();
            }
        }
        return configurationMapBuilder.buildOrThrow();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataEntry that = (MetadataEntry)o;
        return this.createdTime == that.createdTime && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.format, that.format) && Objects.equals(this.schemaString, that.schemaString) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals(this.canonicalPartitionColumns, that.canonicalPartitionColumns) && Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.format, this.schemaString, this.partitionColumns, this.canonicalPartitionColumns, this.configuration, this.createdTime);
    }

    public String toString() {
        return String.format("MetadataEntry{id=%s, name=%s, description=%s, format=%s, schemaString=%s, partitionColumns=%s, configuration=%s, createdTime=%d}", this.id, this.name, this.description, this.format, this.schemaString, this.partitionColumns, this.configuration, this.createdTime);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.id) + SizeOf.estimatedSizeOf((String)this.name) + SizeOf.estimatedSizeOf((String)this.description) + this.format.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.schemaString) + SizeOf.estimatedSizeOf(this.partitionColumns, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.canonicalPartitionColumns, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf(this.configuration, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf) + 8L;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetadataEntry metadataEntry) {
        return new Builder(metadataEntry);
    }

    public record Format(String provider, Map<String, String> options) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(Format.class);

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.provider) + SizeOf.estimatedSizeOf(this.options, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf);
        }
    }

    public static class Builder {
        private String id = UUID.randomUUID().toString();
        private String name;
        private Optional<String> description = Optional.empty();
        private Format format = new Format("parquet", (Map<String, String>)ImmutableMap.of());
        private String schemaString;
        private List<String> partitionColumns = ImmutableList.of();
        private Map<String, String> configuration;
        private long createdTime;

        private Builder() {
        }

        private Builder(MetadataEntry metadataEntry) {
            Objects.requireNonNull(metadataEntry, "metadataEntry is null");
            this.id = metadataEntry.id;
            this.name = metadataEntry.name;
            this.description = Optional.ofNullable(metadataEntry.description);
            this.format = metadataEntry.format;
            this.schemaString = metadataEntry.schemaString;
            this.partitionColumns = ImmutableList.copyOf(metadataEntry.partitionColumns);
            this.configuration = ImmutableMap.copyOf(metadataEntry.configuration);
            this.createdTime = metadataEntry.createdTime;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDescription(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder setSchemaString(String schemaString) {
            this.schemaString = schemaString;
            return this;
        }

        public Builder setPartitionColumns(List<String> partitionColumns) {
            this.partitionColumns = ImmutableList.copyOf(partitionColumns);
            return this;
        }

        public Builder setConfiguration(Map<String, String> configuration) {
            this.configuration = ImmutableMap.copyOf(configuration);
            return this;
        }

        public Builder setCreatedTime(long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public MetadataEntry build() {
            return new MetadataEntry(this.id, this.name, this.description.orElse(null), this.format, this.schemaString, this.partitionColumns, this.configuration, this.createdTime);
        }
    }
}

