/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record SidecarEntry(String path, long sizeInBytes, long modificationTime, Optional<Map<String, String>> tags) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SidecarEntry.class);

    public SidecarEntry {
        Preconditions.checkArgument((sizeInBytes > 0L ? 1 : 0) != 0, (String)"sizeInBytes is not positive: %s", (long)sizeInBytes);
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(tags, "tags is null");
        tags = tags.map(ImmutableMap::copyOf);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + 8L + 8L + SizeOf.sizeOf(this.tags, tagsMap -> SizeOf.estimatedSizeOf((Map)tagsMap, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf));
    }
}

