/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class TableSnapshot {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TableSnapshot.class);
    private final Optional<LastCheckpoint> lastCheckpoint;
    private final SchemaTableName table;
    private final TransactionLogTail logTail;
    private final String tableLocation;
    private final ParquetReaderOptions parquetReaderOptions;
    private final DataSize transactionLogMaxCachedFileSize;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private final int domainCompactionThreshold;
    private Optional<MetadataEntry> cachedMetadata = Optional.empty();
    private Optional<ProtocolEntry> cachedProtocol = Optional.empty();

    private TableSnapshot(SchemaTableName table, Optional<LastCheckpoint> lastCheckpoint, TransactionLogTail logTail, String tableLocation, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled, int domainCompactionThreshold, DataSize transactionLogMaxCachedFileSize) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.lastCheckpoint = Objects.requireNonNull(lastCheckpoint, "lastCheckpoint is null");
        this.logTail = Objects.requireNonNull(logTail, "logTail is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        this.checkpointRowStatisticsWritingEnabled = checkpointRowStatisticsWritingEnabled;
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.transactionLogMaxCachedFileSize = Objects.requireNonNull(transactionLogMaxCachedFileSize, "transactionLogMaxCachedFileSize is null");
    }

    public static TableSnapshot load(SchemaTableName table, Optional<LastCheckpoint> lastCheckpoint, TrinoFileSystem fileSystem, String tableLocation, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled, int domainCompactionThreshold, DataSize transactionLogMaxCachedFileSize, Optional<Long> endVersion) throws IOException {
        Optional<Long> lastCheckpointVersion = lastCheckpoint.map(LastCheckpoint::version);
        TransactionLogTail transactionLogTail = TransactionLogTail.loadNewTail(fileSystem, tableLocation, lastCheckpointVersion, endVersion, transactionLogMaxCachedFileSize);
        return new TableSnapshot(table, lastCheckpoint, transactionLogTail, tableLocation, parquetReaderOptions, checkpointRowStatisticsWritingEnabled, domainCompactionThreshold, transactionLogMaxCachedFileSize);
    }

    public Optional<TableSnapshot> getUpdatedSnapshot(TrinoFileSystem fileSystem, Optional<Long> toVersion) throws IOException {
        long ourCheckpointVersion;
        Optional<LastCheckpoint> lastCheckpoint;
        if (toVersion.isEmpty() && (lastCheckpoint = TransactionLogParser.readLastCheckpoint(fileSystem, this.tableLocation)).isPresent() && (ourCheckpointVersion = this.getLastCheckpointVersion().orElse(0L).longValue()) != lastCheckpoint.get().version()) {
            return Optional.of(TableSnapshot.load(this.table, lastCheckpoint, fileSystem, this.tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold, this.transactionLogMaxCachedFileSize, Optional.empty()));
        }
        Optional<TransactionLogTail> updatedLogTail = this.logTail.getUpdatedTail(fileSystem, this.tableLocation, toVersion, this.transactionLogMaxCachedFileSize);
        return updatedLogTail.map(transactionLogTail -> new TableSnapshot(this.table, this.lastCheckpoint, (TransactionLogTail)transactionLogTail, this.tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold, this.transactionLogMaxCachedFileSize));
    }

    public long getVersion() {
        return this.logTail.getVersion();
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public Optional<MetadataEntry> getCachedMetadata() {
        return this.cachedMetadata;
    }

    public Optional<ProtocolEntry> getCachedProtocol() {
        return this.cachedProtocol;
    }

    public String getTableLocation() {
        return this.tableLocation;
    }

    public void setCachedMetadata(Optional<MetadataEntry> cachedMetadata) {
        this.cachedMetadata = cachedMetadata;
    }

    public void setCachedProtocol(Optional<ProtocolEntry> cachedProtocol) {
        this.cachedProtocol = cachedProtocol;
    }

    public List<DeltaLakeTransactionLogEntry> getJsonTransactionLogEntries(TrinoFileSystem fileSystem) {
        return this.logTail.getFileEntries(fileSystem);
    }

    public List<Transaction> getTransactions() {
        return this.logTail.getTransactions();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.lastCheckpoint, LastCheckpoint::getRetainedSizeInBytes) + this.table.getRetainedSizeInBytes() + this.logTail.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.tableLocation) + SizeOf.sizeOf(this.cachedMetadata, MetadataEntry::getRetainedSizeInBytes) + SizeOf.sizeOf(this.cachedProtocol, ProtocolEntry::getRetainedSizeInBytes);
    }

    public Stream<DeltaLakeTransactionLogEntry> getCheckpointTransactionLogEntries(ConnectorSession session, Set<CheckpointEntryIterator.EntryType> entryTypes, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats, Optional<MetadataAndProtocolEntry> metadataAndProtocol, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter) throws IOException {
        if (this.lastCheckpoint.isEmpty()) {
            return Stream.empty();
        }
        LastCheckpoint checkpoint = this.lastCheckpoint.get();
        if (entryTypes.contains((Object)CheckpointEntryIterator.EntryType.ADD)) {
            Preconditions.checkState((boolean)metadataAndProtocol.isPresent(), (Object)"metadata and protocol information is needed to process the add log entries");
        }
        return this.getCheckpointPartPaths(checkpoint).stream().map(arg_0 -> ((TrinoFileSystem)fileSystem).newInputFile(arg_0)).flatMap(checkpointFile -> this.getCheckpointTransactionLogEntries(session, fileSystem, entryTypes, metadataAndProtocol.map(MetadataAndProtocolEntry::metadataEntry), metadataAndProtocol.map(MetadataAndProtocolEntry::protocolEntry), checkpointSchemaManager, typeManager, stats, checkpoint, (TrinoInputFile)checkpointFile, partitionConstraint, addStatsMinMaxColumnFilter));
    }

    public Optional<Long> getLastCheckpointVersion() {
        return this.lastCheckpoint.map(LastCheckpoint::version);
    }

    private Stream<DeltaLakeTransactionLogEntry> getCheckpointTransactionLogEntries(ConnectorSession session, TrinoFileSystem fileSystem, Set<CheckpointEntryIterator.EntryType> entryTypes, Optional<MetadataEntry> metadataEntry, Optional<ProtocolEntry> protocolEntry, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, FileFormatDataSourceStats stats, LastCheckpoint checkpoint, TrinoInputFile checkpointFile, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter) {
        long fileSize;
        try {
            fileSize = checkpointFile.length();
        }
        catch (FileNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("%s mentions a non-existent checkpoint file for table: %s", checkpoint, this.table));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, String.format("Unexpected IO exception occurred while retrieving the length of the file: %s for the table %s", checkpoint, this.table), (Throwable)e);
        }
        if (checkpoint.v2Checkpoint().isPresent()) {
            return this.getV2CheckpointTransactionLogEntriesFrom(session, entryTypes, metadataEntry, protocolEntry, checkpointSchemaManager, typeManager, stats, checkpoint, checkpointFile, partitionConstraint, addStatsMinMaxColumnFilter, fileSystem, fileSize);
        }
        CheckpointEntryIterator checkpointEntryIterator = new CheckpointEntryIterator(checkpointFile, session, fileSize, checkpointSchemaManager, typeManager, entryTypes, metadataEntry, protocolEntry, stats, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold, partitionConstraint, addStatsMinMaxColumnFilter);
        return (Stream)Streams.stream((Iterator)((Object)checkpointEntryIterator)).onClose(checkpointEntryIterator::close);
    }

    private Stream<DeltaLakeTransactionLogEntry> getV2CheckpointTransactionLogEntriesFrom(ConnectorSession session, Set<CheckpointEntryIterator.EntryType> entryTypes, Optional<MetadataEntry> metadataEntry, Optional<ProtocolEntry> protocolEntry, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, FileFormatDataSourceStats stats, LastCheckpoint checkpoint, TrinoInputFile checkpointFile, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter, TrinoFileSystem fileSystem, long fileSize) {
        return this.getV2CheckpointEntries(session, entryTypes, metadataEntry, protocolEntry, checkpointSchemaManager, typeManager, stats, checkpoint, checkpointFile, partitionConstraint, addStatsMinMaxColumnFilter, fileSystem, fileSize).mapMulti((entry, builder) -> {
            Sets.SetView dataEntryTypes = Sets.intersection((Set)entryTypes, Set.of(CheckpointEntryIterator.EntryType.ADD, CheckpointEntryIterator.EntryType.REMOVE));
            if (entry.getSidecar() == null || dataEntryTypes.isEmpty()) {
                builder.accept(entry);
                return;
            }
            Location sidecar = checkpointFile.location().sibling("_sidecars").appendPath(entry.getSidecar().path());
            CheckpointEntryIterator iterator = new CheckpointEntryIterator(fileSystem.newInputFile(sidecar), session, fileSize, checkpointSchemaManager, typeManager, (Set<CheckpointEntryIterator.EntryType>)dataEntryTypes, metadataEntry, protocolEntry, stats, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold, partitionConstraint, addStatsMinMaxColumnFilter);
            ((Stream)Streams.stream((Iterator)((Object)iterator)).onClose(iterator::close)).forEach(builder);
        });
    }

    private Stream<DeltaLakeTransactionLogEntry> getV2CheckpointEntries(ConnectorSession session, Set<CheckpointEntryIterator.EntryType> entryTypes, Optional<MetadataEntry> metadataEntry, Optional<ProtocolEntry> protocolEntry, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, FileFormatDataSourceStats stats, LastCheckpoint checkpoint, TrinoInputFile checkpointFile, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Optional<Predicate<String>> addStatsMinMaxColumnFilter, TrinoFileSystem fileSystem, long fileSize) {
        if (checkpointFile.location().fileName().endsWith(".json")) {
            try {
                return TransactionLogTail.getEntriesFromJson(checkpoint.version(), checkpointFile, this.transactionLogMaxCachedFileSize).stream().flatMap(logEntries -> logEntries.getEntries(fileSystem));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, String.format("Unexpected IO exception occurred while reading the entries of the file: %s for the table %s", checkpoint, this.table), (Throwable)e);
            }
        }
        if (checkpointFile.location().fileName().endsWith(".parquet")) {
            CheckpointEntryIterator checkpointEntryIterator = new CheckpointEntryIterator(fileSystem.newInputFile(checkpointFile.location()), session, fileSize, checkpointSchemaManager, typeManager, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.builder().addAll(entryTypes).add((Object)CheckpointEntryIterator.EntryType.SIDECAR).build(), metadataEntry, protocolEntry, stats, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold, partitionConstraint, addStatsMinMaxColumnFilter);
            return (Stream)Streams.stream((Iterator)((Object)checkpointEntryIterator)).onClose(checkpointEntryIterator::close);
        }
        throw new IllegalArgumentException("Unsupported v2 checkpoint file format: " + String.valueOf(checkpointFile.location()));
    }

    private List<Location> getCheckpointPartPaths(LastCheckpoint checkpoint) {
        Location transactionLogDir = Location.of((String)TransactionLogUtil.getTransactionLogDir(this.tableLocation));
        ImmutableList.Builder paths = ImmutableList.builder();
        if (checkpoint.v2Checkpoint().isPresent()) {
            Verify.verify((boolean)checkpoint.parts().isEmpty(), (String)"v2 checkpoint should not have multi-part checkpoints", (Object[])new Object[0]);
            paths.add((Object)transactionLogDir.appendPath(checkpoint.v2Checkpoint().get().path()));
        } else if (checkpoint.parts().isEmpty()) {
            paths.add((Object)transactionLogDir.appendPath("%020d.checkpoint.parquet".formatted(checkpoint.version())));
        } else {
            int partsCount = checkpoint.parts().get();
            for (int i = 1; i <= partsCount; ++i) {
                paths.add((Object)transactionLogDir.appendPath("%020d.checkpoint.%010d.%010d.parquet".formatted(checkpoint.version(), i, partsCount)));
            }
        }
        return paths.build();
    }

    public record MetadataAndProtocolEntry(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        public MetadataAndProtocolEntry {
            Objects.requireNonNull(metadataEntry, "metadataEntry is null");
            Objects.requireNonNull(protocolEntry, "protocolEntry is null");
        }
    }
}

