/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.transactionlog.TransactionLogEntries;
import java.util.Objects;

public record Transaction(long transactionId, TransactionLogEntries transactionEntries) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Transaction.class);

    public Transaction {
        Preconditions.checkArgument((transactionId >= 0L ? 1 : 0) != 0, (Object)"transactionId must be >= 0");
        Objects.requireNonNull(transactionEntries, "transactionEntries is null");
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + 8) + this.transactionEntries.getRetainedSizeInBytes();
    }
}

