/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.cache.CacheStatsMBean;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CanonicalColumnName;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeDataFileCacheEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.MissingTransactionLogException;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogEntries;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.V2Checkpoint;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.plugin.deltalake.transactionlog.checkpoint.MetadataAndProtocolEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TransactionLogAccess {
    private static final Pattern CLASSIC_CHECKPOINT = Pattern.compile("(\\d*)\\.checkpoint\\.parquet");
    private static final Pattern MULTI_PART_CHECKPOINT = Pattern.compile("(\\d*)\\.checkpoint\\.(\\d*)\\.(\\d*)\\.parquet");
    private static final Pattern V2_CHECKPOINT = Pattern.compile("(\\d*)\\.checkpoint\\.[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}\\.(json|parquet)");
    private final TypeManager typeManager;
    private final CheckpointSchemaManager checkpointSchemaManager;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final ParquetReaderOptions parquetReaderOptions;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private final int domainCompactionThreshold;
    private final DataSize transactionLogMaxCachedFileSize;
    private final Cache<TableLocation, TableSnapshot> tableSnapshots;
    private final Cache<TableVersion, DeltaLakeDataFileCacheEntry> activeDataFileCache;

    @Inject
    public TransactionLogAccess(TypeManager typeManager, CheckpointSchemaManager checkpointSchemaManager, DeltaLakeConfig deltaLakeConfig, FileFormatDataSourceStats fileFormatDataSourceStats, TrinoFileSystemFactory fileSystemFactory, ParquetReaderConfig parquetReaderConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checkpointSchemaManager = Objects.requireNonNull(checkpointSchemaManager, "checkpointSchemaManager is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions().withBloomFilter(false);
        this.checkpointRowStatisticsWritingEnabled = deltaLakeConfig.isCheckpointRowStatisticsWritingEnabled();
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.transactionLogMaxCachedFileSize = deltaLakeConfig.getTransactionLogMaxCachedFileSize();
        this.tableSnapshots = EvictableCacheBuilder.newBuilder().weigher((key, value) -> Ints.saturatedCast((long)(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes()))).maximumWeight(deltaLakeConfig.getMetadataCacheMaxRetainedSize().toBytes()).expireAfterWrite(deltaLakeConfig.getMetadataCacheTtl().toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().recordStats().build();
        this.activeDataFileCache = EvictableCacheBuilder.newBuilder().weigher((key, value) -> Ints.saturatedCast((long)(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes()))).maximumWeight(deltaLakeConfig.getDataFileCacheSize().toBytes()).expireAfterWrite(deltaLakeConfig.getDataFileCacheTtl().toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().recordStats().build();
    }

    @Managed
    @Nested
    public CacheStatsMBean getDataFileMetadataCacheStats() {
        return new CacheStatsMBean(this.activeDataFileCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getMetadataCacheStats() {
        return new CacheStatsMBean(this.tableSnapshots);
    }

    public TableSnapshot loadSnapshot(ConnectorSession session, SchemaTableName table, String tableLocation, Optional<Long> endVersion) throws IOException {
        TableSnapshot snapshot;
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        if (endVersion.isPresent()) {
            return this.loadSnapshotForTimeTravel(fileSystem, table, tableLocation, endVersion.get());
        }
        TableLocation cacheKey = new TableLocation(table, tableLocation);
        TableSnapshot cachedSnapshot = (TableSnapshot)this.tableSnapshots.getIfPresent((Object)cacheKey);
        if (cachedSnapshot == null) {
            try {
                Optional<LastCheckpoint> lastCheckpoint = TransactionLogParser.readLastCheckpoint(fileSystem, tableLocation);
                snapshot = (TableSnapshot)this.tableSnapshots.get((Object)cacheKey, () -> TableSnapshot.load(table, lastCheckpoint, fileSystem, tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold, this.transactionLogMaxCachedFileSize, endVersion));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e);
            }
        } else {
            Optional<TableSnapshot> updatedSnapshot = cachedSnapshot.getUpdatedSnapshot(fileSystem, Optional.empty());
            if (updatedSnapshot.isPresent()) {
                snapshot = updatedSnapshot.get();
                this.tableSnapshots.asMap().replace(cacheKey, cachedSnapshot, snapshot);
            } else {
                snapshot = cachedSnapshot;
            }
        }
        return snapshot;
    }

    private TableSnapshot loadSnapshotForTimeTravel(TrinoFileSystem fileSystem, SchemaTableName table, String tableLocation, long endVersion) throws IOException {
        return TableSnapshot.load(table, TransactionLogAccess.findCheckpoint(fileSystem, tableLocation, endVersion), fileSystem, tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold, this.transactionLogMaxCachedFileSize, Optional.of(endVersion));
    }

    private static Optional<LastCheckpoint> findCheckpoint(TrinoFileSystem fileSystem, String tableLocation, long endVersion) {
        Optional<LastCheckpoint> lastCheckpoint = TransactionLogParser.readLastCheckpoint(fileSystem, tableLocation);
        if (lastCheckpoint.isPresent() && lastCheckpoint.get().version() <= endVersion) {
            return lastCheckpoint;
        }
        Optional<LastCheckpoint> latestCheckpoint = Optional.empty();
        Location transactionDirectory = Location.of((String)TransactionLogUtil.getTransactionLogDir(tableLocation));
        try {
            FileIterator files = fileSystem.listFiles(transactionDirectory);
            while (files.hasNext()) {
                FileEntry file = files.next();
                Optional<LastCheckpoint> checkpoint = TransactionLogAccess.extractCheckpointVersion(file);
                if (checkpoint.isEmpty()) continue;
                long version = checkpoint.get().version();
                if (version == endVersion) {
                    return checkpoint;
                }
                if (version > endVersion || latestCheckpoint.isPresent() && version < latestCheckpoint.get().version()) continue;
                latestCheckpoint = checkpoint;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return latestCheckpoint;
    }

    private static Optional<LastCheckpoint> extractCheckpointVersion(FileEntry file) {
        String fileName = file.location().fileName();
        Matcher classicCheckpoint = CLASSIC_CHECKPOINT.matcher(fileName);
        if (classicCheckpoint.matches()) {
            long version = Long.parseLong(classicCheckpoint.group(1));
            return Optional.of(new LastCheckpoint(version, file.length(), Optional.empty(), Optional.empty()));
        }
        Matcher multiPartCheckpoint = MULTI_PART_CHECKPOINT.matcher(fileName);
        if (multiPartCheckpoint.matches()) {
            long version = Long.parseLong(multiPartCheckpoint.group(1));
            int parts = Integer.parseInt(multiPartCheckpoint.group(3));
            return Optional.of(new LastCheckpoint(version, file.length(), Optional.of(parts), Optional.empty()));
        }
        Matcher v2Checkpoint = V2_CHECKPOINT.matcher(fileName);
        if (v2Checkpoint.matches()) {
            long version = Long.parseLong(v2Checkpoint.group(1));
            return Optional.of(new LastCheckpoint(version, file.length(), Optional.empty(), Optional.of(new V2Checkpoint(fileName))));
        }
        return Optional.empty();
    }

    public void flushCache() {
        this.tableSnapshots.invalidateAll();
        this.activeDataFileCache.invalidateAll();
    }

    public void invalidateCache(SchemaTableName schemaTableName, Optional<String> tableLocation) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        tableLocation.ifPresent(location -> {
            CacheUtils.invalidateAllIf(this.tableSnapshots, cacheKey -> cacheKey.location().equals(location));
            CacheUtils.invalidateAllIf(this.activeDataFileCache, cacheKey -> cacheKey.tableLocation().location().equals(location));
        });
        CacheUtils.invalidateAllIf(this.tableSnapshots, cacheKey -> cacheKey.tableName().equals((Object)schemaTableName));
        CacheUtils.invalidateAllIf(this.activeDataFileCache, cacheKey -> cacheKey.tableLocation().tableName().equals((Object)schemaTableName));
    }

    public MetadataEntry getMetadataEntry(ConnectorSession session, TableSnapshot tableSnapshot) {
        if (tableSnapshot.getCachedMetadata().isEmpty()) {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            try (Stream metadataEntries = this.getEntries(session, tableSnapshot, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.METADATA)), (checkpointStream, jsonTransactions) -> Stream.concat(checkpointStream.map(DeltaLakeTransactionLogEntry::getMetaData).filter(Objects::nonNull), jsonTransactions.stream().map(transaction -> transaction.transactionEntries().getMetadataAndProtocol(fileSystem)).filter(entry -> entry.metadata().isPresent()).map(entry -> entry.metadata().get())), fileSystem, this.fileFormatDataSourceStats);){
                tableSnapshot.setCachedMetadata(metadataEntries.reduce((first, second) -> second));
            }
        }
        return tableSnapshot.getCachedMetadata().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Metadata not found in transaction log for " + String.valueOf(tableSnapshot.getTable())));
    }

    public Stream<AddFileEntry> getActiveFiles(ConnectorSession session, TableSnapshot tableSnapshot, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Set<DeltaLakeColumnHandle> projectedColumns) {
        Set baseColumnNames = (Set)projectedColumns.stream().filter(DeltaLakeColumnHandle::isBaseColumn).map(DeltaLakeColumnHandle::columnName).collect(ImmutableSet.toImmutableSet());
        return this.getActiveFiles(session, tableSnapshot, metadataEntry, protocolEntry, partitionConstraint, baseColumnNames::contains);
    }

    public Stream<AddFileEntry> getActiveFiles(ConnectorSession session, TableSnapshot tableSnapshot, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Predicate<String> addStatsMinMaxColumnFilter) {
        try {
            if (DeltaLakeSessionProperties.isCheckpointFilteringEnabled(session)) {
                return this.loadActiveFiles(session, tableSnapshot, metadataEntry, protocolEntry, partitionConstraint, addStatsMinMaxColumnFilter);
            }
            TableVersion tableVersion = new TableVersion(new TableLocation(tableSnapshot.getTable(), tableSnapshot.getTableLocation()), tableSnapshot.getVersion());
            DeltaLakeDataFileCacheEntry cacheEntry = (DeltaLakeDataFileCacheEntry)this.activeDataFileCache.get((Object)tableVersion, () -> {
                List activeFiles;
                DeltaLakeDataFileCacheEntry oldCached = this.activeDataFileCache.asMap().keySet().stream().filter(key -> key.tableLocation().equals(tableVersion.tableLocation()) && key.version() < tableVersion.version()).flatMap(key -> Optional.ofNullable((DeltaLakeDataFileCacheEntry)this.activeDataFileCache.getIfPresent(key)).map(value -> Map.entry(key, value)).stream()).max(Comparator.comparing(entry -> ((TableVersion)entry.getKey()).version())).map(Map.Entry::getValue).orElse(null);
                if (oldCached != null) {
                    try {
                        List<DeltaLakeTransactionLogEntry> newEntries = this.getJsonEntries(oldCached.getVersion(), tableSnapshot.getVersion(), tableSnapshot, this.fileSystemFactory.create(session));
                        return oldCached.withUpdatesApplied(newEntries, tableSnapshot.getVersion());
                    }
                    catch (MissingTransactionLogException newEntries) {
                        // empty catch block
                    }
                }
                try (Stream<AddFileEntry> addFileEntryStream = this.loadActiveFiles(session, tableSnapshot, metadataEntry, protocolEntry, (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (Predicate<String>)Predicates.alwaysTrue());){
                    activeFiles = (List)addFileEntryStream.collect(ImmutableList.toImmutableList());
                }
                return new DeltaLakeDataFileCacheEntry(tableSnapshot.getVersion(), activeFiles);
            });
            return cacheEntry.getActiveFiles().stream();
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Failed accessing transaction log for table: " + String.valueOf(tableSnapshot.getTable()), e);
        }
    }

    public Stream<AddFileEntry> loadActiveFiles(ConnectorSession session, TableSnapshot tableSnapshot, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TupleDomain<DeltaLakeColumnHandle> partitionConstraint, Predicate<String> addStatsMinMaxColumnFilter) {
        Stream<AddFileEntry> stream;
        block8: {
            List<Transaction> transactions = tableSnapshot.getTransactions();
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            Stream<DeltaLakeTransactionLogEntry> checkpointEntries = tableSnapshot.getCheckpointTransactionLogEntries(session, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.ADD)), this.checkpointSchemaManager, this.typeManager, fileSystem, this.fileFormatDataSourceStats, Optional.of(new TableSnapshot.MetadataAndProtocolEntry(metadataEntry, protocolEntry)), partitionConstraint, Optional.of(addStatsMinMaxColumnFilter));
            try {
                stream = this.activeAddEntries(checkpointEntries, transactions, fileSystem).filter(partitionConstraint.isAll() ? addAction -> true : addAction -> DeltaLakeSplitManager.partitionMatchesPredicate(addAction.getCanonicalPartitionValues(), (Map)partitionConstraint.getDomains().orElseThrow()));
                if (checkpointEntries == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (checkpointEntries != null) {
                        try {
                            checkpointEntries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error reading transaction log for " + String.valueOf(tableSnapshot.getTable()), (Throwable)e);
                }
            }
            checkpointEntries.close();
        }
        return stream;
    }

    public static List<DeltaLakeColumnMetadata> columnsWithStats(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TypeManager typeManager) {
        return TransactionLogAccess.columnsWithStats(DeltaLakeSchemaSupport.extractSchema(metadataEntry, protocolEntry, typeManager), metadataEntry.getOriginalPartitionColumns());
    }

    public static ImmutableList<DeltaLakeColumnMetadata> columnsWithStats(List<DeltaLakeColumnMetadata> schema, List<String> partitionColumns) {
        return (ImmutableList)schema.stream().filter(column -> !partitionColumns.contains(column.name())).filter(column -> {
            Type type = column.type();
            return !(type instanceof MapType) && !(type instanceof ArrayType) && !type.equals((Object)BooleanType.BOOLEAN) && !type.equals((Object)VarbinaryType.VARBINARY);
        }).collect(ImmutableList.toImmutableList());
    }

    private Stream<AddFileEntry> activeAddEntries(Stream<DeltaLakeTransactionLogEntry> checkpointEntries, List<Transaction> transactions, TrinoFileSystem fileSystem) {
        LinkedHashMap activeJsonEntries = new LinkedHashMap();
        HashSet removedFiles = new HashSet();
        transactions.forEach(transaction -> {
            LinkedHashMap addFilesInTransaction = new LinkedHashMap();
            HashSet removedFilesInTransaction = new HashSet();
            try (Stream<DeltaLakeTransactionLogEntry> entries = transaction.transactionEntries().getEntries(fileSystem);){
                entries.forEach(deltaLakeTransactionLogEntry -> {
                    if (deltaLakeTransactionLogEntry.getAdd() != null) {
                        AddFileEntry add = deltaLakeTransactionLogEntry.getAdd();
                        addFilesInTransaction.put(new FileEntryKey(add.getPath(), add.getDeletionVector().map(DeletionVectorEntry::uniqueId)), add);
                    } else if (deltaLakeTransactionLogEntry.getRemove() != null) {
                        RemoveFileEntry remove = deltaLakeTransactionLogEntry.getRemove();
                        removedFilesInTransaction.add(new FileEntryKey(remove.path(), remove.deletionVector().map(DeletionVectorEntry::uniqueId)));
                    }
                });
            }
            removedFiles.addAll(removedFilesInTransaction);
            removedFilesInTransaction.forEach(activeJsonEntries::remove);
            activeJsonEntries.putAll(addFilesInTransaction);
        });
        Stream<AddFileEntry> filteredCheckpointEntries = checkpointEntries.map(DeltaLakeTransactionLogEntry::getAdd).filter(Objects::nonNull).filter(addEntry -> {
            FileEntryKey key = new FileEntryKey(addEntry.getPath(), addEntry.getDeletionVector().map(DeletionVectorEntry::uniqueId));
            return !removedFiles.contains(key) && !activeJsonEntries.containsKey(key);
        });
        return Stream.concat(filteredCheckpointEntries, activeJsonEntries.values().stream());
    }

    public MetadataAndProtocolEntries getMetadataAndProtocolEntry(ConnectorSession session, TableSnapshot tableSnapshot) {
        if (tableSnapshot.getCachedMetadata().isEmpty() || tableSnapshot.getCachedProtocol().isEmpty()) {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            try (Stream<MetadataAndProtocolEntries> entries = this.getEntries(session, tableSnapshot, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.METADATA), (Object)((Object)CheckpointEntryIterator.EntryType.PROTOCOL)), (checkpointStream, jsonTransactions) -> Stream.concat(checkpointStream.filter(entry -> entry.getMetaData() != null || entry.getProtocol() != null).map(entry -> new MetadataAndProtocolEntries(entry.getMetaData(), entry.getProtocol())), jsonTransactions.stream().map(transaction -> transaction.transactionEntries().getMetadataAndProtocol(fileSystem))), fileSystem, this.fileFormatDataSourceStats);){
                Map logEntries = (Map)entries.flatMap(MetadataAndProtocolEntries::stream).collect(ImmutableMap.toImmutableMap(Object::getClass, Function.identity(), (object, second) -> second));
                tableSnapshot.setCachedMetadata(Optional.ofNullable((MetadataEntry)logEntries.get(MetadataEntry.class)));
                tableSnapshot.setCachedProtocol(Optional.ofNullable((ProtocolEntry)logEntries.get(ProtocolEntry.class)));
            }
        }
        return new MetadataAndProtocolEntries(tableSnapshot.getCachedMetadata(), tableSnapshot.getCachedProtocol());
    }

    public ProtocolEntry getProtocolEntry(ConnectorSession session, TableSnapshot tableSnapshot) {
        if (tableSnapshot.getCachedProtocol().isEmpty()) {
            try (Stream<ProtocolEntry> protocolEntries = this.getProtocolEntries(session, tableSnapshot);){
                tableSnapshot.setCachedProtocol(protocolEntries.reduce((first, second) -> second));
            }
        }
        return tableSnapshot.getCachedProtocol().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Protocol entry not found in transaction log for table " + String.valueOf(tableSnapshot.getTable())));
    }

    public Stream<ProtocolEntry> getProtocolEntries(ConnectorSession session, TableSnapshot tableSnapshot) {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        return this.getEntries(session, tableSnapshot, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.PROTOCOL)), (checkpointStream, jsonTransactions) -> Stream.concat(checkpointStream.map(DeltaLakeTransactionLogEntry::getProtocol).filter(Objects::nonNull), jsonTransactions.stream().map(transaction -> transaction.transactionEntries().getMetadataAndProtocol(fileSystem)).filter(entry -> entry.protocol().isPresent()).map(entry -> entry.protocol().get())), fileSystem, this.fileFormatDataSourceStats);
    }

    private <T> Stream<T> getEntries(ConnectorSession session, TableSnapshot tableSnapshot, Set<CheckpointEntryIterator.EntryType> entryTypes, BiFunction<Stream<DeltaLakeTransactionLogEntry>, List<Transaction>, Stream<T>> entryMapper, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats) {
        try {
            List<Transaction> transactions = tableSnapshot.getTransactions();
            Stream<DeltaLakeTransactionLogEntry> checkpointEntries = tableSnapshot.getCheckpointTransactionLogEntries(session, entryTypes, this.checkpointSchemaManager, this.typeManager, fileSystem, stats, Optional.empty(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.of(Predicates.alwaysTrue()));
            return entryMapper.apply(checkpointEntries, transactions);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error reading transaction log for " + String.valueOf(tableSnapshot.getTable()), (Throwable)e);
        }
    }

    public Stream<DeltaLakeTransactionLogEntry> getJsonEntries(TrinoFileSystem fileSystem, String transactionLogDir, List<Long> forVersions) {
        return forVersions.stream().flatMap(version -> {
            try {
                Optional<TransactionLogEntries> entriesFromJson = TransactionLogTail.getEntriesFromJson(version, transactionLogDir, fileSystem, this.transactionLogMaxCachedFileSize);
                return entriesFromJson.map(entries -> entries.getEntries(fileSystem)).orElseGet(() -> Stream.of(new DeltaLakeTransactionLogEntry[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public List<Long> getPastTableVersions(TrinoFileSystem fileSystem, String transactionLogDir, Instant startAt, long lastVersion) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (long version = lastVersion; version >= 0L; --version) {
            Location entryPath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, version);
            TrinoInputFile inputFile = fileSystem.newInputFile(entryPath);
            try {
                if (inputFile.lastModified().isBefore(startAt)) {
                    break;
                }
            }
            catch (FileNotFoundException e) {
                break;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            result.add((Object)version);
        }
        return result.build();
    }

    private List<DeltaLakeTransactionLogEntry> getJsonEntries(long startVersion, long endVersion, TableSnapshot tableSnapshot, TrinoFileSystem fileSystem) throws IOException {
        Optional<Long> lastCheckpointVersion = tableSnapshot.getLastCheckpointVersion();
        if (lastCheckpointVersion.isPresent() && startVersion < lastCheckpointVersion.get()) {
            return ImmutableList.builder().addAll(TransactionLogTail.loadNewTail(fileSystem, tableSnapshot.getTableLocation(), Optional.of(startVersion), lastCheckpointVersion, this.transactionLogMaxCachedFileSize).getFileEntries(fileSystem)).addAll(tableSnapshot.getJsonTransactionLogEntries(fileSystem)).build();
        }
        return TransactionLogTail.loadNewTail(fileSystem, tableSnapshot.getTableLocation(), Optional.of(startVersion), Optional.of(endVersion), this.transactionLogMaxCachedFileSize).getFileEntries(fileSystem);
    }

    public static String canonicalizeColumnName(String columnName) {
        return columnName.toLowerCase(Locale.ENGLISH);
    }

    public static <T> Map<CanonicalColumnName, T> toCanonicalNameKeyedMap(Map<String, T> map, Map<String, CanonicalColumnName> canonicalColumnNames) {
        return (Map)map.entrySet().stream().filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(entry -> Objects.requireNonNull((CanonicalColumnName)canonicalColumnNames.get(entry.getKey()), String.format("Did not find CanonicalColumnName for %s", entry.getKey())), Map.Entry::getValue));
    }

    @Deprecated
    public static <T> Map<String, T> toOriginalNameKeyedMap(Map<CanonicalColumnName, T> map) {
        return (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((CanonicalColumnName)entry.getKey()).getOriginalName(), Map.Entry::getValue));
    }

    private record TableLocation(SchemaTableName tableName, String location) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(TableLocation.class);

        TableLocation {
            Objects.requireNonNull(tableName, "tableName is null");
            Objects.requireNonNull(location, "location is null");
        }

        long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.tableName.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.location);
        }
    }

    private record TableVersion(TableLocation tableLocation, long version) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(TableVersion.class);

        TableVersion {
            Objects.requireNonNull(tableLocation, "tableLocation is null");
        }

        long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.tableLocation.getRetainedSizeInBytes();
        }
    }

    private record FileEntryKey(String path, Optional<String> deletionVectorId) {
    }
}

