/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.checkpoint.MetadataAndProtocolEntries;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class TransactionLogEntries {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TransactionLogEntries.class);
    private static final int JSON_LOG_ENTRY_READ_BUFFER_SIZE = 0x100000;
    private final long entryNumber;
    private final Location transactionLogFilePath;
    private final Optional<List<DeltaLakeTransactionLogEntry>> cachedEntries;

    public TransactionLogEntries(long entryNumber, TrinoInputFile inputFile, DataSize maxCachedFileSize) {
        this.entryNumber = entryNumber;
        this.transactionLogFilePath = inputFile.location();
        try {
            this.cachedEntries = inputFile.length() > maxCachedFileSize.toBytes() ? Optional.empty() : Optional.of(ImmutableList.copyOf((Iterator)((Object)new TransactionLogEntryIterator(entryNumber, inputFile))));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while reading from transaction entry iterator for the file %s".formatted(this.transactionLogFilePath));
        }
    }

    public Stream<DeltaLakeTransactionLogEntry> getEntries(TrinoFileSystem fileSystem) {
        if (this.cachedEntries.isPresent()) {
            return this.cachedEntries.get().stream();
        }
        TransactionLogEntryIterator iterator = new TransactionLogEntryIterator(this.entryNumber, fileSystem.newInputFile(this.transactionLogFilePath));
        return (Stream)Streams.stream((Iterator)((Object)iterator)).onClose(iterator::close);
    }

    public List<DeltaLakeTransactionLogEntry> getEntriesList(TrinoFileSystem fileSystem) {
        try (Stream<DeltaLakeTransactionLogEntry> jsonStream = this.getEntries(fileSystem);){
            List list = (List)jsonStream.collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    public MetadataAndProtocolEntries getMetadataAndProtocol(TrinoFileSystem fileSystem) {
        try (Stream<DeltaLakeTransactionLogEntry> logEntryStream = this.getEntries(fileSystem);){
            Optional<MetadataEntry> metadataEntry = Optional.empty();
            Optional<ProtocolEntry> protocolEntry = Optional.empty();
            Iterator it = logEntryStream.iterator();
            while (it.hasNext()) {
                DeltaLakeTransactionLogEntry transactionLogEntry = (DeltaLakeTransactionLogEntry)it.next();
                if (transactionLogEntry.getMetaData() != null) {
                    metadataEntry = Optional.of(transactionLogEntry.getMetaData());
                } else if (transactionLogEntry.getProtocol() != null) {
                    protocolEntry = Optional.of(transactionLogEntry.getProtocol());
                }
                if (!protocolEntry.isPresent() || !metadataEntry.isPresent()) continue;
                break;
            }
            MetadataAndProtocolEntries metadataAndProtocolEntries = new MetadataAndProtocolEntries(metadataEntry, protocolEntry);
            return metadataAndProtocolEntries;
        }
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + 8) + SizeOf.estimatedSizeOf((String)this.transactionLogFilePath.path()) + SizeOf.sizeOf(this.cachedEntries, entries -> SizeOf.estimatedSizeOf((List)entries, DeltaLakeTransactionLogEntry::getRetainedSizeInBytes));
    }

    private static final class TransactionLogEntryIterator
    extends AbstractIterator<DeltaLakeTransactionLogEntry> {
        private final long entryNumber;
        private final Location location;
        private final BufferedReader reader;

        public TransactionLogEntryIterator(long entryNumber, TrinoInputFile inputFile) {
            TrinoInputStream inputStream;
            this.entryNumber = entryNumber;
            this.location = inputFile.location();
            try {
                inputStream = inputFile.newStream();
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while initializing the transaction entry iterator for the file %s".formatted(inputFile.location()));
            }
            this.reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8), 0x100000);
        }

        protected DeltaLakeTransactionLogEntry computeNext() {
            String line;
            try {
                line = this.reader.readLine();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error while reading from transaction entry iterator for the file %s".formatted(this.location));
            }
            if (line == null) {
                this.close();
                return (DeltaLakeTransactionLogEntry)this.endOfData();
            }
            DeltaLakeTransactionLogEntry deltaLakeTransactionLogEntry = TransactionLogParser.parseJson(line);
            if (deltaLakeTransactionLogEntry.getCommitInfo() != null && deltaLakeTransactionLogEntry.getCommitInfo().version() == 0L) {
                deltaLakeTransactionLogEntry = deltaLakeTransactionLogEntry.withCommitInfo(deltaLakeTransactionLogEntry.getCommitInfo().withVersion(this.entryNumber));
            }
            return deltaLakeTransactionLogEntry;
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

