/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.math.LongMath;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;

public final class TransactionLogParser {
    private static final Logger log = Logger.get(TransactionLogParser.class);
    private static final LocalDate START_OF_MODERN_ERA_DATE = LocalDate.of(1900, 1, 2);
    public static final long START_OF_MODERN_ERA_EPOCH_DAY = START_OF_MODERN_ERA_DATE.toEpochDay();
    public static final long START_OF_MODERN_ERA_EPOCH_MICROS = LocalDateTime.of(START_OF_MODERN_ERA_DATE, LocalTime.MIN).toEpochSecond(ZoneOffset.UTC) * 1000000L;
    public static final String LAST_CHECKPOINT_FILENAME = "_last_checkpoint";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    public static final DateTimeFormatter PARTITION_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter(Locale.ENGLISH).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
    public static final DateTimeFormatter JSON_STATISTICS_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().optionalStart().appendLiteral('+').optionalEnd().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(Locale.ENGLISH).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);

    private TransactionLogParser() {
    }

    public static DeltaLakeTransactionLogEntry parseJson(String json) {
        if (json.endsWith("x")) {
            json = json.substring(0, json.length() - 1);
        }
        return (DeltaLakeTransactionLogEntry)JsonUtils.parseJson((ObjectMapper)OBJECT_MAPPER, (String)json, DeltaLakeTransactionLogEntry.class);
    }

    private static Object parseDecimal(DecimalType type, String valueString) {
        BigDecimal bigDecimal = new BigDecimal(valueString).setScale(type.getScale());
        if (type.isShort()) {
            return bigDecimal.unscaledValue().longValueExact();
        }
        return Decimals.valueOf((BigInteger)bigDecimal.unscaledValue());
    }

    @Nullable
    public static Object deserializePartitionValue(DeltaLakeColumnHandle column, Optional<String> valueString) {
        return valueString.map(value -> TransactionLogParser.deserializeColumnValue(column, value, TransactionLogParser::readPartitionTimestamp, TransactionLogParser::readPartitionTimestampWithZone)).orElse(null);
    }

    private static Long readPartitionTimestamp(String timestamp) {
        LocalDateTime localDateTime;
        try {
            localDateTime = LocalDateTime.parse(timestamp, PARTITION_TIMESTAMP_FORMATTER);
        }
        catch (DateTimeParseException ignored) {
            localDateTime = LocalDate.parse(timestamp).atTime(LocalTime.MIN);
        }
        return localDateTime.toEpochSecond(ZoneOffset.UTC) * 1000000L + LongMath.divide((long)localDateTime.getNano(), (long)1000L, (RoundingMode)RoundingMode.UNNECESSARY);
    }

    @VisibleForTesting
    static Long readPartitionTimestampWithZone(String timestamp) {
        ZonedDateTime zonedDateTime;
        try {
            zonedDateTime = LocalDateTime.parse(timestamp, PARTITION_TIMESTAMP_FORMATTER).atZone(ZoneOffset.UTC);
        }
        catch (DateTimeParseException dateTimeParseException) {
            zonedDateTime = ZonedDateTime.parse(timestamp, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
        return DateTimeEncoding.packDateTimeWithZone((long)zonedDateTime.toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    public static Object deserializeColumnValue(DeltaLakeColumnHandle column, String valueString, Function<String, Long> timestampReader, Function<String, Long> timestampWithZoneReader) {
        Verify.verify((boolean)column.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)column);
        Type type = column.baseType();
        try {
            if (type.equals((Object)BooleanType.BOOLEAN)) {
                if (valueString.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return false;
                }
            }
            if (type.equals((Object)IntegerType.INTEGER)) {
                return (long)Integer.parseInt(valueString);
            }
            if (type.equals((Object)SmallintType.SMALLINT)) {
                return (long)Integer.parseInt(valueString);
            }
            if (type.equals((Object)TinyintType.TINYINT)) {
                return (long)Integer.parseInt(valueString);
            }
            if (type.equals((Object)BigintType.BIGINT)) {
                return Long.parseLong(valueString);
            }
            if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                return TransactionLogParser.parseDecimal(decimalType, valueString);
            }
            if (type.equals((Object)RealType.REAL)) {
                return (long)Float.floatToRawIntBits(Float.parseFloat(valueString));
            }
            if (type.equals((Object)DoubleType.DOUBLE)) {
                return Double.parseDouble(valueString);
            }
            if (type.equals((Object)DateType.DATE)) {
                return LocalDate.parse(valueString).toEpochDay();
            }
            if (type.equals((Object)TimestampType.TIMESTAMP_MICROS)) {
                return timestampReader.apply(valueString);
            }
            if (type.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
                return timestampWithZoneReader.apply(valueString);
            }
            if (VarcharType.VARCHAR.equals((Object)type)) {
                return Slices.utf8Slice((String)valueString);
            }
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unable to parse value [%s] from column %s with type %s", valueString, column.baseColumnName(), column.baseType()), (Throwable)e);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unable to parse value [%s] from column %s with type %s", valueString, column.baseColumnName(), column.baseType()));
    }

    static Optional<LastCheckpoint> readLastCheckpoint(TrinoFileSystem fileSystem, String tableLocation) {
        return (Optional)Failsafe.with((Policy)RetryPolicy.builder().withMaxRetries(5).withDelay(Duration.ofSeconds(1L)).onRetry(event -> log.debug(event.getLastException(), "Failure when accessing last checkpoint information, will be retried")).build(), (Policy[])new RetryPolicy[0]).get(() -> TransactionLogParser.tryReadLastCheckpoint(fileSystem, tableLocation));
    }

    private static Optional<LastCheckpoint> tryReadLastCheckpoint(TrinoFileSystem fileSystem, String tableLocation) throws JsonParseException, JsonMappingException {
        Optional<LastCheckpoint> optional;
        block9: {
            Location checkpointPath = Location.of((String)TransactionLogUtil.getTransactionLogDir(tableLocation)).appendPath(LAST_CHECKPOINT_FILENAME);
            TrinoInputFile inputFile = fileSystem.newInputFile(checkpointPath);
            TrinoInputStream lastCheckpointInput = inputFile.newStream();
            try {
                optional = Optional.of((LastCheckpoint)JsonUtils.parseJson((ObjectMapper)OBJECT_MAPPER, (InputStream)lastCheckpointInput, LastCheckpoint.class));
                if (lastCheckpointInput == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lastCheckpointInput != null) {
                        try {
                            lastCheckpointInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | JsonMappingException e) {
                    throw e;
                }
                catch (IOException | UncheckedIOException e) {
                    return Optional.empty();
                }
            }
            lastCheckpointInput.close();
        }
        return optional;
    }

    public static long getMandatoryCurrentVersion(TrinoFileSystem fileSystem, String tableLocation, long readVersion) throws IOException {
        long version = readVersion;
        String transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        Location entryPath;
        while (fileSystem.newInputFile(entryPath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, version + 1L)).exists()) {
            ++version;
        }
        return version;
    }
}

