/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntries;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CheckpointBuilder {
    private MetadataEntry metadataEntry;
    private ProtocolEntry protocolEntry;
    private final Map<String, TransactionEntry> transactionEntries = new HashMap<String, TransactionEntry>();
    private final Map<String, AddFileEntry> addFileEntries = new HashMap<String, AddFileEntry>();
    private final Map<String, RemoveFileEntry> removeFileEntries = new HashMap<String, RemoveFileEntry>();

    public void addLogEntry(DeltaLakeTransactionLogEntry logEntry) {
        if (logEntry.getMetaData() != null) {
            this.metadataEntry = logEntry.getMetaData();
        }
        if (logEntry.getProtocol() != null) {
            this.protocolEntry = logEntry.getProtocol();
        }
        this.handleTransactionEntry(logEntry.getTxn());
        this.handleAddFileEntry(logEntry.getAdd());
        this.handleRemoveFileEntry(logEntry.getRemove());
    }

    private void handleTransactionEntry(@Nullable TransactionEntry entry) {
        if (entry == null) {
            return;
        }
        TransactionEntry currentEntry = this.transactionEntries.get(entry.appId());
        if (currentEntry != null && currentEntry.version() > entry.version()) {
            return;
        }
        this.transactionEntries.put(entry.appId(), entry);
    }

    private void handleAddFileEntry(@Nullable AddFileEntry entry) {
        if (entry == null) {
            return;
        }
        this.addFileEntries.put(entry.getPath(), entry);
        this.removeFileEntries.remove(entry.getPath());
    }

    private void handleRemoveFileEntry(@Nullable RemoveFileEntry entry) {
        if (entry == null) {
            return;
        }
        this.removeFileEntries.put(entry.path(), entry);
        this.addFileEntries.remove(entry.path());
    }

    public CheckpointEntries build() {
        Preconditions.checkState((this.metadataEntry != null ? 1 : 0) != 0, (Object)"Metadata entry not registered");
        Preconditions.checkState((this.protocolEntry != null ? 1 : 0) != 0, (Object)"Protocol entry not registered");
        return new CheckpointEntries(this.metadataEntry, this.protocolEntry, (Set<TransactionEntry>)ImmutableSet.copyOf(this.transactionEntries.values()), (Set<AddFileEntry>)ImmutableSet.copyOf(this.addFileEntries.values()), (Set<RemoveFileEntry>)ImmutableSet.copyOf(this.removeFileEntries.values()));
    }
}

