/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class CheckpointFieldReader {
    private final ConnectorSession session;
    private final SqlRow row;
    private final Map<String, Integer> fieldNameToIndex;

    public CheckpointFieldReader(ConnectorSession session, SqlRow row, RowType type) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.row = Objects.requireNonNull(row, "row is null");
        Preconditions.checkArgument((row.getFieldCount() == type.getFields().size() ? 1 : 0) != 0, (Object)"row and type sizes don't match");
        HashMap<String, Integer> fieldNames = new HashMap<String, Integer>();
        for (int i = 0; i < type.getFields().size(); ++i) {
            String fieldName = (String)((RowType.Field)type.getFields().get(i)).getName().orElseThrow();
            Preconditions.checkState((!fieldNames.containsKey(fieldName) ? 1 : 0) != 0, (String)"Duplicated field '%s' exists in %s", (Object)fieldName, (Object)type);
            fieldNames.put(fieldName, i);
        }
        this.fieldNameToIndex = ImmutableMap.copyOf(fieldNames);
    }

    public boolean getBoolean(String fieldName) {
        int field = this.requireField(fieldName);
        ByteArrayBlock valueBlock = (ByteArrayBlock)this.row.getUnderlyingFieldBlock(field);
        return valueBlock.getByte(this.row.getUnderlyingFieldPosition(field)) != 0;
    }

    public int getInt(String fieldName) {
        int field = this.requireField(fieldName);
        IntArrayBlock valueBlock = (IntArrayBlock)this.row.getUnderlyingFieldBlock(field);
        return valueBlock.getInt(this.row.getUnderlyingFieldPosition(field));
    }

    public OptionalInt getOptionalInt(String fieldName) {
        int position;
        OptionalInt index = this.findField(fieldName);
        if (index.isEmpty()) {
            return OptionalInt.empty();
        }
        IntArrayBlock valueBlock = (IntArrayBlock)this.row.getUnderlyingFieldBlock(index.getAsInt());
        if (valueBlock.isNull(position = this.row.getUnderlyingFieldPosition(index.getAsInt()))) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(valueBlock.getInt(position));
    }

    public long getLong(String fieldName) {
        int field = this.requireField(fieldName);
        LongArrayBlock valueBlock = (LongArrayBlock)this.row.getUnderlyingFieldBlock(field);
        return valueBlock.getLong(this.row.getUnderlyingFieldPosition(field));
    }

    @Nullable
    public String getString(String fieldName) {
        int index;
        int field = this.requireField(fieldName);
        VariableWidthBlock valueBlock = (VariableWidthBlock)this.row.getUnderlyingFieldBlock(field);
        if (valueBlock.isNull(index = this.row.getUnderlyingFieldPosition(field))) {
            return null;
        }
        return valueBlock.getSlice(index).toStringUtf8();
    }

    public List<String> getList(ArrayType stringList, String fieldName) {
        int field = this.requireField(fieldName);
        ArrayBlock valueBlock = (ArrayBlock)this.row.getUnderlyingFieldBlock(field);
        return (List)stringList.getObjectValue(this.session, (Block)valueBlock, this.row.getUnderlyingFieldPosition(field));
    }

    public Optional<Set<String>> getOptionalSet(ArrayType stringList, String fieldName) {
        int position;
        OptionalInt index = this.findField(fieldName);
        if (index.isEmpty()) {
            return Optional.empty();
        }
        ArrayBlock valueBlock = (ArrayBlock)this.row.getUnderlyingFieldBlock(index.getAsInt());
        if (valueBlock.isNull(position = this.row.getUnderlyingFieldPosition(index.getAsInt()))) {
            return Optional.empty();
        }
        List list = (List)stringList.getObjectValue(this.session, (Block)valueBlock, position);
        return Optional.of(ImmutableSet.copyOf((Collection)list));
    }

    public Map<String, String> getMap(MapType stringMap, String fieldName) {
        int field = this.requireField(fieldName);
        MapBlock valueBlock = (MapBlock)this.row.getUnderlyingFieldBlock(field);
        return (Map)stringMap.getObjectValue(this.session, (Block)valueBlock, this.row.getUnderlyingFieldPosition(field));
    }

    @Nullable
    public SqlRow getRow(String fieldName) {
        int position;
        OptionalInt index = this.findField(fieldName);
        if (index.isEmpty()) {
            return null;
        }
        RowBlock valueBlock = (RowBlock)this.row.getUnderlyingFieldBlock(index.getAsInt());
        if (valueBlock.isNull(position = this.row.getUnderlyingFieldPosition(index.getAsInt()))) {
            return null;
        }
        return valueBlock.getRow(position);
    }

    private int requireField(String fieldName) {
        return this.findField(fieldName).orElseThrow(() -> new IllegalArgumentException("Field '%s' doesn't exist in %s".formatted(fieldName, this.fieldNameToIndex.keySet())));
    }

    private OptionalInt findField(String fieldName) {
        Integer index = this.fieldNameToIndex.get(fieldName);
        if (index == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(index);
    }
}

