/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.parquet.writer.ParquetSchemaConverter;
import io.trino.parquet.writer.ParquetWriter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeParquetStatisticsUtils;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.parquet.format.CompressionCodec;
import org.joda.time.DateTimeZone;

public class CheckpointWriter {
    private static final int METADATA_BLOCK_CHANNEL = 0;
    private static final int PROTOCOL_BLOCK_CHANNEL = 1;
    private static final int TXN_BLOCK_CHANNEL = 2;
    private static final int ADD_BLOCK_CHANNEL = 3;
    private static final int REMOVE_BLOCK_CHANNEL = 4;
    private static final int CHANNELS_COUNT = 5;
    private final TypeManager typeManager;
    private final CheckpointSchemaManager checkpointSchemaManager;
    private final String trinoVersion;
    private final ParquetWriterOptions parquetWriterOptions;

    public CheckpointWriter(TypeManager typeManager, CheckpointSchemaManager checkpointSchemaManager, String trinoVersion) {
        this(typeManager, checkpointSchemaManager, trinoVersion, ParquetWriterOptions.builder().build());
    }

    @VisibleForTesting
    public CheckpointWriter(TypeManager typeManager, CheckpointSchemaManager checkpointSchemaManager, String trinoVersion, ParquetWriterOptions parquetWriterOptions) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checkpointSchemaManager = Objects.requireNonNull(checkpointSchemaManager, "checkpointSchemaManager is null");
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.parquetWriterOptions = Objects.requireNonNull(parquetWriterOptions, "parquetWriterOptions is null");
    }

    public void write(CheckpointEntries entries, TrinoOutputFile outputFile) throws IOException {
        Map<String, String> configuration = entries.metadataEntry().getConfiguration();
        boolean writeStatsAsJson = Boolean.parseBoolean(configuration.getOrDefault("delta.checkpoint.writeStatsAsJson", "true"));
        boolean writeStatsAsStruct = Boolean.parseBoolean(configuration.getOrDefault("delta.checkpoint.writeStatsAsStruct", "true"));
        ProtocolEntry protocolEntry = entries.protocolEntry();
        RowType metadataEntryType = this.checkpointSchemaManager.getMetadataEntryType();
        RowType protocolEntryType = this.checkpointSchemaManager.getProtocolEntryType(protocolEntry.readerFeatures().isPresent(), protocolEntry.writerFeatures().isPresent());
        RowType txnEntryType = this.checkpointSchemaManager.getTxnEntryType();
        RowType addEntryType = this.checkpointSchemaManager.getAddEntryType(entries.metadataEntry(), entries.protocolEntry(), (Predicate<String>)Predicates.alwaysTrue(), writeStatsAsJson, writeStatsAsStruct, true);
        RowType removeEntryType = this.checkpointSchemaManager.getRemoveEntryType();
        ImmutableList columnNames = ImmutableList.of((Object)"metaData", (Object)"protocol", (Object)"txn", (Object)"add", (Object)"remove");
        ImmutableList columnTypes = ImmutableList.of((Object)metadataEntryType, (Object)protocolEntryType, (Object)txnEntryType, (Object)addEntryType, (Object)removeEntryType);
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter((List)columnTypes, (List)columnNames, false, false);
        ParquetWriter writer = new ParquetWriter(outputFile.create(), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), this.parquetWriterOptions, CompressionCodec.SNAPPY, this.trinoVersion, Optional.of(DateTimeZone.UTC), Optional.empty());
        PageBuilder pageBuilder = new PageBuilder((List)columnTypes);
        this.writeMetadataEntry(pageBuilder, metadataEntryType, entries.metadataEntry());
        this.writeProtocolEntry(pageBuilder, protocolEntryType, entries.protocolEntry());
        for (TransactionEntry transactionEntry : entries.transactionEntries()) {
            this.writeTransactionEntry(pageBuilder, txnEntryType, transactionEntry);
        }
        List<DeltaLakeColumnHandle> partitionColumns = DeltaLakeSchemaSupport.extractPartitionColumns(entries.metadataEntry(), entries.protocolEntry(), this.typeManager);
        List partitionValuesParsedFieldTypes = (List)partitionColumns.stream().map(column -> RowType.field((String)column.basePhysicalColumnName(), (Type)column.type())).collect(ImmutableList.toImmutableList());
        for (AddFileEntry addFileEntry : entries.addFileEntries()) {
            this.writeAddFileEntry(pageBuilder, addEntryType, addFileEntry, entries.metadataEntry(), entries.protocolEntry(), partitionColumns, partitionValuesParsedFieldTypes, writeStatsAsJson, writeStatsAsStruct);
        }
        for (RemoveFileEntry removeFileEntry : entries.removeFileEntries()) {
            this.writeRemoveFileEntry(pageBuilder, removeEntryType, removeFileEntry);
        }
        writer.write(pageBuilder.build());
        writer.close();
    }

    private void writeMetadataEntry(PageBuilder pageBuilder, RowType entryType, MetadataEntry metadataEntry) {
        pageBuilder.declarePosition();
        ((RowBlockBuilder)pageBuilder.getBlockBuilder(0)).buildEntry(fieldBuilders -> {
            this.writeString((BlockBuilder)fieldBuilders.get(0), entryType, 0, "id", metadataEntry.getId());
            this.writeString((BlockBuilder)fieldBuilders.get(1), entryType, 1, "name", metadataEntry.getName());
            this.writeString((BlockBuilder)fieldBuilders.get(2), entryType, 2, "description", metadataEntry.getDescription());
            RowType formatType = this.getInternalRowType(entryType, 3, "format");
            ((RowBlockBuilder)fieldBuilders.get(3)).buildEntry(formatBlockBuilders -> {
                this.writeString((BlockBuilder)formatBlockBuilders.get(0), formatType, 0, "provider", metadataEntry.getFormat().provider());
                this.writeStringMap((BlockBuilder)formatBlockBuilders.get(1), formatType, 1, "options", metadataEntry.getFormat().options());
            });
            this.writeString((BlockBuilder)fieldBuilders.get(4), entryType, 4, "schemaString", metadataEntry.getSchemaString());
            this.writeStringList((BlockBuilder)fieldBuilders.get(5), entryType, 5, "partitionColumns", metadataEntry.getOriginalPartitionColumns());
            this.writeStringMap((BlockBuilder)fieldBuilders.get(6), entryType, 6, "configuration", metadataEntry.getConfiguration());
            this.writeLong((BlockBuilder)fieldBuilders.get(7), entryType, 7, "createdTime", metadataEntry.getCreatedTime());
        });
        this.appendNullOtherBlocks(pageBuilder, 0);
    }

    private void writeProtocolEntry(PageBuilder pageBuilder, RowType entryType, ProtocolEntry protocolEntry) {
        pageBuilder.declarePosition();
        ((RowBlockBuilder)pageBuilder.getBlockBuilder(1)).buildEntry(fieldBuilders -> {
            int fieldId = 0;
            this.writeLong((BlockBuilder)fieldBuilders.get(fieldId), entryType, fieldId, "minReaderVersion", Long.valueOf(protocolEntry.minReaderVersion()));
            this.writeLong((BlockBuilder)fieldBuilders.get(++fieldId), entryType, fieldId, "minWriterVersion", Long.valueOf(protocolEntry.minWriterVersion()));
            ++fieldId;
            if (protocolEntry.readerFeatures().isPresent()) {
                this.writeStringList((BlockBuilder)fieldBuilders.get(fieldId), entryType, fieldId, "readerFeatures", (List)protocolEntry.readerFeatures().get().stream().collect(ImmutableList.toImmutableList()));
                ++fieldId;
            }
            if (protocolEntry.writerFeatures().isPresent()) {
                this.writeStringList((BlockBuilder)fieldBuilders.get(fieldId), entryType, fieldId, "writerFeatures", (List)protocolEntry.writerFeatures().get().stream().collect(ImmutableList.toImmutableList()));
            }
        });
        this.appendNullOtherBlocks(pageBuilder, 1);
    }

    private void writeTransactionEntry(PageBuilder pageBuilder, RowType entryType, TransactionEntry transactionEntry) {
        pageBuilder.declarePosition();
        ((RowBlockBuilder)pageBuilder.getBlockBuilder(2)).buildEntry(fieldBuilders -> {
            this.writeString((BlockBuilder)fieldBuilders.get(0), entryType, 0, "appId", transactionEntry.appId());
            this.writeLong((BlockBuilder)fieldBuilders.get(1), entryType, 1, "version", transactionEntry.version());
            this.writeLong((BlockBuilder)fieldBuilders.get(2), entryType, 2, "lastUpdated", transactionEntry.lastUpdated());
        });
        this.appendNullOtherBlocks(pageBuilder, 2);
    }

    private void writeAddFileEntry(PageBuilder pageBuilder, RowType entryType, AddFileEntry addFileEntry, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, List<DeltaLakeColumnHandle> partitionColumns, List<RowType.Field> partitionValuesParsedFieldTypes, boolean writeStatsAsJson, boolean writeStatsAsStruct) {
        boolean deletionVectorEnabled = DeltaLakeSchemaSupport.isDeletionVectorEnabled(metadataEntry, protocolEntry);
        pageBuilder.declarePosition();
        RowBlockBuilder blockBuilder = (RowBlockBuilder)pageBuilder.getBlockBuilder(3);
        blockBuilder.buildEntry(fieldBuilders -> {
            int fieldId = 0;
            this.writeString((BlockBuilder)fieldBuilders.get(fieldId), entryType, fieldId, "path", addFileEntry.getPath());
            this.writeStringMap((BlockBuilder)fieldBuilders.get(++fieldId), entryType, fieldId, "partitionValues", addFileEntry.getPartitionValues());
            this.writeLong((BlockBuilder)fieldBuilders.get(++fieldId), entryType, fieldId, "size", addFileEntry.getSize());
            this.writeLong((BlockBuilder)fieldBuilders.get(++fieldId), entryType, fieldId, "modificationTime", addFileEntry.getModificationTime());
            this.writeBoolean((BlockBuilder)fieldBuilders.get(++fieldId), entryType, fieldId, "dataChange", addFileEntry.isDataChange());
            ++fieldId;
            if (writeStatsAsJson) {
                this.writeJsonStats((BlockBuilder)fieldBuilders.get(fieldId), entryType, addFileEntry, metadataEntry, protocolEntry, fieldId);
                ++fieldId;
            }
            if (writeStatsAsStruct) {
                if (!addFileEntry.getPartitionValues().isEmpty()) {
                    this.writeParsedPartitionValues((BlockBuilder)fieldBuilders.get(fieldId), entryType, addFileEntry, partitionColumns, partitionValuesParsedFieldTypes, fieldId);
                    ++fieldId;
                }
                this.writeParsedStats((BlockBuilder)fieldBuilders.get(fieldId), entryType, addFileEntry, fieldId);
                ++fieldId;
            }
            this.writeStringMap((BlockBuilder)fieldBuilders.get(fieldId), entryType, fieldId, "tags", addFileEntry.getTags());
            ++fieldId;
            if (deletionVectorEnabled) {
                this.writeDeletionVector((BlockBuilder)fieldBuilders.get(fieldId), entryType, addFileEntry.getDeletionVector(), fieldId);
            }
        });
        this.appendNullOtherBlocks(pageBuilder, 3);
    }

    private void writeJsonStats(BlockBuilder entryBlockBuilder, RowType entryType, AddFileEntry addFileEntry, MetadataEntry metadataEntry, ProtocolEntry protocolEntry, int fieldId) {
        String statsJson = null;
        if (addFileEntry.getStats().isPresent()) {
            DeltaLakeFileStatistics statistics = addFileEntry.getStats().get();
            if (statistics instanceof DeltaLakeParquetFileStatistics) {
                DeltaLakeParquetFileStatistics parquetFileStatistics = (DeltaLakeParquetFileStatistics)statistics;
                Map<String, Type> columnTypeMapping = this.getColumnTypeMapping(metadataEntry, protocolEntry);
                DeltaLakeJsonFileStatistics jsonFileStatistics = new DeltaLakeJsonFileStatistics(parquetFileStatistics.getNumRecords(), parquetFileStatistics.getMinValues().map(values -> DeltaLakeParquetStatisticsUtils.toJsonValues(columnTypeMapping, values)), parquetFileStatistics.getMaxValues().map(values -> DeltaLakeParquetStatisticsUtils.toJsonValues(columnTypeMapping, values)), parquetFileStatistics.getNullCount().map(nullCounts -> DeltaLakeParquetStatisticsUtils.toNullCounts(columnTypeMapping, nullCounts)));
                statsJson = this.getStatsString(jsonFileStatistics).orElse(null);
            } else {
                statsJson = addFileEntry.getStatsString().orElse(null);
            }
        }
        this.writeString(entryBlockBuilder, entryType, fieldId, "stats", statsJson);
    }

    private Map<String, Type> getColumnTypeMapping(MetadataEntry deltaMetadata, ProtocolEntry protocolEntry) {
        return (Map)DeltaLakeSchemaSupport.extractSchema(deltaMetadata, protocolEntry, this.typeManager).stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnMetadata::physicalName, DeltaLakeColumnMetadata::physicalColumnType));
    }

    private Optional<String> getStatsString(DeltaLakeJsonFileStatistics parsedStats) {
        try {
            return Optional.of(DeltaLakeSchemaSupport.serializeStatsAsJson(parsedStats));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    private void writeParsedPartitionValues(BlockBuilder entryBlockBuilder, RowType entryType, AddFileEntry addFileEntry, List<DeltaLakeColumnHandle> partitionColumns, List<RowType.Field> partitionValuesParsedFieldTypes, int fieldId) {
        RowType partitionValuesParsedType = this.getInternalRowType(entryType, fieldId, "partitionValues_parsed");
        ((RowBlockBuilder)entryBlockBuilder).buildEntry(fieldBuilders -> {
            for (int i = 0; i < partitionValuesParsedFieldTypes.size(); ++i) {
                RowType.Field partitionValueField = (RowType.Field)partitionValuesParsedFieldTypes.get(i);
                String partitionColumnName = (String)partitionValueField.getName().orElseThrow();
                String partitionValue = addFileEntry.getPartitionValues().get(partitionColumnName);
                this.validateAndGetField(partitionValuesParsedType, i, partitionColumnName);
                if (partitionValue == null) {
                    ((BlockBuilder)fieldBuilders.get(i)).appendNull();
                    continue;
                }
                DeltaLakeColumnHandle partitionColumn = (DeltaLakeColumnHandle)partitionColumns.get(i);
                Object deserializedPartitionValue = TransactionLogParser.deserializePartitionValue(partitionColumn, Optional.of(partitionValue));
                TypeUtils.writeNativeValue((Type)partitionValueField.getType(), (BlockBuilder)((BlockBuilder)fieldBuilders.get(i)), (Object)deserializedPartitionValue);
            }
        });
    }

    private void writeParsedStats(BlockBuilder entryBlockBuilder, RowType entryType, AddFileEntry addFileEntry, int fieldId) {
        RowType statsType = this.getInternalRowType(entryType, fieldId, "stats_parsed");
        if (addFileEntry.getStats().isEmpty()) {
            entryBlockBuilder.appendNull();
            return;
        }
        DeltaLakeFileStatistics stats = addFileEntry.getStats().get();
        ((RowBlockBuilder)entryBlockBuilder).buildEntry(fieldBuilders -> {
            if (stats instanceof DeltaLakeParquetFileStatistics) {
                this.writeLong((BlockBuilder)fieldBuilders.get(0), statsType, 0, "numRecords", stats.getNumRecords().orElse(null));
                this.writeMinMaxMapAsFields((BlockBuilder)fieldBuilders.get(1), statsType, 1, "minValues", stats.getMinValues(), false);
                this.writeMinMaxMapAsFields((BlockBuilder)fieldBuilders.get(2), statsType, 2, "maxValues", stats.getMaxValues(), false);
                this.writeNullCountAsFields((BlockBuilder)fieldBuilders.get(3), statsType, 3, "nullCount", stats.getNullCount());
            } else {
                int internalFieldId = 0;
                this.writeLong((BlockBuilder)fieldBuilders.get(internalFieldId), statsType, internalFieldId, "numRecords", stats.getNumRecords().orElse(null));
                ++internalFieldId;
                if (statsType.getFields().stream().anyMatch(field -> ((String)field.getName().orElseThrow()).equals("minValues"))) {
                    this.writeMinMaxMapAsFields((BlockBuilder)fieldBuilders.get(internalFieldId), statsType, internalFieldId, "minValues", stats.getMinValues(), true);
                    ++internalFieldId;
                }
                if (statsType.getFields().stream().anyMatch(field -> ((String)field.getName().orElseThrow()).equals("maxValues"))) {
                    this.writeMinMaxMapAsFields((BlockBuilder)fieldBuilders.get(internalFieldId), statsType, internalFieldId, "maxValues", stats.getMaxValues(), true);
                    ++internalFieldId;
                }
                this.writeNullCountAsFields((BlockBuilder)fieldBuilders.get(internalFieldId), statsType, internalFieldId, "nullCount", stats.getNullCount());
            }
        });
    }

    private void writeDeletionVector(BlockBuilder entryBlockBuilder, RowType entryType, Optional<DeletionVectorEntry> deletionVector, int fieldId) {
        if (deletionVector.isEmpty()) {
            entryBlockBuilder.appendNull();
            return;
        }
        RowType type = this.getInternalRowType(entryType, fieldId, "deletionVector");
        ((RowBlockBuilder)entryBlockBuilder).buildEntry(builders -> {
            this.writeString((BlockBuilder)builders.get(0), type, 0, "storageType", ((DeletionVectorEntry)deletionVector.get()).storageType());
            this.writeString((BlockBuilder)builders.get(1), type, 1, "pathOrInlineDv", ((DeletionVectorEntry)deletionVector.get()).pathOrInlineDv());
            this.writeLong((BlockBuilder)builders.get(2), type, 2, "offset", Long.valueOf(((DeletionVectorEntry)deletionVector.get()).offset().orElse(0)));
            this.writeLong((BlockBuilder)builders.get(4), type, 4, "sizeInBytes", Long.valueOf(((DeletionVectorEntry)deletionVector.get()).sizeInBytes()));
            this.writeLong((BlockBuilder)builders.get(5), type, 5, "cardinality", ((DeletionVectorEntry)deletionVector.get()).cardinality());
        });
    }

    private void writeMinMaxMapAsFields(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, Optional<Map<String, Object>> values, boolean isJson) {
        RowType.Field valuesField = this.validateAndGetField(type, fieldId, fieldName);
        RowType valuesFieldType = (RowType)valuesField.getType();
        this.writeObjectMapAsFields(blockBuilder, type, fieldId, fieldName, this.preprocessMinMaxValues(valuesFieldType, values, isJson));
    }

    private void writeNullCountAsFields(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, Optional<Map<String, Object>> values) {
        this.writeObjectMapAsFields(blockBuilder, type, fieldId, fieldName, this.preprocessNullCount(values));
    }

    private void writeObjectMapAsFields(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, Optional<Map<String, Object>> values) {
        if (values.isEmpty()) {
            blockBuilder.appendNull();
            return;
        }
        RowType.Field valuesField = this.validateAndGetField(type, fieldId, fieldName);
        List fields = ((RowType)valuesField.getType()).getFields();
        ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> {
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                BlockBuilder fieldBlockBuilder = (BlockBuilder)fieldBuilders.get(i);
                Object value = ((Map)values.get()).get(field.getName().orElseThrow());
                TypeUtils.writeNativeValue((Type)field.getType(), (BlockBuilder)fieldBlockBuilder, value);
            }
        });
    }

    private Optional<Map<String, Object>> preprocessMinMaxValues(RowType valuesType, Optional<Map<String, Object>> valuesOptional, boolean isJson) {
        return valuesOptional.map(values -> {
            Map<String, Type> fieldTypes = valuesType.getFields().stream().collect(Collectors.toMap(field -> (String)field.getName().orElseThrow(), RowType.Field::getType));
            return values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Type type = (Type)fieldTypes.get(entry.getKey());
                Object value = entry.getValue();
                if (isJson) {
                    return DeltaLakeParquetStatisticsUtils.jsonValueToTrinoValue(type, value);
                }
                if (type == TimestampType.TIMESTAMP_MILLIS) {
                    value = Math.multiplyExact(DateTimeEncoding.unpackMillisUtc((long)((Long)value)), 1000);
                }
                if (type == TimestampType.TIMESTAMP_MICROS) {
                    return value;
                }
                return value;
            }));
        });
    }

    private Optional<Map<String, Object>> preprocessNullCount(Optional<Map<String, Object>> valuesOptional) {
        return valuesOptional.map(values -> values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object value = entry.getValue();
            if (value instanceof Integer) {
                return (long)((Integer)value).intValue();
            }
            return value;
        })));
    }

    private void writeRemoveFileEntry(PageBuilder pageBuilder, RowType entryType, RemoveFileEntry removeFileEntry) {
        pageBuilder.declarePosition();
        ((RowBlockBuilder)pageBuilder.getBlockBuilder(4)).buildEntry(fieldBuilders -> {
            this.writeString((BlockBuilder)fieldBuilders.get(0), entryType, 0, "path", removeFileEntry.path());
            this.writeStringMap((BlockBuilder)fieldBuilders.get(1), entryType, 1, "partitionValues", removeFileEntry.partitionValues());
            this.writeLong((BlockBuilder)fieldBuilders.get(2), entryType, 2, "deletionTimestamp", removeFileEntry.deletionTimestamp());
            this.writeBoolean((BlockBuilder)fieldBuilders.get(3), entryType, 3, "dataChange", removeFileEntry.dataChange());
        });
        this.appendNullOtherBlocks(pageBuilder, 4);
    }

    private void appendNullOtherBlocks(PageBuilder pageBuilder, int handledBlock) {
        for (int channel = 0; channel < 5; ++channel) {
            if (channel == handledBlock) continue;
            pageBuilder.getBlockBuilder(channel).appendNull();
        }
    }

    private void writeString(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable String value) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        field.getType().writeSlice(blockBuilder, Slices.utf8Slice((String)value));
    }

    private void writeLong(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable Long value) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        field.getType().writeLong(blockBuilder, value.longValue());
    }

    private void writeBoolean(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, boolean value) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        field.getType().writeBoolean(blockBuilder, value);
    }

    private void writeStringMap(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable Map<String, String> values) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        Preconditions.checkArgument((boolean)(field.getType() instanceof MapType), (String)"Expected field %s/%s to by of MapType but got %s", (Object)fieldId, (Object)fieldName, (Object)field.getType());
        if (values == null) {
            blockBuilder.appendNull();
            return;
        }
        MapType mapType = (MapType)field.getType();
        ((MapBlockBuilder)blockBuilder).buildEntry((keyBlockBuilder, valueBlockBuilder) -> {
            for (Map.Entry entry : values.entrySet()) {
                mapType.getKeyType().writeSlice(keyBlockBuilder, Slices.utf8Slice((String)((String)entry.getKey())));
                if (entry.getValue() == null) {
                    valueBlockBuilder.appendNull();
                    continue;
                }
                mapType.getValueType().writeSlice(valueBlockBuilder, Slices.utf8Slice((String)((String)entry.getValue())));
            }
        });
    }

    private void writeStringList(BlockBuilder blockBuilder, RowType type, int fieldId, String fieldName, @Nullable List<String> values) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        Preconditions.checkArgument((boolean)(field.getType() instanceof ArrayType), (String)"Expected field %s/%s to by of ArrayType but got %s", (Object)fieldId, (Object)fieldName, (Object)field.getType());
        if (values == null) {
            blockBuilder.appendNull();
            return;
        }
        ArrayType arrayType = (ArrayType)field.getType();
        ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
            for (String value : values) {
                if (value == null) {
                    elementBuilder.appendNull();
                    continue;
                }
                arrayType.getElementType().writeSlice(elementBuilder, Slices.utf8Slice((String)value));
            }
        });
    }

    private RowType getInternalRowType(RowType type, int fieldId, String fieldName) {
        RowType.Field field = this.validateAndGetField(type, fieldId, fieldName);
        Preconditions.checkArgument((boolean)(field.getType() instanceof RowType), (String)"Expected field %s/%s to by of RowType but got %s", (Object)fieldId, (Object)fieldName, (Object)field.getType());
        return (RowType)field.getType();
    }

    private RowType.Field validateAndGetField(RowType type, int fieldId, String fieldName) {
        Preconditions.checkArgument((type.getFields().size() > fieldId ? 1 : 0) != 0, (String)"Field %s/%s not found for type %s", (Object)fieldId, (Object)fieldName, (Object)type);
        RowType.Field field = (RowType.Field)type.getFields().get(fieldId);
        Preconditions.checkArgument((boolean)((String)field.getName().orElseThrow()).equals(fieldName), (String)"Expected %s for field %s but got %s for type %s", (Object)fieldName, (Object)fieldId, (Object)field.getName(), (Object)type);
        return field;
    }
}

