/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MissingTransactionLogException;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogEntries;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransactionLogTail {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TransactionLogTail.class);
    private final List<Transaction> entries;
    private final long version;

    private TransactionLogTail(List<Transaction> entries, long version) {
        this.entries = ImmutableList.copyOf((Collection)Objects.requireNonNull(entries, "entries is null"));
        this.version = version;
    }

    public static TransactionLogTail loadNewTail(TrinoFileSystem fileSystem, String tableLocation, Optional<Long> startVersion, Optional<Long> endVersion, DataSize transactionLogMaxCachedFileSize) throws IOException {
        ImmutableList.Builder entriesBuilder = ImmutableList.builder();
        if (startVersion.isPresent() && endVersion.isPresent() && startVersion.get().equals(endVersion.get())) {
            return new TransactionLogTail((List<Transaction>)entriesBuilder.build(), startVersion.get());
        }
        long version = startVersion.orElse(0L);
        long entryNumber = startVersion.map(start -> start + 1L).orElse(0L);
        Preconditions.checkArgument((endVersion.isEmpty() || entryNumber <= endVersion.get() ? 1 : 0) != 0, (String)"Invalid start/end versions: %s, %s", startVersion, endVersion);
        String transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        boolean endOfTail = false;
        while (!endOfTail) {
            Optional<TransactionLogEntries> results = TransactionLogTail.getEntriesFromJson(entryNumber, transactionLogDir, fileSystem, transactionLogMaxCachedFileSize);
            if (results.isPresent()) {
                entriesBuilder.add((Object)new Transaction(entryNumber, results.get()));
                version = entryNumber++;
            } else {
                if (endVersion.isPresent()) {
                    throw new MissingTransactionLogException(TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, entryNumber).toString());
                }
                endOfTail = true;
            }
            if (!endVersion.isPresent() || version != endVersion.get()) continue;
            endOfTail = true;
        }
        return new TransactionLogTail((List<Transaction>)entriesBuilder.build(), version);
    }

    public Optional<TransactionLogTail> getUpdatedTail(TrinoFileSystem fileSystem, String tableLocation, Optional<Long> endVersion, DataSize transactionLogMaxCachedFileSize) throws IOException {
        Preconditions.checkArgument((endVersion.isEmpty() || endVersion.get() > this.version ? 1 : 0) != 0, (String)"Invalid endVersion, expected higher than %s, but got %s", (long)this.version, endVersion);
        TransactionLogTail newTail = TransactionLogTail.loadNewTail(fileSystem, tableLocation, Optional.of(this.version), endVersion, transactionLogMaxCachedFileSize);
        if (newTail.version == this.version) {
            return Optional.empty();
        }
        return Optional.of(new TransactionLogTail((List<Transaction>)ImmutableList.builder().addAll(this.entries).addAll(newTail.entries).build(), newTail.version));
    }

    public static Optional<TransactionLogEntries> getEntriesFromJson(long entryNumber, String transactionLogDir, TrinoFileSystem fileSystem, DataSize transactionLogMaxCachedFileSize) throws IOException {
        Location transactionLogFilePath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, entryNumber);
        TrinoInputFile inputFile = fileSystem.newInputFile(transactionLogFilePath);
        return TransactionLogTail.getEntriesFromJson(entryNumber, inputFile, transactionLogMaxCachedFileSize);
    }

    public static Optional<TransactionLogEntries> getEntriesFromJson(long entryNumber, TrinoInputFile inputFile, DataSize transactionLogMaxCachedFileSize) throws IOException {
        try {
            inputFile.length();
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
        return Optional.of(new TransactionLogEntries(entryNumber, inputFile, transactionLogMaxCachedFileSize));
    }

    public List<DeltaLakeTransactionLogEntry> getFileEntries(TrinoFileSystem fileSystem) {
        return (List)this.entries.stream().map(Transaction::transactionEntries).flatMap(logEntries -> logEntries.getEntriesList(fileSystem).stream()).collect(ImmutableList.toImmutableList());
    }

    public List<Transaction> getTransactions() {
        return this.entries;
    }

    public long getVersion() {
        return this.version;
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + 8) + SizeOf.estimatedSizeOf(this.entries, Transaction::getRetainedSizeInBytes);
    }
}

