/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.plugin.deltalake.transactionlog.writer.NoIsolationSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TransactionLogSynchronizerManager {
    private final Map<String, TransactionLogSynchronizer> synchronizers;
    private final NoIsolationSynchronizer noIsolationSynchronizer;

    @Inject
    public TransactionLogSynchronizerManager(Map<String, TransactionLogSynchronizer> synchronizers, NoIsolationSynchronizer noIsolationSynchronizer) {
        this.synchronizers = ImmutableMap.copyOf(synchronizers);
        this.noIsolationSynchronizer = Objects.requireNonNull(noIsolationSynchronizer, "noIsolationSynchronizer is null");
    }

    public TransactionLogSynchronizer getSynchronizer(String tableLocation) {
        String uriScheme = (String)Location.of((String)tableLocation).scheme().orElseThrow(() -> new IllegalArgumentException("URI scheme undefined for " + tableLocation));
        TransactionLogSynchronizer synchronizer = this.synchronizers.get(uriScheme.toLowerCase(Locale.ENGLISH));
        if (synchronizer == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Cannot write to table in %s; %s not supported", tableLocation, uriScheme));
        }
        return synchronizer;
    }

    public TransactionLogSynchronizer getNoIsolationSynchronizer() {
        return this.noIsolationSynchronizer;
    }
}

