/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class IdentifierUtils {
    private static final Set<Character> UNQUOTED_IDENTIFIER_INJECTION_CHARACTERS;

    public static boolean isValidIdentifier(String string) {
        if (string.isEmpty()) {
            return true;
        }
        String string2 = string.trim();
        if (IdentifierUtils.isQuotedIdentifier(string2)) {
            return IdentifierUtils.isValidQuotedIdentifier(string2);
        }
        return IdentifierUtils.blacklistApproved(string2);
    }

    private static boolean blacklistApproved(String string) {
        for (char c : string.toCharArray()) {
            if (!UNQUOTED_IDENTIFIER_INJECTION_CHARACTERS.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    private static boolean isQuotedIdentifier(String string) {
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    private static boolean isValidQuotedIdentifier(String string) {
        if (string == null || string.length() <= 2) {
            return false;
        }
        String string2 = string.substring(1, string.length() - 1).replaceAll("\"\"", "");
        return !string2.contains("\"");
    }

    static {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('?'), Character.valueOf('/'), Character.valueOf('|'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('`'), Character.valueOf('~'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('|'), Character.valueOf('\\'), Character.valueOf(' '));
        UNQUOTED_IDENTIFIER_INJECTION_CHARACTERS = Collections.unmodifiableSet(hashSet);
    }
}

